/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.databind.node.ArrayNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.pinot.common.exception.SchemaNotFoundException;
import org.apache.pinot.common.exception.TableNotFoundException;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.api.events.MetadataEventNotifierFactory;
import org.apache.pinot.controller.api.events.SchemaEventType;
import org.apache.pinot.controller.api.resources.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.core.util.SchemaUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.JsonUtils;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Schema"})
@Path(value="/")
public class PinotSchemaRestletResource {
    public static final Logger LOGGER = LoggerFactory.getLogger(PinotSchemaRestletResource.class);
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;
    @Inject
    ControllerMetrics _controllerMetrics;
    @Inject
    MetadataEventNotifierFactory _metadataEventNotifierFactory;

    @GET
    @Produces(value={"application/json"})
    @Path(value="/schemas")
    @ApiOperation(value="List all schema names", notes="Lists all schema names")
    public String listSchemaNames() {
        List<String> schemaNames = this._pinotHelixResourceManager.getSchemaNames();
        ArrayNode ret = JsonUtils.newArrayNode();
        if (schemaNames != null) {
            for (String schema : schemaNames) {
                ret.add(schema);
            }
        }
        return ret.toString();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/schemas/{schemaName}")
    @ApiOperation(value="Get a schema", notes="Gets a schema by name")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Schema not found"), @ApiResponse(code=500, message="Internal error")})
    public String getSchema(@ApiParam(value="Schema name", required=true) @PathParam(value="schemaName") String schemaName) {
        LOGGER.info("looking for schema {}", (Object)schemaName);
        Schema schema = this._pinotHelixResourceManager.getSchema(schemaName);
        if (schema == null) {
            throw new ControllerApplicationException(LOGGER, "Schema not found", Response.Status.NOT_FOUND);
        }
        return schema.toPrettyJsonString();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/schemas/{schemaName}")
    @ApiOperation(value="Delete a schema", notes="Deletes a schema by name")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully deleted schema"), @ApiResponse(code=404, message="Schema not found"), @ApiResponse(code=409, message="Schema is in use"), @ApiResponse(code=500, message="Error deleting schema")})
    public SuccessResponse deleteSchema(@ApiParam(value="Schema name", required=true) @PathParam(value="schemaName") String schemaName) {
        this.deleteSchemaInternal(schemaName);
        return new SuccessResponse("Schema " + schemaName + " deleted");
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/schemas/{schemaName}")
    @ApiOperation(value="Update a schema", notes="Updates a schema")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully updated schema"), @ApiResponse(code=404, message="Schema not found"), @ApiResponse(code=400, message="Missing or invalid request body"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse updateSchema(@ApiParam(value="Name of the schema", required=true) @PathParam(value="schemaName") String schemaName, @ApiParam(value="Whether to reload the table if the new schema is backward compatible") @DefaultValue(value="false") @QueryParam(value="reload") boolean reload, FormDataMultiPart multiPart) {
        return this.updateSchema(schemaName, this.getSchemaFromMultiPart(multiPart), reload);
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/schemas/{schemaName}")
    @ApiOperation(value="Update a schema", notes="Updates a schema")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully updated schema"), @ApiResponse(code=404, message="Schema not found"), @ApiResponse(code=400, message="Missing or invalid request body"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse updateSchema(@ApiParam(value="Name of the schema", required=true) @PathParam(value="schemaName") String schemaName, @ApiParam(value="Whether to reload the table if the new schema is backward compatible") @DefaultValue(value="false") @QueryParam(value="reload") boolean reload, Schema schema) {
        return this.updateSchema(schemaName, schema, reload);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/schemas")
    @ApiOperation(value="Add a new schema", notes="Adds a new schema")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully created schema"), @ApiResponse(code=404, message="Schema not found"), @ApiResponse(code=400, message="Missing or invalid request body"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse addSchema(@ApiParam(value="Whether to override the schema if the schema exists") @DefaultValue(value="true") @QueryParam(value="override") boolean override, FormDataMultiPart multiPart) {
        return this.addSchema(this.getSchemaFromMultiPart(multiPart), override);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/schemas")
    @ApiOperation(value="Add a new schema", notes="Adds a new schema")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully created schema"), @ApiResponse(code=404, message="Schema not found"), @ApiResponse(code=400, message="Missing or invalid request body"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse addSchema(@ApiParam(value="Whether to override the schema if the schema exists") @DefaultValue(value="true") @QueryParam(value="override") boolean override, Schema schema) {
        return this.addSchema(schema, override);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/schemas/validate")
    @ApiOperation(value="Validate schema", notes="This API returns the schema that matches the one you get from 'GET /schema/{schemaName}'. This allows us to validate schema before apply.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully validated schema"), @ApiResponse(code=400, message="Missing or invalid request body"), @ApiResponse(code=500, message="Internal error")})
    public String validateSchema(FormDataMultiPart multiPart) {
        Schema schema = this.getSchemaFromMultiPart(multiPart);
        try {
            SchemaUtils.validate((Schema)schema);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Invalid schema: " + schema.getSchemaName(), Response.Status.BAD_REQUEST, (Throwable)e);
        }
        return schema.toPrettyJsonString();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/schemas/validate")
    @ApiOperation(value="Validate schema", notes="This API returns the schema that matches the one you get from 'GET /schema/{schemaName}'. This allows us to validate schema before apply.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully validated schema"), @ApiResponse(code=400, message="Missing or invalid request body"), @ApiResponse(code=500, message="Internal error")})
    public String validateSchema(Schema schema) {
        try {
            SchemaUtils.validate((Schema)schema);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Invalid schema: " + schema.getSchemaName(), Response.Status.BAD_REQUEST, (Throwable)e);
        }
        return schema.toPrettyJsonString();
    }

    private SuccessResponse addSchema(Schema schema, boolean override) {
        try {
            SchemaUtils.validate((Schema)schema);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Cannot add invalid schema: " + schema.getSchemaName(), Response.Status.BAD_REQUEST, (Throwable)e);
        }
        try {
            this._pinotHelixResourceManager.addSchema(schema, override);
            LOGGER.info("Notifying metadata event for adding new schema {}", (Object)schema.getSchemaName());
            this._metadataEventNotifierFactory.create().notifyOnSchemaEvents(schema, SchemaEventType.CREATE);
            return new SuccessResponse(schema.getSchemaName() + " successfully added");
        }
        catch (Exception e) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_SCHEMA_UPLOAD_ERROR, 1L);
            throw new ControllerApplicationException(LOGGER, String.format("Failed to add new schema %s.", schema.getSchemaName()), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private SuccessResponse updateSchema(String schemaName, Schema schema, boolean reload) {
        try {
            SchemaUtils.validate((Schema)schema);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Cannot add invalid schema: " + schemaName, Response.Status.BAD_REQUEST, (Throwable)e);
        }
        if (schemaName != null && !schema.getSchemaName().equals(schemaName)) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_SCHEMA_UPLOAD_ERROR, 1L);
            String message = "Schema name mismatch for uploaded schema, tried to add schema with name " + schema.getSchemaName() + " as " + schemaName;
            throw new ControllerApplicationException(LOGGER, message, Response.Status.BAD_REQUEST);
        }
        try {
            this._pinotHelixResourceManager.updateSchema(schema, reload);
            LOGGER.info("Notifying metadata event for updating schema: {}", (Object)schemaName);
            this._metadataEventNotifierFactory.create().notifyOnSchemaEvents(schema, SchemaEventType.UPDATE);
            return new SuccessResponse(schema.getSchemaName() + " successfully added");
        }
        catch (SchemaNotFoundException e) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_SCHEMA_UPLOAD_ERROR, 1L);
            throw new ControllerApplicationException(LOGGER, String.format("Failed to find schema %s", schemaName), Response.Status.NOT_FOUND, (Throwable)e);
        }
        catch (TableNotFoundException e) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_SCHEMA_UPLOAD_ERROR, 1L);
            throw new ControllerApplicationException(LOGGER, String.format("Failed to find table %s to reload", schemaName), Response.Status.NOT_FOUND, (Throwable)e);
        }
        catch (Exception e) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_SCHEMA_UPLOAD_ERROR, 1L);
            throw new ControllerApplicationException(LOGGER, String.format("Failed to update schema %s", schemaName), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private Schema getSchemaFromMultiPart(FormDataMultiPart multiPart) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteSchemaInternal(String schemaName) {
        Schema schema = this._pinotHelixResourceManager.getSchema(schemaName);
        if (schema == null) {
            throw new ControllerApplicationException(LOGGER, String.format("Schema %s not found", schemaName), Response.Status.NOT_FOUND);
        }
        List<String> tableNames = this._pinotHelixResourceManager.getAllRealtimeTables();
        for (String tableName : tableNames) {
            TableConfig config = this._pinotHelixResourceManager.getRealtimeTableConfig(tableName);
            String tableSchema = config.getValidationConfig().getSchemaName();
            if (!schemaName.equals(tableSchema)) continue;
            throw new ControllerApplicationException(LOGGER, String.format("Cannot delete schema %s, as it is associated with table %s", schemaName, tableName), Response.Status.CONFLICT);
        }
        LOGGER.info("Trying to delete schema {}", (Object)schemaName);
        if (!this._pinotHelixResourceManager.deleteSchema(schema)) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to delete schema %s", schemaName), Response.Status.INTERNAL_SERVER_ERROR);
        }
        LOGGER.info("Success: Deleted schema {}", (Object)schemaName);
    }
}

