/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.exception.TableNotFoundException;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.OfflineSegmentZKMetadata;
import org.apache.pinot.common.metadata.segment.RealtimeSegmentZKMetadata;
import org.apache.pinot.common.utils.SegmentName;
import org.apache.pinot.common.utils.URIUtils;
import org.apache.pinot.controller.api.resources.Constants;
import org.apache.pinot.controller.api.resources.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.PinotResourceManagerResponse;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Segment"})
@Path(value="/")
public class PinotSegmentRestletResource {
    private static Logger LOGGER = LoggerFactory.getLogger(PinotSegmentRestletResource.class);
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;

    @GET
    @Produces(value={"application/json"})
    @Path(value="/segments/{tableName}")
    @ApiOperation(value="List all segments", notes="List all segments")
    public List<Map<TableType, List<String>>> getSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        List<String> tableNamesWithType = this.getExistingTableNamesWithType(tableName, Constants.validateTableType(tableTypeStr));
        ArrayList<Map<TableType, List<String>>> resultList = new ArrayList<Map<TableType, List<String>>>(tableNamesWithType.size());
        for (String tableNameWithType : tableNamesWithType) {
            TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
            List<String> segments = this._pinotHelixResourceManager.getSegmentsFor(tableNameWithType);
            resultList.add(Collections.singletonMap(tableType, segments));
        }
        return resultList;
    }

    @GET
    @Path(value="segments/{tableName}/servers")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a map from server to segments hosted by the server", notes="Get a map from server to segments hosted by the server")
    public List<Map<String, Object>> getServerToSegmentsMap(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        List<String> tableNamesWithType = this.getExistingTableNamesWithType(tableName, Constants.validateTableType(tableTypeStr));
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(tableNamesWithType.size());
        for (String tableNameWithType : tableNamesWithType) {
            LinkedHashMap<String, Object> resultForTable = new LinkedHashMap<String, Object>();
            resultForTable.put("tableName", tableNameWithType);
            resultForTable.put("serverToSegmentsMap", this._pinotHelixResourceManager.getServerToSegmentsMap(tableNameWithType));
            resultList.add(resultForTable);
        }
        return resultList;
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a map from server to segments hosted by the server (deprecated, use 'GET /segments/{tableName}/servers' instead)", notes="Get a map from server to segments hosted by the server (deprecated, use 'GET /segments/{tableName}/servers' instead)")
    public List<Map<String, String>> getServerToSegmentsMapDeprecated1(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="MUST be null") @QueryParam(value="state") String stateStr, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) throws JsonProcessingException {
        if (stateStr != null) {
            throw new WebApplicationException("Cannot toggle segment state", Response.Status.FORBIDDEN);
        }
        List<String> tableNamesWithType = this.getExistingTableNamesWithType(tableName, Constants.validateTableType(tableTypeStr));
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>(tableNamesWithType.size());
        for (String tableNameWithType : tableNamesWithType) {
            LinkedHashMap<String, String> resultForTable = new LinkedHashMap<String, String>();
            resultForTable.put("tableName", tableNameWithType);
            resultForTable.put("segments", JsonUtils.objectToString(this._pinotHelixResourceManager.getServerToSegmentsMap(tableNameWithType)));
            resultList.add(resultForTable);
        }
        return resultList;
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments/metadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a map from server to segments hosted by the server (deprecated, use 'GET /segments/{tableName}/servers' instead)", notes="Get a map from server to segments hosted by the server (deprecated, use 'GET /segments/{tableName}/servers' instead)")
    public List<Map<String, String>> getServerToSegmentsMapDeprecated2(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="MUST be null") @QueryParam(value="state") String stateStr, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) throws JsonProcessingException {
        return this.getServerToSegmentsMapDeprecated1(tableName, stateStr, tableTypeStr);
    }

    @GET
    @Path(value="segments/{tableName}/crc")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a map from segment to CRC of the segment (only apply to OFFLINE table)", notes="Get a map from segment to CRC of the segment (only apply to OFFLINE table)")
    public Map<String, String> getSegmentToCrcMap(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName) {
        String offlineTableName = this.getExistingTableNamesWithType(tableName, TableType.OFFLINE).get(0);
        return this._pinotHelixResourceManager.getSegmentsCrcForTable(offlineTableName);
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments/crc")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a map from segment to CRC of the segment (deprecated, use 'GET /segments/{tableName}/crc' instead)", notes="Get a map from segment to CRC of the segment (deprecated, use 'GET /segments/{tableName}/crc' instead)")
    public Map<String, String> getSegmentToCrcMapDeprecated(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName) {
        return this.getSegmentToCrcMap(tableName);
    }

    @GET
    @Path(value="segments/{tableName}/{segmentName}/metadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the metadata for a segment", notes="Get the metadata for a segment")
    public Map<String, String> getSegmentMetadata(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName) {
        TableType tableType = SegmentName.isRealtimeSegmentName((String)(segmentName = URIUtils.decode((String)segmentName))) ? TableType.REALTIME : TableType.OFFLINE;
        String tableNameWithType = this.getExistingTableNamesWithType(tableName, tableType).get(0);
        Map<String, String> segmentMetadata = this.getSegmentMetadataInternal(tableNameWithType, segmentName);
        if (segmentMetadata != null) {
            return segmentMetadata;
        }
        throw new ControllerApplicationException(LOGGER, "Failed to find segment: " + segmentName + " in table: " + tableName, Response.Status.NOT_FOUND);
    }

    @Nullable
    private Map<String, String> getSegmentMetadataInternal(String tableNameWithType, String segmentName) {
        ZkHelixPropertyStore<ZNRecord> propertyStore = this._pinotHelixResourceManager.getPropertyStore();
        if (TableNameBuilder.isOfflineTableResource((String)tableNameWithType)) {
            OfflineSegmentZKMetadata offlineSegmentZKMetadata = ZKMetadataProvider.getOfflineSegmentZKMetadata(propertyStore, (String)tableNameWithType, (String)segmentName);
            return offlineSegmentZKMetadata != null ? offlineSegmentZKMetadata.toMap() : null;
        }
        RealtimeSegmentZKMetadata realtimeSegmentZKMetadata = ZKMetadataProvider.getRealtimeSegmentZKMetadata(propertyStore, (String)tableNameWithType, (String)segmentName);
        return realtimeSegmentZKMetadata != null ? realtimeSegmentZKMetadata.toMap() : null;
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments/{segmentName}/metadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the metadata for a segment (deprecated, use 'GET /segments/{tableName}/{segmentName}/metadata' instead)", notes="Get the metadata for a segment (deprecated, use 'GET /segments/{tableName}/{segmentName}/metadata' instead)")
    public List<List<Map<String, Object>>> getSegmentMetadataDeprecated1(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        segmentName = URIUtils.decode((String)segmentName);
        TableType tableType = Constants.validateTableType(tableTypeStr);
        List<String> tableNamesWithType = this.getExistingTableNamesWithType(tableName, tableType);
        ArrayList<List<Map<String, Object>>> resultList = new ArrayList<List<Map<String, Object>>>(tableNamesWithType.size());
        for (String tableNameWithType : tableNamesWithType) {
            Map<String, String> segmentMetadata = this.getSegmentMetadata(tableNameWithType, segmentName);
            if (segmentMetadata == null) continue;
            LinkedHashMap<String, Object> resultForTable = new LinkedHashMap<String, Object>();
            resultForTable.put("tableName", tableNameWithType);
            resultForTable.put("state", segmentMetadata);
            resultList.add(Collections.singletonList(resultForTable));
        }
        if (resultList.isEmpty()) {
            String errorMessage = "Failed to find segment: " + segmentName + " in table: " + tableName;
            if (tableType != null) {
                errorMessage = errorMessage + " of type: " + tableType;
            }
            throw new ControllerApplicationException(LOGGER, errorMessage, Response.Status.NOT_FOUND);
        }
        return resultList;
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments/{segmentName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the metadata for a segment (deprecated, use 'GET /segments/{tableName}/{segmentName}/metadata' instead)", notes="Get the metadata for a segment (deprecated, use 'GET /segments/{tableName}/{segmentName}/metadata' instead)")
    public List<List<Map<String, Object>>> getSegmentMetadataDeprecated2(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="MUST be null") @QueryParam(value="state") String stateStr, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        if (stateStr != null) {
            throw new WebApplicationException("Cannot toggle segment state", Response.Status.FORBIDDEN);
        }
        return this.getSegmentMetadataDeprecated1(tableName, segmentName, tableTypeStr);
    }

    @POST
    @Path(value="segments/{tableName}/{segmentName}/reload")
    @Produces(value={"application/json"})
    @ApiOperation(value="Reload a segment", notes="Reload a segment")
    public SuccessResponse reloadSegment(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName) {
        TableType tableType = SegmentName.isRealtimeSegmentName((String)(segmentName = URIUtils.decode((String)segmentName))) ? TableType.REALTIME : TableType.OFFLINE;
        String tableNameWithType = this.getExistingTableNamesWithType(tableName, tableType).get(0);
        int numMessagesSent = this._pinotHelixResourceManager.reloadSegment(tableNameWithType, segmentName);
        if (numMessagesSent > 0) {
            return new SuccessResponse("Sent " + numMessagesSent + " reload messages");
        }
        throw new ControllerApplicationException(LOGGER, "Failed to find segment: " + segmentName + " in table: " + tableName, Response.Status.NOT_FOUND);
    }

    @Deprecated
    @POST
    @Path(value="tables/{tableName}/segments/{segmentName}/reload")
    @Produces(value={"application/json"})
    @ApiOperation(value="Reload a segment (deprecated, use 'POST /segments/{tableName}/{segmentName}/reload' instead)", notes="Reload a segment (deprecated, use 'POST /segments/{tableName}/{segmentName}/reload' instead)")
    public SuccessResponse reloadSegmentDeprecated1(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        segmentName = URIUtils.decode((String)segmentName);
        List<String> tableNamesWithType = this.getExistingTableNamesWithType(tableName, Constants.validateTableType(tableTypeStr));
        int numMessagesSent = 0;
        for (String tableNameWithType : tableNamesWithType) {
            numMessagesSent += this._pinotHelixResourceManager.reloadSegment(tableNameWithType, segmentName);
        }
        return new SuccessResponse("Sent " + numMessagesSent + " reload messages");
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments/{segmentName}/reload")
    @Produces(value={"application/json"})
    @ApiOperation(value="Reload a segment (deprecated, use 'POST /segments/{tableName}/{segmentName}/reload' instead)", notes="Reload a segment (deprecated, use 'POST /segments/{tableName}/{segmentName}/reload' instead)")
    public SuccessResponse reloadSegmentDeprecated2(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        return this.reloadSegmentDeprecated1(tableName, segmentName, tableTypeStr);
    }

    @POST
    @Path(value="segments/{tableName}/reload")
    @Produces(value={"application/json"})
    @ApiOperation(value="Reload all segments", notes="Reload all segments")
    public SuccessResponse reloadAllSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        List<String> tableNamesWithType = this.getExistingTableNamesWithType(tableName, Constants.validateTableType(tableTypeStr));
        LinkedHashMap<String, Integer> numMessagesSentPerTable = new LinkedHashMap<String, Integer>();
        for (String tableNameWithType : tableNamesWithType) {
            numMessagesSentPerTable.put(tableNameWithType, this._pinotHelixResourceManager.reloadAllSegments(tableNameWithType));
        }
        return new SuccessResponse("Sent " + numMessagesSentPerTable + " reload messages");
    }

    @Deprecated
    @POST
    @Path(value="tables/{tableName}/segments/reload")
    @Produces(value={"application/json"})
    @ApiOperation(value="Reload all segments (deprecated, use 'POST /segments/{tableName}/reload' instead)", notes="Reload all segments (deprecated, use 'POST /segments/{tableName}/reload' instead)")
    public SuccessResponse reloadAllSegmentsDeprecated1(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        List<String> tableNamesWithType = this.getExistingTableNamesWithType(tableName, Constants.validateTableType(tableTypeStr));
        int numMessagesSent = 0;
        for (String tableNameWithType : tableNamesWithType) {
            numMessagesSent += this._pinotHelixResourceManager.reloadAllSegments(tableNameWithType);
        }
        return new SuccessResponse("Sent " + numMessagesSent + " reload messages");
    }

    @Deprecated
    @GET
    @Path(value="tables/{tableName}/segments/reload")
    @Produces(value={"application/json"})
    @ApiOperation(value="Reload all segments (deprecated, use 'POST /segments/{tableName}/reload' instead)", notes="Reload all segments (deprecated, use 'POST /segments/{tableName}/reload' instead)")
    public SuccessResponse reloadAllSegmentsDeprecated2(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String tableTypeStr) {
        return this.reloadAllSegmentsDeprecated1(tableName, tableTypeStr);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/segments/{tableName}/{segmentName}")
    @ApiOperation(value="Delete a segment", notes="Delete a segment")
    public SuccessResponse deleteSegment(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName) {
        TableType tableType = SegmentName.isRealtimeSegmentName((String)(segmentName = URIUtils.decode((String)segmentName))) ? TableType.REALTIME : TableType.OFFLINE;
        String tableNameWithType = this.getExistingTableNamesWithType(tableName, tableType).get(0);
        this.deleteSegmentsInternal(tableNameWithType, Collections.singletonList(segmentName));
        return new SuccessResponse("Segment deleted");
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/segments/{tableName}")
    @ApiOperation(value="Delete all segments", notes="Delete all segments")
    public SuccessResponse deleteAllSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME", required=true) @QueryParam(value="type") String tableTypeStr) {
        TableType tableType = Constants.validateTableType(tableTypeStr);
        if (tableType == null) {
            throw new ControllerApplicationException(LOGGER, "Table type must not be null", Response.Status.BAD_REQUEST);
        }
        String tableNameWithType = this.getExistingTableNamesWithType(tableName, tableType).get(0);
        this.deleteSegmentsInternal(tableNameWithType, this._pinotHelixResourceManager.getSegmentsFor(tableNameWithType));
        return new SuccessResponse("All segments of table " + tableNameWithType + " deleted");
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/segments/{tableName}/delete")
    @ApiOperation(value="Delete the segments in the JSON array payload", notes="Delete the segments in the JSON array payload")
    public SuccessResponse deleteSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, List<String> segments) {
        int numSegments = segments.size();
        if (numSegments == 0) {
            throw new ControllerApplicationException(LOGGER, "Segments must be provided", Response.Status.BAD_REQUEST);
        }
        boolean isRealtimeSegment = SegmentName.isRealtimeSegmentName((String)segments.get(0));
        for (int i = 1; i < numSegments; ++i) {
            if (SegmentName.isRealtimeSegmentName((String)segments.get(i)) == isRealtimeSegment) continue;
            throw new ControllerApplicationException(LOGGER, "All segments must be of the same type (OFFLINE|REALTIME)", Response.Status.BAD_REQUEST);
        }
        TableType tableType = isRealtimeSegment ? TableType.REALTIME : TableType.OFFLINE;
        String tableNameWithType = this.getExistingTableNamesWithType(tableName, tableType).get(0);
        this.deleteSegmentsInternal(tableNameWithType, segments);
        if (numSegments <= 5) {
            return new SuccessResponse("Deleted segments: " + segments + " from table: " + tableNameWithType);
        }
        return new SuccessResponse("Deleted " + numSegments + " segments from table: " + tableNameWithType);
    }

    private void deleteSegmentsInternal(String tableNameWithType, List<String> segments) {
        PinotResourceManagerResponse response = this._pinotHelixResourceManager.deleteSegments(tableNameWithType, segments);
        if (!response.isSuccessful()) {
            throw new ControllerApplicationException(LOGGER, "Failed to delete segments from table: " + tableNameWithType + ", error message: " + response.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private List<String> getExistingTableNamesWithType(String tableName, @Nullable TableType tableType) {
        try {
            return this._pinotHelixResourceManager.getExistingTableNamesWithType(tableName, tableType);
        }
        catch (TableNotFoundException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (IllegalArgumentException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.FORBIDDEN);
        }
    }
}

