/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.JsonUtils;

@Api(tags={"Table"})
@Path(value="/")
public class PinotTableInstances {
    @Inject
    PinotHelixResourceManager pinotHelixResourceManager;

    @GET
    @Path(value="/tables/{tableName}/instances")
    @Produces(value={"application/json"})
    @ApiOperation(value="List table instances", notes="List instances of the given table")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Table not found"), @ApiResponse(code=500, message="Internal server error")})
    public String getTableInstances(@ApiParam(value="Table name without type", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Instance type", example="broker", allowableValues="BROKER, SERVER") @DefaultValue(value="") @QueryParam(value="type") String type) {
        ArrayNode a;
        ObjectNode e;
        ObjectNode ret = JsonUtils.newObjectNode();
        ret.put("tableName", tableName);
        ArrayNode brokers = JsonUtils.newArrayNode();
        ArrayNode servers = JsonUtils.newArrayNode();
        if (type == null || type.isEmpty() || type.toLowerCase().equals("broker")) {
            if (this.pinotHelixResourceManager.hasOfflineTable(tableName)) {
                e = JsonUtils.newObjectNode();
                e.put("tableType", "offline");
                a = JsonUtils.newArrayNode();
                for (String ins : this.pinotHelixResourceManager.getBrokerInstancesForTable(tableName, TableType.OFFLINE)) {
                    a.add(ins);
                }
                e.set("instances", (JsonNode)a);
                brokers.add((JsonNode)e);
            }
            if (this.pinotHelixResourceManager.hasRealtimeTable(tableName)) {
                e = JsonUtils.newObjectNode();
                e.put("tableType", "realtime");
                a = JsonUtils.newArrayNode();
                for (String ins : this.pinotHelixResourceManager.getBrokerInstancesForTable(tableName, TableType.REALTIME)) {
                    a.add(ins);
                }
                e.set("instances", (JsonNode)a);
                brokers.add((JsonNode)e);
            }
        }
        if (type == null || type.isEmpty() || type.toLowerCase().equals("server")) {
            if (this.pinotHelixResourceManager.hasOfflineTable(tableName)) {
                e = JsonUtils.newObjectNode();
                e.put("tableType", "offline");
                a = JsonUtils.newArrayNode();
                for (String ins : this.pinotHelixResourceManager.getServerInstancesForTable(tableName, TableType.OFFLINE)) {
                    a.add(ins);
                }
                e.set("instances", (JsonNode)a);
                servers.add((JsonNode)e);
            }
            if (this.pinotHelixResourceManager.hasRealtimeTable(tableName)) {
                e = JsonUtils.newObjectNode();
                e.put("tableType", "realtime");
                a = JsonUtils.newArrayNode();
                for (String ins : this.pinotHelixResourceManager.getServerInstancesForTable(tableName, TableType.REALTIME)) {
                    a.add(ins);
                }
                e.set("instances", (JsonNode)a);
                servers.add((JsonNode)e);
            }
        }
        ret.set("brokers", (JsonNode)brokers);
        ret.set("server", (JsonNode)servers);
        return ret.toString();
    }
}

