/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.controller.api.resources.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.PinotResourceManagerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Api(tags={"Table", "Tenant"})
public class PinotTableTenantConfigs {
    @Inject
    PinotHelixResourceManager _helixResourceManager;
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotTableTenantConfigs.class);

    @POST
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/rebuildBrokerResourceFromHelixTags")
    @ApiOperation(value="Rebuild broker resource for table", notes="when new brokers are added")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Bad request: table name has to be with table type"), @ApiResponse(code=500, message="Internal error rebuilding broker resource or serializing response")})
    public SuccessResponse rebuildBrokerResource(@ApiParam(value="Table name (with type)", required=true) @PathParam(value="tableName") String tableNameWithType) {
        try {
            PinotResourceManagerResponse pinotResourceManagerResponse = this._helixResourceManager.rebuildBrokerResourceFromHelixTags(tableNameWithType);
            return new SuccessResponse(pinotResourceManagerResponse.getMessage());
        }
        catch (InvalidConfigException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

