/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.google.common.collect.BiMap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.pinot.common.http.MultiGetRequest;
import org.apache.pinot.common.restlet.resources.SegmentSizeInfo;
import org.apache.pinot.common.restlet.resources.TableSizeInfo;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTableSizeReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerTableSizeReader.class);
    private final Executor _executor;
    private final HttpConnectionManager _connectionManager;

    public ServerTableSizeReader(Executor executor, HttpConnectionManager connectionManager) {
        this._executor = executor;
        this._connectionManager = connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<SegmentSizeInfo>> getSegmentSizeInfoFromServers(BiMap<String, String> serverEndPoints, String tableNameWithType, int timeoutMs) {
        int numServers = serverEndPoints.size();
        LOGGER.info("Reading segment sizes from {} servers for table: {} with timeout: {}ms", new Object[]{numServers, tableNameWithType, timeoutMs});
        ArrayList<String> serverUrls = new ArrayList<String>(numServers);
        BiMap endpointsToServers = serverEndPoints.inverse();
        for (String endpoint : endpointsToServers.keySet()) {
            String tableSizeUri = "http://" + endpoint + "/table/" + tableNameWithType + "/size";
            serverUrls.add(tableSizeUri);
        }
        CompletionService completionService = new MultiGetRequest(this._executor, this._connectionManager).execute(serverUrls, timeoutMs);
        HashMap<String, List<SegmentSizeInfo>> serverToSegmentSizeInfoListMap = new HashMap<String, List<SegmentSizeInfo>>();
        for (int i = 0; i < numServers; ++i) {
            GetMethod getMethod = null;
            try {
                getMethod = (GetMethod)completionService.take().get();
                URI uri = getMethod.getURI();
                String instance = (String)endpointsToServers.get((Object)(uri.getHost() + ":" + uri.getPort()));
                if (getMethod.getStatusCode() >= 300) {
                    LOGGER.error("Server: {} returned error: {}", (Object)instance, (Object)getMethod.getStatusCode());
                    continue;
                }
                TableSizeInfo tableSizeInfo = (TableSizeInfo)JsonUtils.inputStreamToObject((InputStream)getMethod.getResponseBodyAsStream(), TableSizeInfo.class);
                serverToSegmentSizeInfoListMap.put(instance, tableSizeInfo.segments);
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            finally {
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
            }
        }
        int numServersResponded = serverToSegmentSizeInfoListMap.size();
        if (numServersResponded != numServers) {
            LOGGER.warn("Finish reading segment sizes for table: {} with {}/{} servers responded", new Object[]{tableNameWithType, numServersResponded, numServers});
        } else {
            LOGGER.info("Finish reading segment sizes for table: {}", (Object)tableNameWithType);
        }
        return serverToSegmentSizeInfoListMap;
    }
}

