/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class WebApplicationExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebApplicationExceptionMapper.class);

    public Response toResponse(Throwable t) {
        int status = 500;
        if (!(t instanceof WebApplicationException)) {
            LOGGER.error("Server error: ", t);
        } else {
            status = ((WebApplicationException)t).getResponse().getStatus();
        }
        ErrorInfo einfo = new ErrorInfo(status, t.getMessage());
        try {
            return Response.status((int)status).entity((Object)JsonUtils.objectToString((Object)einfo)).type("application/json").build();
        }
        catch (JsonProcessingException e) {
            String err = String.format("{\"status\":%d, \"error\":%s}", einfo.code, einfo.error);
            return Response.status((int)status).entity((Object)err).type("application/json").build();
        }
    }

    public static class ErrorInfo {
        public int code;
        public String error;

        @JsonCreator
        public ErrorInfo(@JsonProperty(value="code") int code, @JsonProperty(value="error") String message) {
            this.code = code;
            this.error = message;
        }
    }
}

