/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.helix.task.TaskState;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.OfflineSegmentZKMetadata;
import org.apache.pinot.common.metadata.segment.RealtimeSegmentZKMetadata;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.minion.PinotHelixTaskResourceManager;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

public class ClusterInfoProvider {
    private final PinotHelixResourceManager _pinotHelixResourceManager;
    private final PinotHelixTaskResourceManager _pinotHelixTaskResourceManager;
    private final ControllerConf _controllerConf;

    public ClusterInfoProvider(PinotHelixResourceManager pinotHelixResourceManager, PinotHelixTaskResourceManager pinotHelixTaskResourceManager, ControllerConf controllerConf) {
        this._pinotHelixResourceManager = pinotHelixResourceManager;
        this._pinotHelixTaskResourceManager = pinotHelixTaskResourceManager;
        this._controllerConf = controllerConf;
    }

    @Nullable
    public TableConfig getTableConfig(String tableNameWithType) {
        return this._pinotHelixResourceManager.getTableConfig(tableNameWithType);
    }

    @Nullable
    public Schema getTableSchema(String tableName) {
        return this._pinotHelixResourceManager.getTableSchema(tableName);
    }

    public List<OfflineSegmentZKMetadata> getOfflineSegmentsMetadata(String tableName) {
        return ZKMetadataProvider.getOfflineSegmentZKMetadataListForTable(this._pinotHelixResourceManager.getPropertyStore(), (String)tableName);
    }

    public List<RealtimeSegmentZKMetadata> getRealtimeSegmentsMetadata(String tableName) {
        return ZKMetadataProvider.getRealtimeSegmentZKMetadataListForTable(this._pinotHelixResourceManager.getPropertyStore(), (String)tableName);
    }

    public Map<String, TaskState> getTaskStates(String taskType) {
        return this._pinotHelixTaskResourceManager.getTaskStates(taskType);
    }

    public List<PinotTaskConfig> getTaskConfigs(String taskName) {
        return this._pinotHelixTaskResourceManager.getTaskConfigs(taskName);
    }

    public String getVipUrl() {
        return this._controllerConf.generateVipUrl();
    }
}

