/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoProvider;
import org.apache.pinot.controller.helix.core.minion.PinotHelixTaskResourceManager;
import org.apache.pinot.controller.helix.core.minion.generator.PinotTaskGenerator;
import org.apache.pinot.controller.helix.core.minion.generator.TaskGeneratorRegistry;
import org.apache.pinot.controller.helix.core.periodictask.ControllerPeriodicTask;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableTaskConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotTaskManager
extends ControllerPeriodicTask<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotTaskManager.class);
    private final PinotHelixTaskResourceManager _helixTaskResourceManager;
    private final ClusterInfoProvider _clusterInfoProvider;
    private final TaskGeneratorRegistry _taskGeneratorRegistry;

    public PinotTaskManager(PinotHelixTaskResourceManager helixTaskResourceManager, PinotHelixResourceManager helixResourceManager, LeadControllerManager leadControllerManager, ControllerConf controllerConf, ControllerMetrics controllerMetrics) {
        super("PinotTaskManager", controllerConf.getTaskManagerFrequencyInSeconds(), controllerConf.getPinotTaskManagerInitialDelaySeconds(), helixResourceManager, leadControllerManager, controllerMetrics);
        this._helixTaskResourceManager = helixTaskResourceManager;
        this._clusterInfoProvider = new ClusterInfoProvider(helixResourceManager, helixTaskResourceManager, controllerConf);
        this._taskGeneratorRegistry = new TaskGeneratorRegistry(this._clusterInfoProvider);
    }

    public ClusterInfoProvider getClusterInfoProvider() {
        return this._clusterInfoProvider;
    }

    public void registerTaskGenerator(PinotTaskGenerator pinotTaskGenerator) {
        this._taskGeneratorRegistry.registerTaskGenerator(pinotTaskGenerator);
    }

    public synchronized Map<String, String> scheduleTasks() {
        Map<String, String> tasksScheduled = this.scheduleTasks(this._pinotHelixResourceManager.getAllTables());
        this.cleanUpTask();
        this.setUpTask();
        return tasksScheduled;
    }

    private synchronized Map<String, String> scheduleTasks(List<String> tableNamesWithType) {
        this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.NUMBER_TIMES_SCHEDULE_TASKS_CALLED, 1L);
        Set<String> taskTypes = this._taskGeneratorRegistry.getAllTaskTypes();
        int numTaskTypes = taskTypes.size();
        HashMap enabledTableConfigMap = new HashMap(numTaskTypes);
        for (String taskType : taskTypes) {
            enabledTableConfigMap.put(taskType, new ArrayList());
            this._helixTaskResourceManager.ensureTaskQueueExists(taskType);
        }
        for (String tableNameWithType : tableNamesWithType) {
            TableTaskConfig taskConfig;
            TableConfig tableConfig = this._pinotHelixResourceManager.getTableConfig(tableNameWithType);
            if (tableConfig == null || (taskConfig = tableConfig.getTaskConfig()) == null) continue;
            for (String taskType : taskTypes) {
                if (!taskConfig.isTaskTypeEnabled(taskType)) continue;
                ((List)enabledTableConfigMap.get(taskType)).add(tableConfig);
            }
        }
        HashMap<String, String> tasksScheduled = new HashMap<String, String>(numTaskTypes);
        for (String taskType : taskTypes) {
            LOGGER.info("Generating tasks for task type: {}", (Object)taskType);
            PinotTaskGenerator pinotTaskGenerator = this._taskGeneratorRegistry.getTaskGenerator(taskType);
            List<PinotTaskConfig> pinotTaskConfigs = pinotTaskGenerator.generateTasks((List)enabledTableConfigMap.get(taskType));
            int numTasks = pinotTaskConfigs.size();
            if (numTasks <= 0) continue;
            LOGGER.info("Submitting {} tasks for task type: {} with task configs: {}", new Object[]{numTasks, taskType, pinotTaskConfigs});
            tasksScheduled.put(taskType, this._helixTaskResourceManager.submitTask(pinotTaskConfigs, pinotTaskGenerator.getTaskTimeoutMs(), pinotTaskGenerator.getNumConcurrentTasksPerInstance()));
            this._controllerMetrics.addMeteredTableValue(taskType, (AbstractMetrics.Meter)ControllerMeter.NUMBER_TASKS_SUBMITTED, (long)numTasks);
        }
        return tasksScheduled;
    }

    @Override
    protected void processTables(List<String> tableNamesWithType) {
        this.scheduleTasks(tableNamesWithType);
    }

    public void cleanUpTask() {
        LOGGER.info("Cleaning up all task generators");
        for (String taskType : this._taskGeneratorRegistry.getAllTaskTypes()) {
            this._taskGeneratorRegistry.getTaskGenerator(taskType).nonLeaderCleanUp();
        }
    }
}

