/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion.generator;

import com.clearspring.analytics.util.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoProvider;
import org.apache.pinot.controller.helix.core.minion.generator.ConvertToRawIndexTaskGenerator;
import org.apache.pinot.controller.helix.core.minion.generator.PinotTaskGenerator;

public class TaskGeneratorRegistry {
    private final Map<String, PinotTaskGenerator> _taskGeneratorRegistry = new HashMap<String, PinotTaskGenerator>();

    public TaskGeneratorRegistry(@Nonnull ClusterInfoProvider clusterInfoProvider) {
        this.registerTaskGenerator(new ConvertToRawIndexTaskGenerator(clusterInfoProvider));
    }

    public void registerTaskGenerator(@Nonnull PinotTaskGenerator pinotTaskGenerator) {
        String taskType = pinotTaskGenerator.getTaskType();
        Preconditions.checkArgument((!taskType.contains("_") ? 1 : 0) != 0, (String)"Task type: %s cannot contain underscore character", (Object[])new Object[]{taskType});
        this._taskGeneratorRegistry.put(taskType, pinotTaskGenerator);
    }

    @Nonnull
    public Set<String> getAllTaskTypes() {
        return this._taskGeneratorRegistry.keySet();
    }

    public PinotTaskGenerator getTaskGenerator(@Nonnull String taskType) {
        return this._taskGeneratorRegistry.get(taskType);
    }
}

