/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.realtime.segment;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.apache.pinot.common.metadata.segment.LLCRealtimeSegmentZKMetadata;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.controller.helix.core.realtime.segment.CommittingSegmentDescriptor;
import org.apache.pinot.controller.helix.core.realtime.segment.FlushThresholdUpdater;
import org.apache.pinot.spi.stream.PartitionLevelStreamConfig;
import org.apache.pinot.spi.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentSizeBasedFlushThresholdUpdater
implements FlushThresholdUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentSizeBasedFlushThresholdUpdater.class);
    static final double CURRENT_SEGMENT_RATIO_WEIGHT = 0.1;
    static final double PREVIOUS_SEGMENT_RATIO_WEIGHT = 0.9;
    static final double ROWS_MULTIPLIER_WHEN_TIME_THRESHOLD_HIT = 1.1;
    static final int MINIMUM_NUM_ROWS_THRESHOLD = 10000;
    private double _latestSegmentRowsToSizeRatio = 0.0;

    @VisibleForTesting
    double getLatestSegmentRowsToSizeRatio() {
        return this._latestSegmentRowsToSizeRatio;
    }

    @Override
    public synchronized void updateFlushThreshold(PartitionLevelStreamConfig streamConfig, LLCRealtimeSegmentZKMetadata newSegmentZKMetadata, CommittingSegmentDescriptor committingSegmentDescriptor, @Nullable LLCRealtimeSegmentZKMetadata committingSegmentZKMetadata, int maxNumPartitionsPerInstance) {
        long desiredSegmentSizeBytes = streamConfig.getFlushSegmentDesiredSizeBytes();
        long timeThresholdMillis = streamConfig.getFlushThresholdTimeMillis();
        int autotuneInitialRows = streamConfig.getFlushAutotuneInitialRows();
        long optimalSegmentSizeBytesMin = desiredSegmentSizeBytes / 2L;
        double optimalSegmentSizeBytesMax = (double)desiredSegmentSizeBytes * 1.5;
        String newSegmentName = newSegmentZKMetadata.getSegmentName();
        if (committingSegmentZKMetadata == null) {
            if (this._latestSegmentRowsToSizeRatio > 0.0) {
                long targetSegmentNumRows = (long)((double)desiredSegmentSizeBytes * this._latestSegmentRowsToSizeRatio);
                targetSegmentNumRows = this.capNumRowsIfOverflow(targetSegmentNumRows);
                LOGGER.info("Committing segment zk metadata is not available, using prev ratio {}, setting rows threshold for {} as {}", new Object[]{this._latestSegmentRowsToSizeRatio, newSegmentName, targetSegmentNumRows});
                newSegmentZKMetadata.setSizeThresholdToFlushSegment((int)targetSegmentNumRows);
            } else {
                LOGGER.info("Committing segment zk metadata is not available, setting threshold for {} as {}", (Object)newSegmentName, (Object)autotuneInitialRows);
                newSegmentZKMetadata.setSizeThresholdToFlushSegment(autotuneInitialRows);
            }
            return;
        }
        long committingSegmentSizeBytes = committingSegmentDescriptor.getSegmentSizeBytes();
        if (committingSegmentSizeBytes <= 0L) {
            int targetNumRows = committingSegmentZKMetadata.getSizeThresholdToFlushSegment();
            LOGGER.info("Committing segment size is not available, setting thresholds from previous segment for {} as {}", (Object)newSegmentName, (Object)targetNumRows);
            newSegmentZKMetadata.setSizeThresholdToFlushSegment(targetNumRows);
            return;
        }
        long timeConsumed = System.currentTimeMillis() - committingSegmentZKMetadata.getCreationTime();
        long numRowsConsumed = committingSegmentZKMetadata.getTotalDocs();
        int numRowsThreshold = committingSegmentZKMetadata.getSizeThresholdToFlushSegment();
        LOGGER.info("{}: Data from committing segment: Time {}  numRows {} threshold {} segmentSize(bytes) {}", new Object[]{newSegmentName, TimeUtils.convertMillisToPeriod((Long)timeConsumed), numRowsConsumed, numRowsThreshold, committingSegmentSizeBytes});
        double currentRatio = (double)numRowsConsumed / (double)committingSegmentSizeBytes;
        if (new LLCSegmentName(newSegmentName).getPartitionId() == 0 || this._latestSegmentRowsToSizeRatio == 0.0) {
            this._latestSegmentRowsToSizeRatio = this._latestSegmentRowsToSizeRatio > 0.0 ? 0.1 * currentRatio + 0.9 * this._latestSegmentRowsToSizeRatio : currentRatio;
        }
        if (numRowsConsumed < (long)numRowsThreshold && committingSegmentSizeBytes < desiredSegmentSizeBytes) {
            long currentNumRows = numRowsConsumed;
            StringBuilder logStringBuilder = new StringBuilder().append("Time threshold reached. ");
            if (timeThresholdMillis < timeConsumed) {
                currentNumRows = timeThresholdMillis * numRowsConsumed / timeConsumed;
                logStringBuilder.append(" Detected lower time threshold, adjusting numRowsConsumed to ").append(currentNumRows).append(". ");
            }
            long targetSegmentNumRows = (long)((double)currentNumRows * 1.1);
            targetSegmentNumRows = this.capNumRowsIfOverflow(targetSegmentNumRows);
            logStringBuilder.append("Setting segment size for {} as {}");
            LOGGER.info(logStringBuilder.toString(), (Object)newSegmentName, (Object)targetSegmentNumRows);
            newSegmentZKMetadata.setSizeThresholdToFlushSegment((int)targetSegmentNumRows);
            return;
        }
        long targetSegmentNumRows = committingSegmentSizeBytes < optimalSegmentSizeBytesMin ? numRowsConsumed + numRowsConsumed / 2L : ((double)committingSegmentSizeBytes > optimalSegmentSizeBytesMax ? numRowsConsumed / 2L : (this._latestSegmentRowsToSizeRatio > 0.0 ? (long)((double)desiredSegmentSizeBytes * this._latestSegmentRowsToSizeRatio) : (long)((double)desiredSegmentSizeBytes * currentRatio)));
        targetSegmentNumRows = this.capNumRowsIfOverflow(targetSegmentNumRows);
        LOGGER.info("Committing segment size {}, current ratio {}, setting threshold for {} as {}", new Object[]{committingSegmentSizeBytes, this._latestSegmentRowsToSizeRatio, newSegmentName, targetSegmentNumRows});
        newSegmentZKMetadata.setSizeThresholdToFlushSegment((int)targetSegmentNumRows);
    }

    private long capNumRowsIfOverflow(long targetSegmentNumRows) {
        if (targetSegmentNumRows > Integer.MAX_VALUE) {
            targetSegmentNumRows = Integer.MAX_VALUE;
        }
        return Math.max(targetSegmentNumRows, 10000L);
    }
}

