/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.rebalance;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeoutException;
import org.I0Itec.zkclient.exception.ZkBadVersionException;
import org.apache.commons.configuration.Configuration;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.store.HelixPropertyStore;
import org.apache.pinot.common.assignment.InstanceAssignmentConfigUtils;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.common.assignment.InstancePartitionsUtils;
import org.apache.pinot.controller.helix.core.assignment.instance.InstanceAssignmentDriver;
import org.apache.pinot.controller.helix.core.assignment.segment.SegmentAssignmentFactory;
import org.apache.pinot.controller.helix.core.assignment.segment.SegmentAssignmentUtils;
import org.apache.pinot.controller.helix.core.rebalance.RebalanceResult;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;
import org.apache.pinot.spi.stream.StreamConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRebalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableRebalancer.class);
    private static final long EXTERNAL_VIEW_CHECK_INTERVAL_MS = 1000L;
    private static final long EXTERNAL_VIEW_STABILIZATION_MAX_WAIT_MS = 3600000L;
    private final HelixManager _helixManager;
    private final HelixDataAccessor _helixDataAccessor;

    public TableRebalancer(HelixManager helixManager) {
        this._helixManager = helixManager;
        this._helixDataAccessor = helixManager.getHelixDataAccessor();
    }

    /*
     * Unable to fully structure code
     */
    public RebalanceResult rebalance(TableConfig tableConfig, Configuration rebalanceConfig) {
        startTimeMs = System.currentTimeMillis();
        tableNameWithType = tableConfig.getTableName();
        dryRun = rebalanceConfig.getBoolean("dryRun", false);
        reassignInstances = rebalanceConfig.getBoolean("reassignInstances", false);
        includeConsuming = rebalanceConfig.getBoolean("includeConsuming", false);
        bootstrap = rebalanceConfig.getBoolean("bootstrap", false);
        downtime = rebalanceConfig.getBoolean("downtime", false);
        minReplicasToKeepUpForNoDowntime = rebalanceConfig.getInt("minReplicasToKeepUpForNoDowntime", 1);
        bestEfforts = rebalanceConfig.getBoolean("bestEfforts", false);
        TableRebalancer.LOGGER.info("Start rebalancing table: {} with dryRun: {}, reassignInstances: {}, includeConsuming: {}, bootstrap: {}, downtime: {}, minReplicasToKeepUpForNoDowntime: {}, bestEfforts: {}", new Object[]{tableNameWithType, dryRun, reassignInstances, includeConsuming, bootstrap, downtime, minReplicasToKeepUpForNoDowntime, bestEfforts});
        try {
            if (tableConfig.getTableType() == TableType.REALTIME && new StreamConfig(tableNameWithType, tableConfig.getIndexingConfig().getStreamConfigs()).hasHighLevelConsumerType()) {
                TableRebalancer.LOGGER.warn("Cannot rebalance table: {} with high-level consumer, aborting the rebalance", (Object)tableNameWithType);
                return new RebalanceResult(RebalanceResult.Status.FAILED, "Cannot rebalance table with high-level consumer", null, null);
            }
        }
        catch (Exception e) {
            TableRebalancer.LOGGER.warn("Caught exception while validating table config for table: {}, aborting the rebalance", (Object)tableNameWithType, (Object)e);
            return new RebalanceResult(RebalanceResult.Status.FAILED, "Caught exception while validating table config: " + e, null, null);
        }
        idealStatePropertyKey = this._helixDataAccessor.keyBuilder().idealStates(tableNameWithType);
        try {
            currentIdealState = (IdealState)this._helixDataAccessor.getProperty(idealStatePropertyKey);
        }
        catch (Exception e) {
            TableRebalancer.LOGGER.warn("Caught exception while fetching IdealState for table: {}, aborting the rebalance", (Object)tableNameWithType, (Object)e);
            return new RebalanceResult(RebalanceResult.Status.FAILED, "Caught exception while fetching IdealState: " + e, null, null);
        }
        if (currentIdealState == null) {
            TableRebalancer.LOGGER.warn("Cannot find the IdealState for table: {}, aborting the rebalance", (Object)tableNameWithType);
            return new RebalanceResult(RebalanceResult.Status.FAILED, "Cannot find the IdealState for table", null, null);
        }
        if (!currentIdealState.isEnabled() && !downtime) {
            TableRebalancer.LOGGER.warn("Cannot rebalance disabled table: {} without downtime, aborting the rebalance", (Object)tableNameWithType);
            return new RebalanceResult(RebalanceResult.Status.FAILED, "Cannot rebalance disabled table without downtime", null, null);
        }
        TableRebalancer.LOGGER.info("Fetching/computing instance partitions, reassigning instances if configured for table: {}", (Object)tableNameWithType);
        instancePartitionsMap = new TreeMap<InstancePartitionsType, InstancePartitions>();
        try {
            if (tableConfig.getTableType() == TableType.OFFLINE) {
                instancePartitionsMap.put(InstancePartitionsType.OFFLINE, this.getInstancePartitions(tableConfig, InstancePartitionsType.OFFLINE, reassignInstances, dryRun));
            } else {
                instancePartitionsMap.put(InstancePartitionsType.CONSUMING, this.getInstancePartitions(tableConfig, InstancePartitionsType.CONSUMING, reassignInstances, dryRun));
                if (InstanceAssignmentConfigUtils.shouldRelocateCompletedSegments((TableConfig)tableConfig)) {
                    TableRebalancer.LOGGER.info("COMPLETED segments should be relocated, fetching/computing COMPLETED instance partitions for table: {}", (Object)tableNameWithType);
                    instancePartitionsMap.put(InstancePartitionsType.COMPLETED, this.getInstancePartitions(tableConfig, InstancePartitionsType.COMPLETED, reassignInstances, dryRun));
                } else {
                    TableRebalancer.LOGGER.info("COMPLETED segments should not be relocated, skipping fetching/computing COMPLETED instance partitions for table: {}", (Object)tableNameWithType);
                    if (!dryRun) {
                        instancePartitionsName = InstancePartitionsUtils.getInstancePartitionsName((String)tableNameWithType, (InstancePartitionsType)InstancePartitionsType.COMPLETED);
                        TableRebalancer.LOGGER.info("Removing instance partitions: {} from ZK if it exists", (Object)instancePartitionsName);
                        InstancePartitionsUtils.removeInstancePartitions((HelixPropertyStore)this._helixManager.getHelixPropertyStore(), (String)instancePartitionsName);
                    }
                }
            }
        }
        catch (Exception e) {
            TableRebalancer.LOGGER.warn("Caught exception while fetching/calculating instance partitions for table: {}, aborting the rebalance", (Object)tableNameWithType, (Object)e);
            return new RebalanceResult(RebalanceResult.Status.FAILED, "Caught exception while fetching/calculating instance partitions: " + e, null, null);
        }
        TableRebalancer.LOGGER.info("Calculating the target assignment for table: {}", (Object)tableNameWithType);
        segmentAssignment = SegmentAssignmentFactory.getSegmentAssignment(this._helixManager, tableConfig);
        currentAssignment = currentIdealState.getRecord().getMapFields();
        try {
            targetAssignment = segmentAssignment.rebalanceTable(currentAssignment, instancePartitionsMap, rebalanceConfig);
        }
        catch (Exception e) {
            TableRebalancer.LOGGER.warn("Caught exception while calculating target assignment for table: {}, aborting the rebalance", (Object)tableNameWithType, (Object)e);
            return new RebalanceResult(RebalanceResult.Status.FAILED, "Caught exception while calculating target assignment: " + e, instancePartitionsMap, null);
        }
        if (currentAssignment.equals(targetAssignment)) {
            TableRebalancer.LOGGER.info("Table: {} is already balanced", (Object)tableNameWithType);
            if (reassignInstances) {
                if (dryRun) {
                    return new RebalanceResult(RebalanceResult.Status.DONE, "Instance reassigned in dry-run mode, table is already balanced", instancePartitionsMap, targetAssignment);
                }
                return new RebalanceResult(RebalanceResult.Status.DONE, "Instance reassigned, table is already balanced", instancePartitionsMap, targetAssignment);
            }
            return new RebalanceResult(RebalanceResult.Status.NO_OP, "Table is already balanced", instancePartitionsMap, targetAssignment);
        }
        if (dryRun) {
            TableRebalancer.LOGGER.info("Rebalancing table: {} in dry-run mode, returning the target assignment", (Object)tableNameWithType);
            return new RebalanceResult(RebalanceResult.Status.DONE, "Dry-run mode", instancePartitionsMap, targetAssignment);
        }
        if (downtime) {
            TableRebalancer.LOGGER.info("Rebalancing table: {} with downtime", (Object)tableNameWithType);
            while (true) lbl-1000:
            // 2 sources

            {
                idealStateRecord = currentIdealState.getRecord();
                idealStateRecord.setMapFields(targetAssignment);
                currentIdealState.setNumPartitions(targetAssignment.size());
                currentIdealState.setReplicas(Integer.toString(targetAssignment.values().iterator().next().size()));
                try {
                    Preconditions.checkState((boolean)this._helixDataAccessor.getBaseDataAccessor().set(idealStatePropertyKey.getPath(), (Object)idealStateRecord, idealStateRecord.getVersion(), AccessOption.PERSISTENT), (Object)"Failed to update IdealState");
                    TableRebalancer.LOGGER.info("Finished rebalancing table: {} with downtime in {}ms.", (Object)tableNameWithType, (Object)(System.currentTimeMillis() - startTimeMs));
                    return new RebalanceResult(RebalanceResult.Status.DONE, "Success with downtime (replaced IdealState with the target segment assignment, ExternalView might not reach the target segment assignment yet)", instancePartitionsMap, targetAssignment);
                }
                catch (ZkBadVersionException e) {
                    TableRebalancer.LOGGER.info("IdealState version changed for table: {}, re-calculating the target assignment", (Object)tableNameWithType);
                    try {
                        idealState = (IdealState)this._helixDataAccessor.getProperty(idealStatePropertyKey);
                        Preconditions.checkState((boolean)(idealState != null), (Object)"Failed to find the IdealState");
                        currentIdealState = idealState;
                        currentAssignment = currentIdealState.getRecord().getMapFields();
                        targetAssignment = segmentAssignment.rebalanceTable(currentAssignment, instancePartitionsMap, rebalanceConfig);
                        continue;
                    }
                    catch (Exception e1) {
                        TableRebalancer.LOGGER.warn("Caught exception while re-calculating the target assignment for table: {}, aborting the rebalance", (Object)tableNameWithType, (Object)e1);
                        return new RebalanceResult(RebalanceResult.Status.FAILED, "Caught exception while re-calculating the target assignment: " + e1, instancePartitionsMap, targetAssignment);
                    }
                }
                ** while (true)
                catch (Exception e) {
                    TableRebalancer.LOGGER.warn("Caught exception while updating IdealState for table: {}, aborting the rebalance", (Object)tableNameWithType, (Object)e);
                    return new RebalanceResult(RebalanceResult.Status.FAILED, "Caught exception while updating IdealState: " + e, instancePartitionsMap, targetAssignment);
                }
                break;
            }
        }
        numCurrentReplicas = ((Map)currentAssignment.values().iterator().next()).size();
        numTargetReplicas = targetAssignment.values().iterator().next().size();
        numReplicas = Math.min(numCurrentReplicas, numTargetReplicas);
        if (minReplicasToKeepUpForNoDowntime >= 0) {
            if (minReplicasToKeepUpForNoDowntime >= numReplicas) {
                TableRebalancer.LOGGER.warn("Illegal config for minReplicasToKeepUpForNoDowntime: {} for table: {}, must be less than number of replicas (current: {}, target: {}), aborting the rebalance", new Object[]{minReplicasToKeepUpForNoDowntime, tableNameWithType, numCurrentReplicas, numTargetReplicas});
                return new RebalanceResult(RebalanceResult.Status.FAILED, "Illegal min available replicas config", instancePartitionsMap, targetAssignment);
            }
            minAvailableReplicas = minReplicasToKeepUpForNoDowntime;
        } else {
            minAvailableReplicas = Math.max(numReplicas + minReplicasToKeepUpForNoDowntime, 0);
        }
        TableRebalancer.LOGGER.info("Rebalancing table: {} with minAvailableReplicas: {}, bestEfforts: {}", new Object[]{tableNameWithType, minAvailableReplicas, bestEfforts});
        expectedVersion = currentIdealState.getRecord().getVersion();
        while (true) {
            try {
                idealState = this.waitForExternalViewToConverge(tableNameWithType, bestEfforts);
            }
            catch (Exception e) {
                TableRebalancer.LOGGER.warn("Caught exception while waiting for ExternalView to converge for table: {}, aborting the rebalance", (Object)tableNameWithType, (Object)e);
                return new RebalanceResult(RebalanceResult.Status.FAILED, "Caught exception while waiting for ExternalView to converge: " + e, instancePartitionsMap, targetAssignment);
            }
            if (idealState.getRecord().getVersion() != expectedVersion) {
                TableRebalancer.LOGGER.info("IdealState version changed while waiting for ExternalView to converge for table: {}, re-calculating the target assignment", (Object)tableNameWithType);
                try {
                    currentIdealState = idealState;
                    currentAssignment = currentIdealState.getRecord().getMapFields();
                    targetAssignment = segmentAssignment.rebalanceTable(currentAssignment, instancePartitionsMap, rebalanceConfig);
                    expectedVersion = currentIdealState.getRecord().getVersion();
                }
                catch (Exception e) {
                    TableRebalancer.LOGGER.warn("Caught exception while re-calculating the target assignment for table: {}, aborting the rebalance", (Object)tableNameWithType, (Object)e);
                    return new RebalanceResult(RebalanceResult.Status.FAILED, "Caught exception while re-calculating the target assignment: " + e, instancePartitionsMap, targetAssignment);
                }
            }
            if (currentAssignment.equals(targetAssignment)) {
                TableRebalancer.LOGGER.info("Finished rebalancing table: {} with minAvailableReplicas: {}, bestEfforts: {} in {}ms.", new Object[]{tableNameWithType, minAvailableReplicas, bestEfforts, System.currentTimeMillis() - startTimeMs});
                return new RebalanceResult(RebalanceResult.Status.DONE, "Success with minAvailableReplicas: " + minAvailableReplicas + " (both IdealState and ExternalView should reach the target segment assignment)", instancePartitionsMap, targetAssignment);
            }
            nextAssignment = TableRebalancer.getNextAssignment(currentAssignment, targetAssignment, minAvailableReplicas);
            TableRebalancer.LOGGER.info("Got the next assignment for table: {} with number of segments to be moved to each instance: {}", (Object)tableNameWithType, SegmentAssignmentUtils.getNumSegmentsToBeMovedPerInstance(currentAssignment, nextAssignment));
            idealStateRecord = currentIdealState.getRecord();
            idealStateRecord.setMapFields(nextAssignment);
            currentIdealState.setNumPartitions(nextAssignment.size());
            currentIdealState.setReplicas(Integer.toString(nextAssignment.values().iterator().next().size()));
            try {
                Preconditions.checkState((boolean)this._helixDataAccessor.getBaseDataAccessor().set(idealStatePropertyKey.getPath(), (Object)idealStateRecord, expectedVersion, AccessOption.PERSISTENT), (Object)"Failed to update IdealState");
                currentAssignment = nextAssignment;
                ++expectedVersion;
                TableRebalancer.LOGGER.info("Successfully updated the IdealState for table: {}", (Object)tableNameWithType);
                continue;
            }
            catch (ZkBadVersionException e) {
                TableRebalancer.LOGGER.info("Version changed while updating IdealState for table: {}", (Object)tableNameWithType);
                continue;
            }
            catch (Exception e) {
                TableRebalancer.LOGGER.warn("Caught exception while updating IdealState for table: {}, aborting the rebalance", (Object)tableNameWithType, (Object)e);
                return new RebalanceResult(RebalanceResult.Status.FAILED, "Caught exception while updating IdealState: " + e, instancePartitionsMap, targetAssignment);
            }
            break;
        }
    }

    private InstancePartitions getInstancePartitions(TableConfig tableConfig, InstancePartitionsType instancePartitionsType, boolean reassignInstances, boolean dryRun) {
        String tableNameWithType = tableConfig.getTableName();
        if (InstanceAssignmentConfigUtils.allowInstanceAssignment((TableConfig)tableConfig, (InstancePartitionsType)instancePartitionsType)) {
            if (reassignInstances) {
                LOGGER.info("Reassigning {} instances for table: {}", (Object)instancePartitionsType, (Object)tableNameWithType);
                InstanceAssignmentDriver instanceAssignmentDriver = new InstanceAssignmentDriver(tableConfig);
                InstancePartitions instancePartitions = instanceAssignmentDriver.assignInstances(instancePartitionsType, this._helixDataAccessor.getChildValues(this._helixDataAccessor.keyBuilder().instanceConfigs()));
                if (!dryRun) {
                    LOGGER.info("Persisting instance partitions: {} to ZK", (Object)instancePartitions);
                    InstancePartitionsUtils.persistInstancePartitions((HelixPropertyStore)this._helixManager.getHelixPropertyStore(), (InstancePartitions)instancePartitions);
                }
                return instancePartitions;
            }
            LOGGER.info("Fetching/computing {} instance partitions for table: {}", (Object)instancePartitionsType, (Object)tableNameWithType);
            return InstancePartitionsUtils.fetchOrComputeInstancePartitions((HelixManager)this._helixManager, (TableConfig)tableConfig, (InstancePartitionsType)instancePartitionsType);
        }
        LOGGER.info("{} instance assignment is not allowed, using default instance partitions for table: {}", (Object)instancePartitionsType, (Object)tableNameWithType);
        if (reassignInstances) {
            LOGGER.warn("Cannot reassign {} instances (instance assignment is not allowed) for table: {}", (Object)instancePartitionsType, (Object)tableNameWithType);
        }
        InstancePartitions instancePartitions = InstancePartitionsUtils.computeDefaultInstancePartitions((HelixManager)this._helixManager, (TableConfig)tableConfig, (InstancePartitionsType)instancePartitionsType);
        if (!dryRun) {
            String instancePartitionsName = instancePartitions.getInstancePartitionsName();
            LOGGER.info("Removing instance partitions: {} from ZK if it exists", (Object)instancePartitionsName);
            InstancePartitionsUtils.removeInstancePartitions((HelixPropertyStore)this._helixManager.getHelixPropertyStore(), (String)instancePartitionsName);
        }
        return instancePartitions;
    }

    private IdealState waitForExternalViewToConverge(String tableNameWithType, boolean bestEfforts) throws InterruptedException, TimeoutException {
        IdealState idealState;
        long endTimeMs = System.currentTimeMillis() + 3600000L;
        do {
            Preconditions.checkState(((idealState = (IdealState)this._helixDataAccessor.getProperty(this._helixDataAccessor.keyBuilder().idealStates(tableNameWithType))) != null ? 1 : 0) != 0, (Object)"Failed to find the IdealState");
            ExternalView externalView = (ExternalView)this._helixDataAccessor.getProperty(this._helixDataAccessor.keyBuilder().externalView(tableNameWithType));
            if (externalView != null && TableRebalancer.isExternalViewConverged(tableNameWithType, externalView.getRecord().getMapFields(), idealState.getRecord().getMapFields(), bestEfforts)) {
                LOGGER.info("ExternalView converged for table: {}", (Object)tableNameWithType);
                return idealState;
            }
            Thread.sleep(1000L);
        } while (System.currentTimeMillis() < endTimeMs);
        if (bestEfforts) {
            LOGGER.warn("ExternalView has not converged within: {}ms for table: {}, continuing the rebalance (best-efforts)", (Object)3600000L, (Object)tableNameWithType);
            return idealState;
        }
        throw new TimeoutException("Timeout while waiting for ExternalView to converge");
    }

    @VisibleForTesting
    static boolean isExternalViewConverged(String tableNameWithType, Map<String, Map<String, String>> externalViewSegmentStates, Map<String, Map<String, String>> idealStateSegmentStates, boolean bestEfforts) {
        for (Map.Entry<String, Map<String, String>> entry : idealStateSegmentStates.entrySet()) {
            String segmentName = entry.getKey();
            Map<String, String> externalViewInstanceStateMap = externalViewSegmentStates.get(segmentName);
            Map<String, String> idealStateInstanceStateMap = entry.getValue();
            for (Map.Entry<String, String> instanceStateEntry : idealStateInstanceStateMap.entrySet()) {
                String idealStateInstanceState = instanceStateEntry.getValue();
                if (idealStateInstanceState.equals("OFFLINE")) continue;
                if (externalViewInstanceStateMap == null) {
                    return false;
                }
                String instanceName = instanceStateEntry.getKey();
                String externalViewInstanceState = externalViewInstanceStateMap.get(instanceName);
                if (idealStateInstanceState.equals(externalViewInstanceState)) continue;
                if ("ERROR".equals(externalViewInstanceState)) {
                    if (bestEfforts) {
                        LOGGER.warn("Found ERROR instance: {} for segment: {}, table: {}, counting it as good state (best-efforts)", new Object[]{instanceName, segmentName, tableNameWithType});
                        continue;
                    }
                    LOGGER.warn("Found ERROR instance: {} for segment: {}, table: {}", new Object[]{instanceName, segmentName, tableNameWithType});
                    throw new IllegalStateException("Found segments in ERROR state");
                }
                return false;
            }
        }
        return true;
    }

    private static Map<String, Map<String, String>> getNextAssignment(Map<String, Map<String, String>> currentAssignment, Map<String, Map<String, String>> targetAssignment, int minAvailableReplicas) {
        TreeMap<String, Map<String, String>> nextAssignment = new TreeMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : currentAssignment.entrySet()) {
            String segmentName = entry.getKey();
            nextAssignment.put(segmentName, TableRebalancer.getNextInstanceStateMap(entry.getValue(), targetAssignment.get(segmentName), minAvailableReplicas));
        }
        return nextAssignment;
    }

    @VisibleForTesting
    static Map<String, String> getNextInstanceStateMap(Map<String, String> currentInstanceStateMap, Map<String, String> targetInstanceStateMap, int minAvailableReplicas) {
        int instancesToAdd;
        TreeMap<String, String> nextInstanceStateMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : targetInstanceStateMap.entrySet()) {
            String string = entry.getKey();
            if (!currentInstanceStateMap.containsKey(string)) continue;
            nextInstanceStateMap.put(string, (String)entry.getValue());
        }
        int instancesToKeep = minAvailableReplicas - nextInstanceStateMap.size();
        if (instancesToKeep > 0) {
            for (Map.Entry entry : currentInstanceStateMap.entrySet()) {
                String instanceName = (String)entry.getKey();
                if (nextInstanceStateMap.containsKey(instanceName)) continue;
                nextInstanceStateMap.put(instanceName, (String)entry.getValue());
                if (--instancesToKeep != 0) continue;
                break;
            }
        }
        if ((instancesToAdd = targetInstanceStateMap.size() - nextInstanceStateMap.size()) > 0) {
            for (Map.Entry<String, String> entry : targetInstanceStateMap.entrySet()) {
                String instanceName = entry.getKey();
                if (nextInstanceStateMap.containsKey(instanceName)) continue;
                nextInstanceStateMap.put(instanceName, entry.getValue());
                if (--instancesToAdd != 0) continue;
                break;
            }
        }
        return nextInstanceStateMap;
    }
}

