/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.relocation;

import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutorService;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.pinot.common.assignment.InstanceAssignmentConfigUtils;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.periodictask.ControllerPeriodicTask;
import org.apache.pinot.controller.helix.core.rebalance.RebalanceResult;
import org.apache.pinot.controller.helix.core.rebalance.TableRebalancer;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.utils.TimeUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeSegmentRelocator
extends ControllerPeriodicTask<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealtimeSegmentRelocator.class);
    private final ExecutorService _executorService;

    public RealtimeSegmentRelocator(PinotHelixResourceManager pinotHelixResourceManager, LeadControllerManager leadControllerManager, ControllerConf config, ControllerMetrics controllerMetrics, ExecutorService executorService) {
        super("RealtimeSegmentRelocator", RealtimeSegmentRelocator.getRunFrequencySeconds(config.getRealtimeSegmentRelocatorFrequency()), config.getRealtimeSegmentRelocationInitialDelayInSeconds(), pinotHelixResourceManager, leadControllerManager, controllerMetrics);
        this._executorService = executorService;
    }

    @Override
    protected void processTable(String tableNameWithType) {
        if (!TableNameBuilder.isRealtimeTableResource((String)tableNameWithType)) {
            return;
        }
        TableConfig tableConfig = this._pinotHelixResourceManager.getTableConfig(tableNameWithType);
        Preconditions.checkState((tableConfig != null ? 1 : 0) != 0, (String)"Failed to find table config for table: {}", (Object)tableNameWithType);
        if (new StreamConfig(tableNameWithType, tableConfig.getIndexingConfig().getStreamConfigs()).hasHighLevelConsumerType()) {
            return;
        }
        if (!InstanceAssignmentConfigUtils.shouldRelocateCompletedSegments((TableConfig)tableConfig)) {
            LOGGER.debug("No need to relocate COMPLETED segments for table: {}", (Object)tableNameWithType);
            return;
        }
        LOGGER.info("Relocating COMPLETED segments for table: {}", (Object)tableNameWithType);
        BaseConfiguration rebalanceConfig = new BaseConfiguration();
        rebalanceConfig.addProperty("minReplicasToKeepUpForNoDowntime", (Object)-1);
        this._executorService.submit(() -> this.lambda$processTable$0(tableConfig, (Configuration)rebalanceConfig, tableNameWithType));
    }

    private static long getRunFrequencySeconds(String timeStr) {
        long seconds;
        try {
            Long millis = TimeUtils.convertPeriodToMillis((String)timeStr);
            seconds = millis / 1000L;
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid time spec '" + timeStr + "' (Valid examples: '3h', '4h30m', '30m')", e);
        }
        return seconds;
    }

    private /* synthetic */ void lambda$processTable$0(TableConfig tableConfig, Configuration rebalanceConfig, String tableNameWithType) {
        try {
            RebalanceResult rebalance = new TableRebalancer(this._pinotHelixResourceManager.getHelixZkManager()).rebalance(tableConfig, rebalanceConfig);
            switch (rebalance.getStatus()) {
                case NO_OP: {
                    LOGGER.info("All COMPLETED segments are already relocated for table: {}", (Object)tableNameWithType);
                    break;
                }
                case DONE: {
                    LOGGER.info("Finished relocating COMPLETED segments for table: {}", (Object)tableNameWithType);
                    break;
                }
                default: {
                    LOGGER.error("Relocation failed for table: {}", (Object)tableNameWithType);
                    break;
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error("Caught exception/error while rebalancing table: {}", (Object)tableNameWithType, (Object)t);
        }
    }
}

