/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.retention;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.helix.model.IdealState;
import org.apache.pinot.common.metadata.segment.OfflineSegmentZKMetadata;
import org.apache.pinot.common.metadata.segment.RealtimeSegmentZKMetadata;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.utils.CommonConstants;
import org.apache.pinot.common.utils.SegmentName;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.periodictask.ControllerPeriodicTask;
import org.apache.pinot.controller.helix.core.retention.strategy.RetentionStrategy;
import org.apache.pinot.controller.helix.core.retention.strategy.TimeRetentionStrategy;
import org.apache.pinot.spi.config.table.SegmentsValidationAndRetentionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetentionManager
extends ControllerPeriodicTask<Void> {
    public static final long OLD_LLC_SEGMENTS_RETENTION_IN_MILLIS = TimeUnit.DAYS.toMillis(5L);
    private static final Logger LOGGER = LoggerFactory.getLogger(RetentionManager.class);
    private final int _deletedSegmentsRetentionInDays;

    public RetentionManager(PinotHelixResourceManager pinotHelixResourceManager, LeadControllerManager leadControllerManager, ControllerConf config, ControllerMetrics controllerMetrics) {
        super("RetentionManager", config.getRetentionControllerFrequencyInSeconds(), config.getRetentionManagerInitialDelayInSeconds(), pinotHelixResourceManager, leadControllerManager, controllerMetrics);
        this._deletedSegmentsRetentionInDays = config.getDeletedSegmentsRetentionInDays();
        LOGGER.info("Starting RetentionManager with runFrequencyInSeconds: {}, deletedSegmentsRetentionInDays: {}", (Object)this.getIntervalInSeconds(), (Object)this._deletedSegmentsRetentionInDays);
    }

    @Override
    protected void processTable(String tableNameWithType) {
        LOGGER.info("Start managing retention for table: {}", (Object)tableNameWithType);
        this.manageRetentionForTable(tableNameWithType);
    }

    @Override
    protected void postprocess() {
        LOGGER.info("Removing aged (more than {} days) deleted segments for all tables", (Object)this._deletedSegmentsRetentionInDays);
        this._pinotHelixResourceManager.getSegmentDeletionManager().removeAgedDeletedSegments(this._deletedSegmentsRetentionInDays);
    }

    private void manageRetentionForTable(String tableNameWithType) {
        TimeRetentionStrategy retentionStrategy;
        TableConfig tableConfig = this._pinotHelixResourceManager.getTableConfig(tableNameWithType);
        if (tableConfig == null) {
            LOGGER.error("Failed to get table config for table: {}", (Object)tableNameWithType);
            return;
        }
        SegmentsValidationAndRetentionConfig validationConfig = tableConfig.getValidationConfig();
        String segmentPushType = validationConfig.getSegmentPushType();
        if (!"APPEND".equalsIgnoreCase(segmentPushType)) {
            LOGGER.info("Segment push type is not APPEND for table: {}, skip", (Object)tableNameWithType);
            return;
        }
        String retentionTimeUnit = validationConfig.getRetentionTimeUnit();
        String retentionTimeValue = validationConfig.getRetentionTimeValue();
        try {
            retentionStrategy = new TimeRetentionStrategy(TimeUnit.valueOf(retentionTimeUnit.toUpperCase()), Long.parseLong(retentionTimeValue));
        }
        catch (Exception e) {
            LOGGER.warn("Invalid retention time: {} {} for table: {}, skip", (Object)retentionTimeUnit, (Object)retentionTimeValue);
            return;
        }
        if (TableNameBuilder.isOfflineTableResource((String)tableNameWithType)) {
            this.manageRetentionForOfflineTable(tableNameWithType, retentionStrategy);
        } else {
            this.manageRetentionForRealtimeTable(tableNameWithType, retentionStrategy);
        }
    }

    private void manageRetentionForOfflineTable(String offlineTableName, RetentionStrategy retentionStrategy) {
        ArrayList<String> segmentsToDelete = new ArrayList<String>();
        for (OfflineSegmentZKMetadata offlineSegmentZKMetadata : this._pinotHelixResourceManager.getOfflineSegmentMetadata(offlineTableName)) {
            if (!retentionStrategy.isPurgeable(offlineTableName, (SegmentZKMetadata)offlineSegmentZKMetadata)) continue;
            segmentsToDelete.add(offlineSegmentZKMetadata.getSegmentName());
        }
        if (!segmentsToDelete.isEmpty()) {
            LOGGER.info("Deleting {} segments from table: {}", (Object)segmentsToDelete.size(), (Object)offlineTableName);
            this._pinotHelixResourceManager.deleteSegments(offlineTableName, segmentsToDelete);
        }
    }

    private void manageRetentionForRealtimeTable(String realtimeTableName, RetentionStrategy retentionStrategy) {
        ArrayList<String> segmentsToDelete = new ArrayList<String>();
        IdealState idealState = this._pinotHelixResourceManager.getHelixAdmin().getResourceIdealState(this._pinotHelixResourceManager.getHelixClusterName(), realtimeTableName);
        for (RealtimeSegmentZKMetadata realtimeSegmentZKMetadata : this._pinotHelixResourceManager.getRealtimeSegmentMetadata(realtimeTableName)) {
            String segmentName = realtimeSegmentZKMetadata.getSegmentName();
            if (realtimeSegmentZKMetadata.getStatus() == CommonConstants.Segment.Realtime.Status.IN_PROGRESS) {
                if (!SegmentName.isLowLevelConsumerSegmentName((String)segmentName) || !this.shouldDeleteInProgressLLCSegment(segmentName, idealState, realtimeSegmentZKMetadata)) continue;
                segmentsToDelete.add(segmentName);
                continue;
            }
            if (!retentionStrategy.isPurgeable(realtimeTableName, (SegmentZKMetadata)realtimeSegmentZKMetadata)) continue;
            segmentsToDelete.add(segmentName);
        }
        if (!segmentsToDelete.isEmpty()) {
            LOGGER.info("Deleting {} segments from table: {}", (Object)segmentsToDelete.size(), (Object)realtimeTableName);
            this._pinotHelixResourceManager.deleteSegments(realtimeTableName, segmentsToDelete);
        }
    }

    private boolean shouldDeleteInProgressLLCSegment(String segmentName, IdealState idealState, RealtimeSegmentZKMetadata realtimeSegmentZKMetadata) {
        if (idealState == null) {
            return false;
        }
        if (System.currentTimeMillis() - realtimeSegmentZKMetadata.getCreationTime() <= OLD_LLC_SEGMENTS_RETENTION_IN_MILLIS) {
            return false;
        }
        Map stateMap = idealState.getInstanceStateMap(segmentName);
        if (stateMap == null) {
            return true;
        }
        HashSet states = new HashSet(stateMap.values());
        return states.size() == 1 && states.contains("OFFLINE");
    }
}

