/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.util;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.HelixControllerMain;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.client.HelixZkClient;
import org.apache.helix.manager.zk.client.SharedZkClientFactory;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.model.builder.CustomModeISBuilder;
import org.apache.helix.model.builder.FullAutoModeISBuilder;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.pinot.common.utils.helix.LeadControllerUtils;
import org.apache.pinot.controller.helix.core.PinotHelixBrokerResourceOnlineOfflineStateModelGenerator;
import org.apache.pinot.controller.helix.core.PinotHelixSegmentOnlineOfflineStateModelGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixSetupUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelixSetupUtils.class);

    private HelixSetupUtils() {
    }

    public static HelixManager setupHelixController(String helixClusterName, String zkPath, String instanceId) {
        HelixSetupUtils.setupHelixClusterIfNeeded(helixClusterName, zkPath);
        return HelixControllerMain.startHelixController((String)zkPath, (String)helixClusterName, (String)instanceId, (String)"STANDALONE");
    }

    private static void setupHelixClusterIfNeeded(String helixClusterName, String zkPath) {
        ZKHelixAdmin admin = new ZKHelixAdmin(zkPath);
        if (admin.getClusters().contains(helixClusterName)) {
            LOGGER.info("Helix cluster: {} already exists", (Object)helixClusterName);
        } else {
            LOGGER.info("Creating a new Helix cluster: {}", (Object)helixClusterName);
            admin.addCluster(helixClusterName, false);
            HelixConfigScope configScope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.CLUSTER).forCluster(helixClusterName).build();
            HashMap<String, String> configMap = new HashMap<String, String>();
            configMap.put("allowParticipantAutoJoin", Boolean.toString(true));
            configMap.put("enable.case.insensitive", Boolean.toString(false));
            configMap.put("default.hyperloglog.log2m", Integer.toString(8));
            configMap.put("pinot.broker.enable.query.limit.override", Boolean.toString(false));
            admin.setConfig(configScope, configMap);
            LOGGER.info("New Helix cluster: {} created", (Object)helixClusterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupPinotCluster(String helixClusterName, String zkPath, boolean isUpdateStateModel, boolean enableBatchMessageMode, String leadControllerResourceRebalanceStrategy) {
        try (HelixZkClient zkClient = null;){
            zkClient = SharedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkPath), new HelixZkClient.ZkClientConfig().setZkSerializer((ZkSerializer)new ZNRecordSerializer()).setConnectInitTimeout(TimeUnit.SECONDS.toMillis(60L)));
            zkClient.waitUntilConnected(60L, TimeUnit.SECONDS);
            ZKHelixAdmin helixAdmin = new ZKHelixAdmin(zkClient);
            ZKHelixDataAccessor helixDataAccessor = new ZKHelixDataAccessor(helixClusterName, (BaseDataAccessor)new ZkBaseDataAccessor(zkClient));
            ConfigAccessor configAccessor = new ConfigAccessor(zkClient);
            Preconditions.checkState((boolean)helixAdmin.getClusters().contains(helixClusterName), (Object)String.format("Helix cluster: %s hasn't been set up", helixClusterName));
            HelixSetupUtils.addSegmentStateModelDefinitionIfNeeded(helixClusterName, (HelixAdmin)helixAdmin, (HelixDataAccessor)helixDataAccessor, isUpdateStateModel);
            HelixSetupUtils.createBrokerResourceIfNeeded(helixClusterName, (HelixAdmin)helixAdmin, enableBatchMessageMode);
            HelixSetupUtils.createLeadControllerResourceIfNeeded(helixClusterName, (HelixAdmin)helixAdmin, configAccessor, enableBatchMessageMode, leadControllerResourceRebalanceStrategy);
        }
    }

    private static void addSegmentStateModelDefinitionIfNeeded(String helixClusterName, HelixAdmin helixAdmin, HelixDataAccessor helixDataAccessor, boolean isUpdateStateModel) {
        String segmentStateModelName = "SegmentOnlineOfflineStateModel";
        StateModelDefinition stateModelDefinition = helixAdmin.getStateModelDef(helixClusterName, segmentStateModelName);
        if (stateModelDefinition == null || isUpdateStateModel) {
            if (stateModelDefinition == null) {
                LOGGER.info("Adding state model: {} with CONSUMING state", (Object)segmentStateModelName);
            } else {
                LOGGER.info("Updating state model: {} to contain CONSUMING state", (Object)segmentStateModelName);
            }
            helixDataAccessor.createStateModelDef(PinotHelixSegmentOnlineOfflineStateModelGenerator.generatePinotStateModelDefinition());
        }
    }

    private static void createBrokerResourceIfNeeded(String helixClusterName, HelixAdmin helixAdmin, boolean enableBatchMessageMode) {
        String stateModel = "BrokerResourceOnlineOfflineStateModel";
        StateModelDefinition stateModelDef = helixAdmin.getStateModelDef(helixClusterName, stateModel);
        if (stateModelDef == null) {
            LOGGER.info("Adding state model: {}", (Object)stateModel);
            helixAdmin.addStateModelDef(helixClusterName, stateModel, PinotHelixBrokerResourceOnlineOfflineStateModelGenerator.generatePinotStateModelDefinition());
        }
        if (helixAdmin.getResourceIdealState(helixClusterName, "brokerResource") == null) {
            LOGGER.info("Adding resource: {}", (Object)"brokerResource");
            IdealState idealState = new CustomModeISBuilder("brokerResource").setStateModel(stateModel).build();
            idealState.setBatchMessageMode(enableBatchMessageMode);
            helixAdmin.addResource(helixClusterName, "brokerResource", idealState);
        }
    }

    private static void createLeadControllerResourceIfNeeded(String helixClusterName, HelixAdmin helixAdmin, ConfigAccessor configAccessor, boolean enableBatchMessageMode, String leadControllerResourceRebalanceStrategy) {
        IdealState idealState = helixAdmin.getResourceIdealState(helixClusterName, "leadControllerResource");
        if (idealState == null) {
            LOGGER.info("Adding resource: {}", (Object)"leadControllerResource");
            FullAutoModeISBuilder idealStateBuilder = new FullAutoModeISBuilder("leadControllerResource");
            idealStateBuilder.setStateModel("MasterSlave").setRebalanceStrategy(leadControllerResourceRebalanceStrategy);
            idealStateBuilder.setNumPartitions(24);
            for (int i = 0; i < 24; ++i) {
                idealStateBuilder.add(LeadControllerUtils.generatePartitionName((int)i));
            }
            idealStateBuilder.setNumReplica(1);
            idealStateBuilder.setMinActiveReplica(0);
            idealStateBuilder.setRebalanceDelay(300000);
            idealStateBuilder.enableDelayRebalance();
            idealState = idealStateBuilder.build();
            idealState.setInstanceGroupTag("controller");
            idealState.setBatchMessageMode(enableBatchMessageMode);
            helixAdmin.addResource(helixClusterName, "leadControllerResource", idealState);
        } else if (!idealState.isEnabled()) {
            idealState.enable(true);
            helixAdmin.updateIdealState(helixClusterName, "leadControllerResource", idealState);
        }
        ResourceConfig resourceConfig = configAccessor.getResourceConfig(helixClusterName, "leadControllerResource");
        if (resourceConfig == null) {
            resourceConfig = new ResourceConfig("leadControllerResource");
        }
        if (resourceConfig.getSimpleConfig("RESOURCE_ENABLED") == null) {
            resourceConfig.putSimpleConfig("RESOURCE_ENABLED", Boolean.FALSE.toString());
        }
        configAccessor.setResourceConfig(helixClusterName, "leadControllerResource", resourceConfig);
    }
}

