/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.common.metadata.segment.ColumnPartitionMetadata;
import org.apache.pinot.common.metadata.segment.OfflineSegmentZKMetadata;
import org.apache.pinot.common.metadata.segment.SegmentPartitionMetadata;
import org.apache.pinot.common.utils.CommonConstants;
import org.apache.pinot.core.data.partition.PartitionFunction;
import org.apache.pinot.core.segment.index.metadata.ColumnMetadata;
import org.apache.pinot.core.segment.index.metadata.SegmentMetadata;
import org.apache.pinot.core.segment.index.metadata.SegmentMetadataImpl;

public class ZKMetadataUtils {
    private ZKMetadataUtils() {
    }

    public static void updateSegmentMetadata(OfflineSegmentZKMetadata offlineSegmentZKMetadata, SegmentMetadata segmentMetadata) {
        offlineSegmentZKMetadata.setSegmentName(segmentMetadata.getName());
        offlineSegmentZKMetadata.setTableName(segmentMetadata.getTableName());
        offlineSegmentZKMetadata.setIndexVersion(segmentMetadata.getVersion());
        offlineSegmentZKMetadata.setSegmentType(CommonConstants.Segment.SegmentType.OFFLINE);
        if (segmentMetadata.getTimeInterval() != null) {
            offlineSegmentZKMetadata.setStartTime(segmentMetadata.getStartTime());
            offlineSegmentZKMetadata.setEndTime(segmentMetadata.getEndTime());
            offlineSegmentZKMetadata.setTimeUnit(segmentMetadata.getTimeUnit());
        }
        offlineSegmentZKMetadata.setTotalDocs((long)segmentMetadata.getTotalDocs());
        offlineSegmentZKMetadata.setCreationTime(segmentMetadata.getIndexCreationTime());
        offlineSegmentZKMetadata.setCrc(Long.parseLong(segmentMetadata.getCrc()));
        HashMap<String, ColumnPartitionMetadata> columnPartitionMap = new HashMap<String, ColumnPartitionMetadata>();
        if (segmentMetadata instanceof SegmentMetadataImpl) {
            SegmentMetadataImpl metadata = (SegmentMetadataImpl)segmentMetadata;
            for (Map.Entry entry : metadata.getColumnMetadataMap().entrySet()) {
                String column = (String)entry.getKey();
                ColumnMetadata columnMetadata = (ColumnMetadata)entry.getValue();
                PartitionFunction partitionFunction = columnMetadata.getPartitionFunction();
                if (partitionFunction == null) continue;
                ColumnPartitionMetadata columnPartitionMetadata = new ColumnPartitionMetadata(partitionFunction.toString(), columnMetadata.getNumPartitions(), columnMetadata.getPartitions());
                columnPartitionMap.put(column, columnPartitionMetadata);
            }
        }
        if (!columnPartitionMap.isEmpty()) {
            offlineSegmentZKMetadata.setPartitionMetadata(new SegmentPartitionMetadata(columnPartitionMap));
        }
    }
}

