/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.api.listeners.ListenerConfig;
import org.apache.pinot.controller.api.listeners.TlsConfiguration;

public abstract class ListenerConfigUtil {
    public static List<ListenerConfig> buildListenerConfigs(ControllerConf controllerConf) {
        ArrayList<ListenerConfig> listenerConfigs = new ArrayList<ListenerConfig>();
        if (controllerConf.getControllerPort() != null) {
            listenerConfigs.add(new ListenerConfig("http", "0.0.0.0", Integer.valueOf(controllerConf.getControllerPort()), "http", null));
        }
        listenerConfigs.addAll(controllerConf.getControllerAccessProtocols().stream().map(protocol -> ListenerConfigUtil.buildListenerConfig(protocol, controllerConf)).collect(Collectors.toList()));
        return listenerConfigs;
    }

    public static boolean shouldAdvertiseAsHttps(List<ListenerConfig> listenerConfigs, ControllerConf controllerConf) {
        return controllerConf.getQueryConsoleUseHttps() || !listenerConfigs.stream().map(ListenerConfig::getProtocol).filter(protocol -> protocol.equals("http")).findAny().isPresent();
    }

    private static Optional<TlsConfiguration> buildTlsConfiguration(String protocol, ControllerConf controllerConf) {
        return Optional.ofNullable(controllerConf.getControllerAccessProtocolProperty(protocol, "tls.keystore.path")).map(keystore -> ListenerConfigUtil.buildTlsConfiguration(protocol, keystore, controllerConf));
    }

    private static TlsConfiguration buildTlsConfiguration(String protocol, String keystore, ControllerConf controllerConf) {
        return new TlsConfiguration(keystore, controllerConf.getControllerAccessProtocolProperty(protocol, "tls.keystore.password"), controllerConf.getControllerAccessProtocolProperty(protocol, "tls.truststore.path"), controllerConf.getControllerAccessProtocolProperty(protocol, "tls.truststore.password"), Boolean.parseBoolean(controllerConf.getControllerAccessProtocolProperty(protocol, "tls.requires_client_auth", "false")));
    }

    private static ListenerConfig buildListenerConfig(String protocol, ControllerConf controllerConf) {
        return new ListenerConfig(protocol, ListenerConfigUtil.getHost(controllerConf.getControllerAccessProtocolProperty(protocol, "host", "0.0.0.0")), ListenerConfigUtil.getPort(controllerConf.getControllerAccessProtocolProperty(protocol, "port")), protocol, ListenerConfigUtil.buildTlsConfiguration(protocol, controllerConf).orElse(null));
    }

    private static String getHost(String configuredHost) {
        return Optional.ofNullable(configuredHost).filter(host -> !host.trim().isEmpty()).orElseThrow(() -> new IllegalArgumentException(configuredHost + " is not a valid host"));
    }

    private static int getPort(String configuredPort) {
        return Optional.ofNullable(configuredPort).filter(host -> !host.trim().isEmpty()).map(Integer::valueOf).orElseThrow(() -> new IllegalArgumentException(configuredPort + " is not a valid port"));
    }
}

