/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.helix.PropertyPathConfig;
import org.apache.helix.PropertyType;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.OfflineSegmentZKMetadata;
import org.apache.pinot.common.utils.config.TableConfigUtils;
import org.apache.pinot.spi.config.table.SegmentsValidationAndRetentionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.utils.TimeUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRetentionValidator {
    public static final long DEFAULT_DURATION_IN_DAYS_THRESHOLD = 365L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TableRetentionValidator.class);
    private final String _clusterName;
    private final ZKHelixAdmin _helixAdmin;
    private final ZkHelixPropertyStore<ZNRecord> _propertyStore;
    private String _tableNamePattern = null;
    private long _durationInDaysThreshold = 365L;

    public TableRetentionValidator(@Nonnull String zkAddress, @Nonnull String clusterName) {
        this._clusterName = clusterName;
        this._helixAdmin = new ZKHelixAdmin(zkAddress);
        this._propertyStore = new ZkHelixPropertyStore(zkAddress, (ZkSerializer)new ZNRecordSerializer(), PropertyPathConfig.getPath((PropertyType)PropertyType.PROPERTYSTORE, (String)clusterName, (String[])new String[0]));
    }

    public void overrideDefaultSettings(@Nullable String tableNamePattern, long durationInDaysThreshold) {
        this._tableNamePattern = tableNamePattern;
        this._durationInDaysThreshold = durationInDaysThreshold;
    }

    public void run() throws Exception {
        List resourcesInCluster = this._helixAdmin.getResourcesInCluster(this._clusterName);
        for (String tableName : resourcesInCluster) {
            long durationInDays;
            TimeUnit timeUnit;
            if (!TableNameBuilder.isTableResource((String)tableName) || this._tableNamePattern != null && !tableName.matches(this._tableNamePattern)) continue;
            SegmentsValidationAndRetentionConfig retentionConfig = this.getTableConfig(tableName).getValidationConfig();
            if (retentionConfig == null) {
                LOGGER.error("Table: {}, \"segmentsConfig\" field is missing in table config", (Object)tableName);
                continue;
            }
            String segmentPushType = retentionConfig.getSegmentPushType();
            if (segmentPushType == null) {
                LOGGER.error("Table: {}, null push type", (Object)tableName);
                continue;
            }
            if (segmentPushType.equalsIgnoreCase("REFRESH")) continue;
            if (!segmentPushType.equalsIgnoreCase("APPEND")) {
                LOGGER.error("Table: {}, invalid push type: {}", (Object)tableName, (Object)segmentPushType);
                continue;
            }
            String timeUnitString = retentionConfig.getRetentionTimeUnit();
            try {
                timeUnit = TimeUnit.valueOf(timeUnitString.toUpperCase());
            }
            catch (Exception e) {
                LOGGER.error("Table: {}, invalid time unit: {}", (Object)tableName, (Object)timeUnitString);
                continue;
            }
            String timeValueString = retentionConfig.getRetentionTimeValue();
            try {
                durationInDays = timeUnit.toDays(Long.valueOf(timeValueString));
            }
            catch (Exception e) {
                LOGGER.error("Table: {}, invalid time value: {}", (Object)tableName, (Object)timeValueString);
                continue;
            }
            if (durationInDays <= 0L) {
                LOGGER.error("Table: {}, invalid retention duration in days: {}", (Object)tableName, (Object)durationInDays);
                continue;
            }
            if (durationInDays > this._durationInDaysThreshold) {
                LOGGER.warn("Table: {}, retention duration in days is too large: {}", (Object)tableName, (Object)durationInDays);
            }
            if (tableName.endsWith("REALTIME")) continue;
            List<String> segmentNames = this.getSegmentNames(tableName);
            if (segmentNames == null || segmentNames.isEmpty()) {
                LOGGER.warn("Table: {}, no segment metadata in property store", (Object)tableName);
                continue;
            }
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (String segmentName : segmentNames) {
                long endTimeInMillis;
                OfflineSegmentZKMetadata offlineSegmentMetadata = this.getOfflineSegmentMetadata(tableName, segmentName);
                TimeUnit segmentTimeUnit = offlineSegmentMetadata.getTimeUnit();
                if (segmentTimeUnit == null) {
                    errorMessages.add("Segment: " + segmentName + " has null time unit");
                    continue;
                }
                long startTimeInMillis = segmentTimeUnit.toMillis(offlineSegmentMetadata.getStartTime());
                if (!TimeUtils.timeValueInValidRange((long)startTimeInMillis)) {
                    errorMessages.add("Segment: " + segmentName + " has invalid start time in millis: " + startTimeInMillis);
                }
                if (TimeUtils.timeValueInValidRange((long)(endTimeInMillis = segmentTimeUnit.toMillis(offlineSegmentMetadata.getEndTime())))) continue;
                errorMessages.add("Segment: " + segmentName + " has invalid end time in millis: " + endTimeInMillis);
            }
            if (errorMessages.isEmpty()) continue;
            LOGGER.error("Table: {}, invalid segments: {}", (Object)tableName, errorMessages);
        }
    }

    private TableConfig getTableConfig(String tableName) throws Exception {
        return TableConfigUtils.fromZNRecord((ZNRecord)((ZNRecord)this._propertyStore.get(ZKMetadataProvider.constructPropertyStorePathForResourceConfig((String)tableName), null, 0)));
    }

    private List<String> getSegmentNames(String tableName) {
        return this._propertyStore.getChildNames(ZKMetadataProvider.constructPropertyStorePathForResource((String)tableName), 0);
    }

    private OfflineSegmentZKMetadata getOfflineSegmentMetadata(String tableName, String segmentName) {
        return new OfflineSegmentZKMetadata((ZNRecord)this._propertyStore.get(ZKMetadataProvider.constructPropertyStorePathForSegment((String)tableName, (String)segmentName), null, 0));
    }
}

