/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.validation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.metadata.segment.RealtimeSegmentZKMetadata;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.metrics.ValidationMetrics;
import org.apache.pinot.common.utils.HLCSegmentName;
import org.apache.pinot.common.utils.SegmentName;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.periodictask.ControllerPeriodicTask;
import org.apache.pinot.controller.helix.core.realtime.PinotLLCRealtimeSegmentManager;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.stream.PartitionLevelStreamConfig;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeSegmentValidationManager
extends ControllerPeriodicTask<Context> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealtimeSegmentValidationManager.class);
    private final PinotLLCRealtimeSegmentManager _llcRealtimeSegmentManager;
    private final ValidationMetrics _validationMetrics;
    private final int _segmentLevelValidationIntervalInSeconds;
    private long _lastUpdateRealtimeDocumentCountTimeMs = 0L;

    public RealtimeSegmentValidationManager(ControllerConf config, PinotHelixResourceManager pinotHelixResourceManager, LeadControllerManager leadControllerManager, PinotLLCRealtimeSegmentManager llcRealtimeSegmentManager, ValidationMetrics validationMetrics, ControllerMetrics controllerMetrics) {
        super("RealtimeSegmentValidationManager", config.getRealtimeSegmentValidationFrequencyInSeconds(), config.getRealtimeSegmentValidationManagerInitialDelaySeconds(), pinotHelixResourceManager, leadControllerManager, controllerMetrics);
        this._llcRealtimeSegmentManager = llcRealtimeSegmentManager;
        this._validationMetrics = validationMetrics;
        this._segmentLevelValidationIntervalInSeconds = config.getSegmentLevelValidationIntervalInSeconds();
        Preconditions.checkState((this._segmentLevelValidationIntervalInSeconds > 0 ? 1 : 0) != 0);
    }

    @Override
    protected Context preprocess() {
        Context context = new Context();
        long currentTimeMs = System.currentTimeMillis();
        if (TimeUnit.MILLISECONDS.toSeconds(currentTimeMs - this._lastUpdateRealtimeDocumentCountTimeMs) >= (long)this._segmentLevelValidationIntervalInSeconds) {
            LOGGER.info("Run segment-level validation");
            context._updateRealtimeDocumentCount = true;
            this._lastUpdateRealtimeDocumentCountTimeMs = currentTimeMs;
        }
        return context;
    }

    @Override
    protected void processTable(String tableNameWithType, Context context) {
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
        if (tableType == TableType.REALTIME) {
            PartitionLevelStreamConfig streamConfig;
            TableConfig tableConfig = this._pinotHelixResourceManager.getTableConfig(tableNameWithType);
            if (tableConfig == null) {
                LOGGER.warn("Failed to find table config for table: {}, skipping validation", (Object)tableNameWithType);
                return;
            }
            if (context._updateRealtimeDocumentCount) {
                this.updateRealtimeDocumentCount(tableConfig);
            }
            if ((streamConfig = new PartitionLevelStreamConfig(tableConfig.getTableName(), tableConfig.getIndexingConfig().getStreamConfigs())).hasLowLevelConsumerType()) {
                this._llcRealtimeSegmentManager.ensureAllPartitionsConsuming(tableConfig, streamConfig);
            }
        }
    }

    private void updateRealtimeDocumentCount(TableConfig tableConfig) {
        String realtimeTableName = tableConfig.getTableName();
        List<RealtimeSegmentZKMetadata> metadataList = this._pinotHelixResourceManager.getRealtimeSegmentMetadata(realtimeTableName);
        boolean countHLCSegments = true;
        StreamConfig streamConfig = new StreamConfig(realtimeTableName, tableConfig.getIndexingConfig().getStreamConfigs());
        if (streamConfig.hasLowLevelConsumerType() && !streamConfig.hasHighLevelConsumerType()) {
            countHLCSegments = false;
        }
        this._validationMetrics.updateTotalDocumentCountGauge(tableConfig.getTableName(), RealtimeSegmentValidationManager.computeRealtimeTotalDocumentInSegments(metadataList, countHLCSegments));
    }

    @VisibleForTesting
    static long computeRealtimeTotalDocumentInSegments(List<RealtimeSegmentZKMetadata> realtimeSegmentZKMetadataList, boolean countHLCSegments) {
        long numTotalDocs = 0L;
        String groupId = "";
        for (RealtimeSegmentZKMetadata realtimeSegmentZKMetadata : realtimeSegmentZKMetadataList) {
            String segmentName = realtimeSegmentZKMetadata.getSegmentName();
            if (SegmentName.isHighLevelConsumerSegmentName((String)segmentName)) {
                if (!countHLCSegments) continue;
                HLCSegmentName hlcSegmentName = new HLCSegmentName(segmentName);
                String segmentGroupIdName = hlcSegmentName.getGroupId();
                if (groupId.isEmpty()) {
                    groupId = segmentGroupIdName;
                }
                if (!groupId.equals(segmentGroupIdName) || realtimeSegmentZKMetadata.getTotalDocs() < 0L) continue;
                numTotalDocs += realtimeSegmentZKMetadata.getTotalDocs();
                continue;
            }
            if (countHLCSegments) continue;
            numTotalDocs += realtimeSegmentZKMetadata.getTotalDocs();
        }
        return numTotalDocs;
    }

    public void cleanUpTask() {
        LOGGER.info("Unregister all the validation metrics.");
        this._validationMetrics.unregisterAllMetrics();
    }

    @VisibleForTesting
    public ValidationMetrics getValidationMetrics() {
        return this._validationMetrics;
    }

    public static final class Context {
        private boolean _updateRealtimeDocumentCount;
    }
}

