/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.InstanceType;
import org.apache.helix.model.ClusterConstraints;
import org.apache.helix.model.ConstraintItem;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.helix.task.TaskDriver;
import org.apache.pinot.common.Utils;
import org.apache.pinot.common.function.FunctionRegistry;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.metrics.MetricsHelper;
import org.apache.pinot.common.metrics.ValidationMetrics;
import org.apache.pinot.common.utils.NetUtil;
import org.apache.pinot.common.utils.ServiceStatus;
import org.apache.pinot.common.utils.fetcher.SegmentFetcherFactory;
import org.apache.pinot.common.utils.helix.LeadControllerUtils;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.api.ControllerAdminApiApplication;
import org.apache.pinot.controller.api.access.AccessControlFactory;
import org.apache.pinot.controller.api.events.MetadataEventNotifierFactory;
import org.apache.pinot.controller.api.resources.ControllerFilePathProvider;
import org.apache.pinot.controller.api.resources.InvalidControllerConfigException;
import org.apache.pinot.controller.helix.SegmentStatusChecker;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.minion.PinotHelixTaskResourceManager;
import org.apache.pinot.controller.helix.core.minion.PinotTaskManager;
import org.apache.pinot.controller.helix.core.realtime.PinotLLCRealtimeSegmentManager;
import org.apache.pinot.controller.helix.core.realtime.PinotRealtimeSegmentManager;
import org.apache.pinot.controller.helix.core.realtime.SegmentCompletionManager;
import org.apache.pinot.controller.helix.core.relocation.SegmentRelocator;
import org.apache.pinot.controller.helix.core.retention.RetentionManager;
import org.apache.pinot.controller.helix.core.statemodel.LeadControllerResourceMasterSlaveStateModelFactory;
import org.apache.pinot.controller.helix.core.util.HelixSetupUtils;
import org.apache.pinot.controller.helix.starter.HelixConfig;
import org.apache.pinot.controller.validation.BrokerResourceValidationManager;
import org.apache.pinot.controller.validation.OfflineSegmentIntervalChecker;
import org.apache.pinot.controller.validation.RealtimeSegmentValidationManager;
import org.apache.pinot.core.periodictask.PeriodicTask;
import org.apache.pinot.core.periodictask.PeriodicTaskScheduler;
import org.apache.pinot.core.transport.ListenerConfig;
import org.apache.pinot.core.transport.TlsConfig;
import org.apache.pinot.core.util.ListenerConfigUtil;
import org.apache.pinot.core.util.TlsUtils;
import org.apache.pinot.spi.crypt.PinotCrypterFactory;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.services.ServiceRole;
import org.apache.pinot.spi.services.ServiceStartable;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerStarter
implements ServiceStartable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerStarter.class);
    private static final String METRICS_REGISTRY_NAME = "pinot.controller.metrics";
    private static final Long DATA_DIRECTORY_MISSING_VALUE = 1000000L;
    private static final Long DATA_DIRECTORY_EXCEPTION_VALUE = 1100000L;
    private static final String METADATA_EVENT_NOTIFIER_PREFIX = "metadata.event.notifier";
    private static final String MAX_STATE_TRANSITIONS_PER_INSTANCE = "MaxStateTransitionsPerInstance";
    private final ControllerConf _config;
    private final List<ListenerConfig> _listenerConfigs;
    private final ControllerAdminApiApplication _adminApp;
    private final PinotHelixResourceManager _helixResourceManager;
    private final MetricsRegistry _metricsRegistry;
    private final ControllerMetrics _controllerMetrics;
    private final ExecutorService _executorService;
    private final String _helixZkURL;
    private final String _helixClusterName;
    private final String _helixControllerInstanceId;
    private final String _helixParticipantInstanceId;
    private final boolean _isUpdateStateModel;
    private final boolean _enableBatchMessageMode;
    private final ControllerConf.ControllerMode _controllerMode;
    private HelixManager _helixControllerManager;
    private HelixManager _helixParticipantManager;
    private OfflineSegmentIntervalChecker _offlineSegmentIntervalChecker;
    private RealtimeSegmentValidationManager _realtimeSegmentValidationManager;
    private BrokerResourceValidationManager _brokerResourceValidationManager;
    private SegmentRelocator _segmentRelocator;
    private RetentionManager _retentionManager;
    private SegmentStatusChecker _segmentStatusChecker;
    private PinotTaskManager _taskManager;
    private PeriodicTaskScheduler _periodicTaskScheduler;
    private PinotHelixTaskResourceManager _helixTaskResourceManager;
    private PinotRealtimeSegmentManager _realtimeSegmentsManager;
    private PinotLLCRealtimeSegmentManager _pinotLLCRealtimeSegmentManager;
    private SegmentCompletionManager _segmentCompletionManager;
    private LeadControllerManager _leadControllerManager;
    private List<ServiceStatus.ServiceStatusCallback> _serviceStatusCallbackList;

    public ControllerStarter(ControllerConf conf) {
        this._config = conf;
        this.inferHostnameIfNeeded(this._config);
        this.setupHelixSystemProperties();
        this._controllerMode = conf.getControllerMode();
        this._helixZkURL = HelixConfig.getAbsoluteZkPathForHelix(this._config.getZkStr());
        this._helixClusterName = this._config.getHelixClusterName();
        this._listenerConfigs = ListenerConfigUtil.buildControllerConfigs((PinotConfiguration)this._config);
        String host = conf.getControllerHost();
        int port = this._listenerConfigs.get(0).getPort();
        this._helixControllerInstanceId = host + "_" + port;
        this._helixParticipantInstanceId = LeadControllerUtils.generateParticipantInstanceId((String)host, (int)port);
        this._isUpdateStateModel = this._config.isUpdateSegmentStateModel();
        this._enableBatchMessageMode = this._config.getEnableBatchMessageMode();
        this._metricsRegistry = new MetricsRegistry();
        this._controllerMetrics = new ControllerMetrics(conf.getMetricsPrefix(), this._metricsRegistry);
        this._serviceStatusCallbackList = new ArrayList<ServiceStatus.ServiceStatusCallback>();
        if (this._controllerMode == ControllerConf.ControllerMode.HELIX_ONLY) {
            this._adminApp = null;
            this._helixResourceManager = null;
            this._executorService = null;
        } else {
            FunctionRegistry.init();
            this._adminApp = new ControllerAdminApiApplication();
            this._helixResourceManager = new PinotHelixResourceManager(this._config);
            this._executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("restapi-multiget-thread-%d").build());
        }
    }

    private void inferHostnameIfNeeded(ControllerConf config) {
        if (config.getControllerHost() == null && config.getProperty("pinot.set.instance.id.to.hostname", false)) {
            String inferredHostname = NetUtil.getHostnameOrAddress();
            if (inferredHostname != null) {
                config.setControllerHost(inferredHostname);
            } else {
                throw new RuntimeException("Failed to infer controller hostname, please set controller instanceId explicitly in config file.");
            }
        }
    }

    private void setupHelixSystemProperties() {
        System.setProperty("helixmanager.flappingTimeWindow", this._config.getProperty("pinot.controller.flapping.timeWindowMs", "1"));
    }

    private void setupHelixClusterConstraints() {
        String maxStateTransitions = this._config.getProperty("pinot.helix.instance.state.maxStateTransitions", "100000");
        HashMap<ClusterConstraints.ConstraintAttribute, String> constraintAttributes = new HashMap<ClusterConstraints.ConstraintAttribute, String>();
        constraintAttributes.put(ClusterConstraints.ConstraintAttribute.INSTANCE, ".*");
        constraintAttributes.put(ClusterConstraints.ConstraintAttribute.MESSAGE_TYPE, Message.MessageType.STATE_TRANSITION.name());
        ConstraintItem constraintItem = new ConstraintItem(constraintAttributes, maxStateTransitions);
        this._helixControllerManager.getClusterManagmentTool().setConstraint(this._helixClusterName, ClusterConstraints.ConstraintType.MESSAGE_CONSTRAINT, MAX_STATE_TRANSITIONS_PER_INSTANCE, constraintItem);
    }

    public PinotHelixResourceManager getHelixResourceManager() {
        return this._helixResourceManager;
    }

    public HelixManager getHelixControllerManager() {
        return this._helixControllerManager;
    }

    public LeadControllerManager getLeadControllerManager() {
        return this._leadControllerManager;
    }

    public OfflineSegmentIntervalChecker getOfflineSegmentIntervalChecker() {
        return this._offlineSegmentIntervalChecker;
    }

    public RealtimeSegmentValidationManager getRealtimeSegmentValidationManager() {
        return this._realtimeSegmentValidationManager;
    }

    public BrokerResourceValidationManager getBrokerResourceValidationManager() {
        return this._brokerResourceValidationManager;
    }

    public PinotHelixTaskResourceManager getHelixTaskResourceManager() {
        return this._helixTaskResourceManager;
    }

    public PinotTaskManager getTaskManager() {
        return this._taskManager;
    }

    public ServiceRole getServiceRole() {
        return ServiceRole.CONTROLLER;
    }

    public String getInstanceId() {
        return this._helixParticipantInstanceId;
    }

    public PinotConfiguration getConfig() {
        return this._config;
    }

    public void start() {
        LOGGER.info("Starting Pinot controller in mode: {}.", (Object)this._controllerMode.name());
        Utils.logVersions();
        MetricsHelper.initializeMetrics((PinotConfiguration)this._config.subset(METRICS_REGISTRY_NAME));
        MetricsHelper.registerMetricsRegistry((MetricsRegistry)this._metricsRegistry);
        this._controllerMetrics.initializeGlobalMeters();
        switch (this._controllerMode) {
            case DUAL: {
                this.setUpHelixController();
                this.setUpPinotController();
                break;
            }
            case PINOT_ONLY: {
                this.setUpPinotController();
                break;
            }
            case HELIX_ONLY: {
                this.setUpHelixController();
                break;
            }
            default: {
                LOGGER.error("Invalid mode: " + (Object)((Object)this._controllerMode));
            }
        }
        ServiceStatus.setServiceStatusCallback((String)this._helixParticipantInstanceId, (ServiceStatus.ServiceStatusCallback)new ServiceStatus.MultipleCallbackServiceStatusCallback(this._serviceStatusCallbackList));
    }

    private void setUpHelixController() {
        LOGGER.info("Starting Helix controller");
        this._helixControllerManager = HelixSetupUtils.setupHelixController(this._helixClusterName, this._helixZkURL, this._helixControllerInstanceId);
        this._controllerMetrics.addCallbackGauge("helix.connected", () -> this._helixControllerManager.isConnected() ? 1L : 0L);
        this._controllerMetrics.addCallbackGauge("helix.leader", () -> this._helixControllerManager.isLeader() ? 1L : 0L);
        this._helixControllerManager.addPreConnectCallback(() -> this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.HELIX_ZOOKEEPER_RECONNECTS, 1L));
        this._serviceStatusCallbackList.add(this.generateServiceStatusCallback(this._helixControllerManager));
        this.setupHelixClusterConstraints();
    }

    private void setUpPinotController() {
        AccessControlFactory accessControlFactory;
        TlsConfig tlsDefaults = TlsUtils.extractTlsConfig((PinotConfiguration)this._config, (String)"controller.tls");
        if (StringUtils.isNotBlank((CharSequence)tlsDefaults.getKeyStorePath()) || StringUtils.isNotBlank((CharSequence)tlsDefaults.getTrustStorePath())) {
            LOGGER.info("Installing default SSL context for any client requests");
            TlsUtils.installDefaultSSLSocketFactory((TlsConfig)tlsDefaults);
        }
        HelixSetupUtils.setupPinotCluster(this._helixClusterName, this._helixZkURL, this._isUpdateStateModel, this._enableBatchMessageMode, this._config.getLeadControllerResourceRebalanceStrategy());
        this.initPinotFSFactory();
        this.initControllerFilePathProvider();
        this.initSegmentFetcherFactory();
        this.initPinotCrypterFactory();
        LOGGER.info("Initializing Helix participant manager");
        this._helixParticipantManager = HelixManagerFactory.getZKHelixManager((String)this._helixClusterName, (String)this._helixParticipantInstanceId, (InstanceType)InstanceType.PARTICIPANT, (String)this._helixZkURL);
        LOGGER.info("Initializing lead controller manager");
        this._leadControllerManager = new LeadControllerManager(this._helixParticipantManager, this._controllerMetrics);
        LOGGER.info("Registering and connecting Helix participant manager as Helix Participant role");
        this.registerAndConnectAsHelixParticipant();
        LOGGER.info("Starting lead controller manager");
        this._leadControllerManager.start();
        LOGGER.info("Starting Pinot Helix resource manager and connecting to Zookeeper");
        this._helixResourceManager.start(this._helixParticipantManager);
        LOGGER.info("Starting task resource manager");
        this._helixTaskResourceManager = new PinotHelixTaskResourceManager(new TaskDriver(this._helixParticipantManager));
        LOGGER.info("Starting realtime segment manager");
        this._pinotLLCRealtimeSegmentManager = new PinotLLCRealtimeSegmentManager(this._helixResourceManager, this._config, this._controllerMetrics);
        this._helixResourceManager.registerPinotLLCRealtimeSegmentManager(this._pinotLLCRealtimeSegmentManager);
        this._segmentCompletionManager = new SegmentCompletionManager(this._helixParticipantManager, this._pinotLLCRealtimeSegmentManager, this._controllerMetrics, this._leadControllerManager, this._config.getSegmentCommitTimeoutSeconds());
        if (this._config.getHLCTablesAllowed()) {
            LOGGER.info("Realtime tables with High Level consumers will be supported");
            this._realtimeSegmentsManager = new PinotRealtimeSegmentManager(this._helixResourceManager, this._leadControllerManager);
            this._realtimeSegmentsManager.start(this._controllerMetrics);
        } else {
            LOGGER.info("Realtime tables with High Level consumers will NOT be supported");
            this._realtimeSegmentsManager = null;
        }
        List<PeriodicTask> controllerPeriodicTasks = this.setupControllerPeriodicTasks();
        LOGGER.info("Init controller periodic tasks scheduler");
        this._periodicTaskScheduler = new PeriodicTaskScheduler();
        this._periodicTaskScheduler.init(controllerPeriodicTasks);
        this._periodicTaskScheduler.start();
        String accessControlFactoryClass = this._config.getAccessControlFactoryClass();
        LOGGER.info("Use class: {} as the AccessControlFactory", (Object)accessControlFactoryClass);
        try {
            accessControlFactory = (AccessControlFactory)Class.forName(accessControlFactoryClass).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while creating new AccessControlFactory instance", e);
        }
        final MetadataEventNotifierFactory metadataEventNotifierFactory = MetadataEventNotifierFactory.loadFactory(this._config.subset(METADATA_EVENT_NOTIFIER_PREFIX));
        LOGGER.info("Controller download url base: {}", (Object)this._config.generateVipUrl());
        LOGGER.info("Injecting configuration and resource managers to the API context");
        final MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setConnectionTimeout(this._config.getServerAdminRequestTimeoutSeconds() * 1000);
        this._adminApp.registerBinder(new AbstractBinder(){

            protected void configure() {
                this.bind((Object)ControllerStarter.this._config).to(ControllerConf.class);
                this.bind(ControllerStarter.this._helixResourceManager).to(PinotHelixResourceManager.class);
                this.bind(ControllerStarter.this._helixTaskResourceManager).to(PinotHelixTaskResourceManager.class);
                this.bind(ControllerStarter.this._segmentCompletionManager).to(SegmentCompletionManager.class);
                this.bind((Object)ControllerStarter.this._taskManager).to(PinotTaskManager.class);
                this.bind(connectionManager).to(HttpConnectionManager.class);
                this.bind(ControllerStarter.this._executorService).to(Executor.class);
                this.bind(ControllerStarter.this._controllerMetrics).to(ControllerMetrics.class);
                this.bind(accessControlFactory).to(AccessControlFactory.class);
                this.bind(metadataEventNotifierFactory).to(MetadataEventNotifierFactory.class);
                this.bind(ControllerStarter.this._leadControllerManager).to(LeadControllerManager.class);
            }
        });
        LOGGER.info("Starting controller admin application on: {}", (Object)ListenerConfigUtil.toString(this._listenerConfigs));
        this._adminApp.start(this._listenerConfigs);
        this._controllerMetrics.addCallbackGauge("dataDir.exists", () -> new File(this._config.getDataDir()).exists() ? 1L : 0L);
        this._controllerMetrics.addCallbackGauge("dataDir.fileOpLatencyMs", () -> {
            File dataDir = new File(this._config.getDataDir());
            if (dataDir.exists()) {
                try {
                    long startTime = System.currentTimeMillis();
                    File testFile = new File(dataDir, this._config.getControllerHost());
                    try (FileOutputStream outputStream = new FileOutputStream(testFile, false);){
                        ((OutputStream)outputStream).write(Longs.toByteArray((long)System.currentTimeMillis()));
                    }
                    FileUtils.deleteQuietly((File)testFile);
                    return System.currentTimeMillis() - startTime;
                }
                catch (IOException e) {
                    LOGGER.warn("Caught exception while checking the data directory operation latency", (Throwable)e);
                    return DATA_DIRECTORY_EXCEPTION_VALUE;
                }
            }
            return DATA_DIRECTORY_MISSING_VALUE;
        });
        this._serviceStatusCallbackList.add(this.generateServiceStatusCallback(this._helixParticipantManager));
    }

    private ServiceStatus.ServiceStatusCallback generateServiceStatusCallback(final HelixManager helixManager) {
        return new ServiceStatus.ServiceStatusCallback(){
            private boolean _isStarted = false;
            private String _statusDescription = "Helix ZK Not connected as " + helixManager.getInstanceType();

            public ServiceStatus.Status getServiceStatus() {
                if (this._isStarted) {
                    if (helixManager.isConnected()) {
                        return ServiceStatus.Status.GOOD;
                    }
                    return ServiceStatus.Status.BAD;
                }
                if (!helixManager.isConnected()) {
                    return ServiceStatus.Status.STARTING;
                }
                this._isStarted = true;
                this._statusDescription = "None";
                return ServiceStatus.Status.GOOD;
            }

            public String getStatusDescription() {
                return this._statusDescription;
            }
        };
    }

    private void initPinotFSFactory() {
        LOGGER.info("Initializing PinotFSFactory");
        PinotFSFactory.init((PinotConfiguration)this._config.subset("pinot.controller.storage.factory"));
    }

    private void initControllerFilePathProvider() {
        LOGGER.info("Initializing ControllerFilePathProvider");
        try {
            ControllerFilePathProvider.init(this._config);
        }
        catch (InvalidControllerConfigException e) {
            throw new RuntimeException("Caught exception while initializing ControllerFilePathProvider", e);
        }
    }

    private void initSegmentFetcherFactory() {
        PinotConfiguration segmentFetcherFactoryConfig = this._config.subset("pinot.controller.segment.fetcher");
        LOGGER.info("Initializing SegmentFetcherFactory");
        try {
            SegmentFetcherFactory.init((PinotConfiguration)segmentFetcherFactoryConfig);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while initializing SegmentFetcherFactory", e);
        }
    }

    private void initPinotCrypterFactory() {
        PinotConfiguration pinotCrypterConfig = this._config.subset("pinot.controller.crypter");
        LOGGER.info("Initializing PinotCrypterFactory");
        try {
            PinotCrypterFactory.init((PinotConfiguration)pinotCrypterConfig);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while initializing PinotCrypterFactory", e);
        }
    }

    private void registerAndConnectAsHelixParticipant() {
        this._helixParticipantManager.getStateMachineEngine().registerStateModelFactory("MasterSlave", (StateModelFactory)new LeadControllerResourceMasterSlaveStateModelFactory(this._leadControllerManager));
        try {
            this._helixParticipantManager.connect();
        }
        catch (Exception e) {
            String errorMsg = String.format("Exception when connecting the instance %s as Participant role to Helix.", this._helixParticipantInstanceId);
            LOGGER.error(errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg);
        }
        LOGGER.info("Registering helix controller listener");
        this._helixParticipantManager.addControllerListener(changeContext -> this._leadControllerManager.onHelixControllerChange());
        LOGGER.info("Registering resource config listener");
        try {
            this._helixParticipantManager.addResourceConfigChangeListener((resourceConfigList, changeContext) -> this._leadControllerManager.onResourceConfigChange());
        }
        catch (Exception e) {
            throw new RuntimeException("Error registering resource config listener for leadControllerResource", e);
        }
    }

    public ControllerConf.ControllerMode getControllerMode() {
        return this._controllerMode;
    }

    @VisibleForTesting
    protected List<PeriodicTask> setupControllerPeriodicTasks() {
        LOGGER.info("Setting up periodic tasks");
        ArrayList<PeriodicTask> periodicTasks = new ArrayList<PeriodicTask>();
        this._taskManager = new PinotTaskManager(this._helixTaskResourceManager, this._helixResourceManager, this._leadControllerManager, this._config, this._controllerMetrics);
        periodicTasks.add((PeriodicTask)this._taskManager);
        this._retentionManager = new RetentionManager(this._helixResourceManager, this._leadControllerManager, this._config, this._controllerMetrics);
        periodicTasks.add((PeriodicTask)this._retentionManager);
        this._offlineSegmentIntervalChecker = new OfflineSegmentIntervalChecker(this._config, this._helixResourceManager, this._leadControllerManager, new ValidationMetrics(this._metricsRegistry), this._controllerMetrics);
        periodicTasks.add((PeriodicTask)this._offlineSegmentIntervalChecker);
        this._realtimeSegmentValidationManager = new RealtimeSegmentValidationManager(this._config, this._helixResourceManager, this._leadControllerManager, this._pinotLLCRealtimeSegmentManager, new ValidationMetrics(this._metricsRegistry), this._controllerMetrics);
        periodicTasks.add((PeriodicTask)this._realtimeSegmentValidationManager);
        this._brokerResourceValidationManager = new BrokerResourceValidationManager(this._config, this._helixResourceManager, this._leadControllerManager, this._controllerMetrics);
        periodicTasks.add((PeriodicTask)this._brokerResourceValidationManager);
        this._segmentStatusChecker = new SegmentStatusChecker(this._helixResourceManager, this._leadControllerManager, this._config, this._controllerMetrics);
        periodicTasks.add((PeriodicTask)this._segmentStatusChecker);
        this._segmentRelocator = new SegmentRelocator(this._helixResourceManager, this._leadControllerManager, this._config, this._controllerMetrics, this._executorService);
        periodicTasks.add((PeriodicTask)this._segmentRelocator);
        return periodicTasks;
    }

    public void stop() {
        switch (this._controllerMode) {
            case DUAL: {
                this.stopPinotController();
                this.stopHelixController();
                break;
            }
            case PINOT_ONLY: {
                this.stopPinotController();
                break;
            }
            case HELIX_ONLY: {
                this.stopHelixController();
            }
        }
        LOGGER.info("Deregistering service status handler");
        ServiceStatus.removeServiceStatusCallback((String)this._helixParticipantInstanceId);
        LOGGER.info("Shutdown Controller Metrics Registry");
        this._metricsRegistry.shutdown();
        LOGGER.info("Finish shutting down Pinot controller for {}", (Object)this._helixParticipantInstanceId);
    }

    private void stopHelixController() {
        LOGGER.info("Disconnecting helix controller zk manager");
        this._helixControllerManager.disconnect();
    }

    private void stopPinotController() {
        try {
            LOGGER.info("Stopping controller periodic tasks");
            this._periodicTaskScheduler.stop();
            LOGGER.info("Stopping lead controller manager");
            this._leadControllerManager.stop();
            this._pinotLLCRealtimeSegmentManager.stop();
            LOGGER.info("Closing PinotFS classes");
            PinotFSFactory.shutdown();
            LOGGER.info("Stopping Jersey admin API");
            this._adminApp.stop();
            if (this._realtimeSegmentsManager != null) {
                LOGGER.info("Stopping realtime segment manager");
                this._realtimeSegmentsManager.stop();
            }
            LOGGER.info("Stopping resource manager");
            this._helixResourceManager.stop();
            LOGGER.info("Disconnecting helix participant zk manager");
            this._helixParticipantManager.disconnect();
            LOGGER.info("Shutting down executor service");
            this._executorService.shutdownNow();
            this._executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while shutting down", (Throwable)e);
        }
    }

    public MetricsRegistry getMetricsRegistry() {
        return this._metricsRegistry;
    }

    @VisibleForTesting
    public ControllerMetrics getControllerMetrics() {
        return this._controllerMetrics;
    }

    public static ControllerStarter startDefault() {
        return ControllerStarter.startDefault(null);
    }

    public static ControllerStarter startDefault(File webappPath) {
        ControllerConf conf = new ControllerConf();
        conf.setControllerHost("localhost");
        conf.setControllerPort("9000");
        conf.setDataDir("/tmp/PinotController");
        conf.setZkStr("localhost:2122");
        conf.setHelixClusterName("quickstart");
        if (webappPath == null) {
            String path = ControllerStarter.class.getClassLoader().getResource("webapp").getFile();
            if (!path.startsWith("file://")) {
                path = "file://" + path;
            }
            conf.setQueryConsolePath(path);
        } else {
            conf.setQueryConsolePath("file://" + webappPath.getAbsolutePath());
        }
        conf.setControllerVipHost("localhost");
        conf.setControllerVipProtocol("http");
        conf.setRetentionControllerFrequencyInSeconds(21600);
        conf.setOfflineSegmentIntervalCheckerFrequencyInSeconds(3600);
        conf.setRealtimeSegmentValidationFrequencyInSeconds(3600);
        conf.setBrokerResourceValidationFrequencyInSeconds(3600);
        conf.setStatusCheckerFrequencyInSeconds(300);
        conf.setSegmentRelocatorFrequencyInSeconds(3600);
        conf.setStatusCheckerWaitForPushTimeInSeconds(600);
        conf.setTenantIsolationEnabled(true);
        ControllerStarter starter = new ControllerStarter(conf);
        starter.start();
        return starter;
    }

    public static void main(String[] args) {
        ControllerStarter.startDefault();
    }
}

