/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerGauge;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.utils.helix.LeadControllerUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LeadControllerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeadControllerManager.class);
    private static final long CONTROLLER_LEADERSHIP_FETCH_INTERVAL_MS = 60000L;
    private final Set<Integer> _leadForPartitions;
    private final String _instanceId;
    private final HelixManager _helixManager;
    private final ControllerMetrics _controllerMetrics;
    private final Thread _controllerLeadershipFetchingThread;
    private volatile boolean _isLeadControllerResourceEnabled = false;
    private volatile boolean _amIHelixLeader = false;
    private volatile boolean _isShuttingDown = false;

    public LeadControllerManager(HelixManager helixParticipantManager, ControllerMetrics controllerMetrics) {
        this._helixManager = helixParticipantManager;
        this._controllerMetrics = controllerMetrics;
        this._instanceId = helixParticipantManager.getInstanceName();
        this._leadForPartitions = ConcurrentHashMap.newKeySet();
        this._controllerLeadershipFetchingThread = new Thread("ControllerLeadershipFetchingThread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            LeadControllerManager leadControllerManager = LeadControllerManager.this;
                            synchronized (leadControllerManager) {
                                if (LeadControllerManager.this._isShuttingDown) {
                                    return;
                                }
                                if (LeadControllerManager.this.isHelixLeader()) {
                                    if (!LeadControllerManager.this._amIHelixLeader) {
                                        LeadControllerManager.this._amIHelixLeader = true;
                                        LOGGER.warn("Becoming leader without getting Helix change callback");
                                        LeadControllerManager.this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_LEADERSHIP_CHANGE_WITHOUT_CALLBACK, 1L);
                                    }
                                    LeadControllerManager.this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.PINOT_CONTROLLER_LEADER, 1L);
                                } else {
                                    if (LeadControllerManager.this._amIHelixLeader) {
                                        LeadControllerManager.this._amIHelixLeader = false;
                                        LOGGER.warn("Losing leadership without getting Helix change callback");
                                        LeadControllerManager.this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_LEADERSHIP_CHANGE_WITHOUT_CALLBACK, 1L);
                                    }
                                    LeadControllerManager.this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.PINOT_CONTROLLER_LEADER, 0L);
                                }
                                LeadControllerManager.this.wait(60000L);
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Caught exception within controller leadership fetching thread", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        };
    }

    public boolean isLeaderForTable(String tableName) {
        if (this._isLeadControllerResourceEnabled) {
            String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
            int partitionId = LeadControllerUtils.getPartitionIdForTable((String)rawTableName);
            return this._leadForPartitions.contains(partitionId);
        }
        return this._amIHelixLeader;
    }

    public synchronized void addPartitionLeader(String partitionName) {
        LOGGER.info("Add Partition: {} to LeadControllerManager", (Object)partitionName);
        int partitionId = LeadControllerUtils.extractPartitionId((String)partitionName);
        this._leadForPartitions.add(partitionId);
        this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.CONTROLLER_LEADER_PARTITION_COUNT, (long)this._leadForPartitions.size());
    }

    public synchronized void removePartitionLeader(String partitionName) {
        LOGGER.info("Remove Partition: {} from LeadControllerManager", (Object)partitionName);
        int partitionId = LeadControllerUtils.extractPartitionId((String)partitionName);
        this._leadForPartitions.remove(partitionId);
        this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.CONTROLLER_LEADER_PARTITION_COUNT, (long)this._leadForPartitions.size());
    }

    private boolean isHelixLeader() {
        try {
            String helixLeaderInstanceId = LeadControllerUtils.getHelixClusterLeader((HelixManager)this._helixManager);
            if (helixLeaderInstanceId == null) {
                LOGGER.warn("Helix leader ZNode is missing");
                return false;
            }
            return this._instanceId.equals("Controller_" + helixLeaderInstanceId);
        }
        catch (Exception e) {
            LOGGER.error("Exception when getting Helix leader", (Throwable)e);
            return false;
        }
    }

    public synchronized void start() {
        this._controllerLeadershipFetchingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LeadControllerManager leadControllerManager = this;
        synchronized (leadControllerManager) {
            this._isShuttingDown = true;
            this.notify();
        }
        this._leadForPartitions.clear();
        try {
            this._controllerLeadershipFetchingThread.join();
        }
        catch (InterruptedException e) {
            LOGGER.error("Caught InterruptedException while waiting for controller leadership fetching thread to die");
            Thread.currentThread().interrupt();
        }
    }

    synchronized void onHelixControllerChange() {
        if (this._isShuttingDown) {
            return;
        }
        if (this.isHelixLeader()) {
            if (!this._amIHelixLeader) {
                this._amIHelixLeader = true;
                LOGGER.info("Became Helix leader");
            } else {
                LOGGER.info("Already Helix leader. Duplicate notification");
            }
            this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.PINOT_CONTROLLER_LEADER, 1L);
        } else {
            if (this._amIHelixLeader) {
                this._amIHelixLeader = false;
                LOGGER.info("Lost Helix leadership");
            } else {
                LOGGER.info("Already not Helix leader. Duplicate notification");
            }
            this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.PINOT_CONTROLLER_LEADER, 0L);
        }
    }

    synchronized void onResourceConfigChange() {
        boolean leadControllerResourceEnabled;
        if (this._isShuttingDown) {
            return;
        }
        try {
            leadControllerResourceEnabled = LeadControllerUtils.isLeadControllerResourceEnabled((HelixManager)this._helixManager);
        }
        catch (Exception e) {
            LOGGER.error("Exception when checking whether lead controller resource is enabled or not.", (Throwable)e);
            return;
        }
        if (leadControllerResourceEnabled) {
            LOGGER.info("Lead controller resource is enabled.");
            this._isLeadControllerResourceEnabled = true;
            this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.PINOT_LEAD_CONTROLLER_RESOURCE_ENABLED, 1L);
        } else {
            LOGGER.info("Lead controller resource is disabled.");
            this._isLeadControllerResourceEnabled = false;
            this._controllerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ControllerGauge.PINOT_LEAD_CONTROLLER_RESOURCE_ENABLED, 0L);
        }
    }
}

