/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.helix.HelixAdmin;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.resources.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Cluster"})
@Path(value="/")
public class PinotClusterConfigs {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotClusterConfigs.class);
    @Inject
    PinotHelixResourceManager pinotHelixResourceManager;

    @GET
    @Path(value="/cluster/info")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get cluster Info", notes="Get cluster Info")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public String getClusterInfo() {
        ObjectNode ret = JsonUtils.newObjectNode();
        ret.put("clusterName", this.pinotHelixResourceManager.getHelixClusterName());
        return ret.toString();
    }

    @GET
    @Path(value="/cluster/configs")
    @Produces(value={"application/json"})
    @ApiOperation(value="List cluster configurations", notes="List cluster level configurations")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public String listClusterConfigs() {
        HelixAdmin helixAdmin = this.pinotHelixResourceManager.getHelixAdmin();
        HelixConfigScope configScope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.CLUSTER).forCluster(this.pinotHelixResourceManager.getHelixClusterName()).build();
        List configKeys = helixAdmin.getConfigKeys(configScope);
        ObjectNode ret = JsonUtils.newObjectNode();
        Map configs = helixAdmin.getConfig(configScope, configKeys);
        for (String key : configs.keySet()) {
            ret.put(key, (String)configs.get(key));
        }
        return ret.toString();
    }

    @POST
    @Path(value="/cluster/configs")
    @Authenticate(value=AccessType.UPDATE)
    @ApiOperation(value="Update cluster configuration")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Server error updating configuration")})
    public SuccessResponse updateClusterConfig(String body) {
        try {
            JsonNode jsonNode = JsonUtils.stringToJsonNode((String)body);
            HelixAdmin admin = this.pinotHelixResourceManager.getHelixAdmin();
            HelixConfigScope configScope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.CLUSTER).forCluster(this.pinotHelixResourceManager.getHelixClusterName()).build();
            Iterator fieldNamesIterator = jsonNode.fieldNames();
            while (fieldNamesIterator.hasNext()) {
                String key = (String)fieldNamesIterator.next();
                String value = jsonNode.get(key).textValue();
                admin.setConfig(configScope, Collections.singletonMap(key, value));
            }
            return new SuccessResponse("Updated cluster config.");
        }
        catch (IOException e) {
            throw new ControllerApplicationException(LOGGER, "Error converting request to cluster config.", Response.Status.BAD_REQUEST, (Throwable)e);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Failed to update cluster config.", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @DELETE
    @Path(value="/cluster/configs/{configName}")
    @Authenticate(value=AccessType.DELETE)
    @ApiOperation(value="Delete cluster configuration")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Server error deleting configuration")})
    public SuccessResponse deleteClusterConfig(@ApiParam(value="Name of the config to delete", required=true) @PathParam(value="configName") String configName) {
        try {
            HelixAdmin admin = this.pinotHelixResourceManager.getHelixAdmin();
            HelixConfigScope configScope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.CLUSTER).forCluster(this.pinotHelixResourceManager.getHelixClusterName()).build();
            admin.removeConfig(configScope, Arrays.asList(configName));
            return new SuccessResponse("Deleted cluster config: " + configName);
        }
        catch (Exception e) {
            String errStr = "Failed to delete cluster config: " + configName;
            throw new ControllerApplicationException(LOGGER, errStr, Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }
}

