/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.assignment.InstanceAssignmentConfigUtils;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.common.assignment.InstancePartitionsUtils;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.resources.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.assignment.instance.InstanceAssignmentDriver;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Table"})
@Path(value="/")
public class PinotInstanceAssignmentRestletResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotInstanceAssignmentRestletResource.class);
    @Inject
    PinotHelixResourceManager _resourceManager;

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/instancePartitions")
    @ApiOperation(value="Get the instance partitions")
    public Map<InstancePartitionsType, InstancePartitions> getInstancePartitions(@ApiParam(value="Name of the table") @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|CONSUMING|COMPLETED") @QueryParam(value="type") @Nullable InstancePartitionsType instancePartitionsType) {
        InstancePartitions offlineInstancePartitions;
        TreeMap<InstancePartitionsType, InstancePartitions> instancePartitionsMap = new TreeMap<InstancePartitionsType, InstancePartitions>();
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        if (tableType != TableType.REALTIME && (instancePartitionsType == InstancePartitionsType.OFFLINE || instancePartitionsType == null) && (offlineInstancePartitions = InstancePartitionsUtils.fetchInstancePartitions(this._resourceManager.getPropertyStore(), (String)InstancePartitionsType.OFFLINE.getInstancePartitionsName(rawTableName))) != null) {
            instancePartitionsMap.put(InstancePartitionsType.OFFLINE, offlineInstancePartitions);
        }
        if (tableType != TableType.OFFLINE) {
            InstancePartitions completedInstancePartitions;
            InstancePartitions consumingInstancePartitions;
            if ((instancePartitionsType == InstancePartitionsType.CONSUMING || instancePartitionsType == null) && (consumingInstancePartitions = InstancePartitionsUtils.fetchInstancePartitions(this._resourceManager.getPropertyStore(), (String)InstancePartitionsType.CONSUMING.getInstancePartitionsName(rawTableName))) != null) {
                instancePartitionsMap.put(InstancePartitionsType.CONSUMING, consumingInstancePartitions);
            }
            if ((instancePartitionsType == InstancePartitionsType.COMPLETED || instancePartitionsType == null) && (completedInstancePartitions = InstancePartitionsUtils.fetchInstancePartitions(this._resourceManager.getPropertyStore(), (String)InstancePartitionsType.COMPLETED.getInstancePartitionsName(rawTableName))) != null) {
                instancePartitionsMap.put(InstancePartitionsType.COMPLETED, completedInstancePartitions);
            }
        }
        if (instancePartitionsMap.isEmpty()) {
            throw new ControllerApplicationException(LOGGER, "Failed to find the instance partitions", Response.Status.NOT_FOUND);
        }
        return instancePartitionsMap;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/assignInstances")
    @Authenticate(value=AccessType.CREATE)
    @ApiOperation(value="Assign server instances to a table")
    public Map<InstancePartitionsType, InstancePartitions> assignInstances(@ApiParam(value="Name of the table") @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|CONSUMING|COMPLETED") @QueryParam(value="type") @Nullable InstancePartitionsType instancePartitionsType, @ApiParam(value="Whether to do dry-run") @DefaultValue(value="false") @QueryParam(value="dryRun") boolean dryRun) {
        TableConfig realtimeTableConfig;
        TableConfig offlineTableConfig;
        TreeMap<InstancePartitionsType, InstancePartitions> instancePartitionsMap = new TreeMap<InstancePartitionsType, InstancePartitions>();
        List<InstanceConfig> instanceConfigs = this._resourceManager.getAllHelixInstanceConfigs();
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        if (tableType != TableType.REALTIME && (instancePartitionsType == InstancePartitionsType.OFFLINE || instancePartitionsType == null) && (offlineTableConfig = this._resourceManager.getOfflineTableConfig(tableName)) != null) {
            try {
                if (InstanceAssignmentConfigUtils.allowInstanceAssignment((TableConfig)offlineTableConfig, (InstancePartitionsType)InstancePartitionsType.OFFLINE)) {
                    instancePartitionsMap.put(InstancePartitionsType.OFFLINE, new InstanceAssignmentDriver(offlineTableConfig).assignInstances(InstancePartitionsType.OFFLINE, instanceConfigs));
                }
            }
            catch (IllegalStateException e) {
                throw new ControllerApplicationException(LOGGER, "Caught IllegalStateException", Response.Status.BAD_REQUEST, (Throwable)e);
            }
            catch (Exception e) {
                throw new ControllerApplicationException(LOGGER, "Caught exception while calculating the instance partitions", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        if (tableType != TableType.OFFLINE && instancePartitionsType != InstancePartitionsType.OFFLINE && (realtimeTableConfig = this._resourceManager.getRealtimeTableConfig(tableName)) != null) {
            try {
                InstanceAssignmentDriver instanceAssignmentDriver = new InstanceAssignmentDriver(realtimeTableConfig);
                if ((instancePartitionsType == InstancePartitionsType.CONSUMING || instancePartitionsType == null) && InstanceAssignmentConfigUtils.allowInstanceAssignment((TableConfig)realtimeTableConfig, (InstancePartitionsType)InstancePartitionsType.CONSUMING)) {
                    instancePartitionsMap.put(InstancePartitionsType.CONSUMING, instanceAssignmentDriver.assignInstances(InstancePartitionsType.CONSUMING, instanceConfigs));
                }
                if ((instancePartitionsType == InstancePartitionsType.COMPLETED || instancePartitionsType == null) && InstanceAssignmentConfigUtils.allowInstanceAssignment((TableConfig)realtimeTableConfig, (InstancePartitionsType)InstancePartitionsType.COMPLETED)) {
                    instancePartitionsMap.put(InstancePartitionsType.COMPLETED, instanceAssignmentDriver.assignInstances(InstancePartitionsType.COMPLETED, instanceConfigs));
                }
            }
            catch (IllegalStateException e) {
                throw new ControllerApplicationException(LOGGER, "Caught IllegalStateException", Response.Status.BAD_REQUEST, (Throwable)e);
            }
            catch (Exception e) {
                throw new ControllerApplicationException(LOGGER, "Caught exception while calculating the instance partitions", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        if (instancePartitionsMap.isEmpty()) {
            throw new ControllerApplicationException(LOGGER, "Failed to find the instance assignment config", Response.Status.NOT_FOUND);
        }
        if (!dryRun) {
            for (InstancePartitions instancePartitions : instancePartitionsMap.values()) {
                this.persistInstancePartitionsHelper(instancePartitions);
            }
        }
        return instancePartitionsMap;
    }

    private void persistInstancePartitionsHelper(InstancePartitions instancePartitions) {
        try {
            LOGGER.info("Persisting instance partitions: {}", (Object)instancePartitions);
            InstancePartitionsUtils.persistInstancePartitions(this._resourceManager.getPropertyStore(), (InstancePartitions)instancePartitions);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Caught Exception while persisting the instance partitions", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/instancePartitions")
    @Authenticate(value=AccessType.UPDATE)
    @ApiOperation(value="Create/update the instance partitions")
    public Map<InstancePartitionsType, InstancePartitions> setInstancePartitions(@ApiParam(value="Name of the table") @PathParam(value="tableName") String tableName, String instancePartitionsStr) {
        InstancePartitions instancePartitions;
        try {
            instancePartitions = (InstancePartitions)JsonUtils.stringToObject((String)instancePartitionsStr, InstancePartitions.class);
        }
        catch (IOException e) {
            throw new ControllerApplicationException(LOGGER, "Failed to deserialize the instance partitions", Response.Status.BAD_REQUEST);
        }
        String instancePartitionsName = instancePartitions.getInstancePartitionsName();
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        if (tableType != TableType.REALTIME && InstancePartitionsType.OFFLINE.getInstancePartitionsName(rawTableName).equals(instancePartitionsName)) {
            this.persistInstancePartitionsHelper(instancePartitions);
            return Collections.singletonMap(InstancePartitionsType.OFFLINE, instancePartitions);
        }
        if (tableType != TableType.OFFLINE) {
            if (InstancePartitionsType.CONSUMING.getInstancePartitionsName(rawTableName).equals(instancePartitionsName)) {
                this.persistInstancePartitionsHelper(instancePartitions);
                return Collections.singletonMap(InstancePartitionsType.CONSUMING, instancePartitions);
            }
            if (InstancePartitionsType.COMPLETED.getInstancePartitionsName(rawTableName).equals(instancePartitionsName)) {
                this.persistInstancePartitionsHelper(instancePartitions);
                return Collections.singletonMap(InstancePartitionsType.COMPLETED, instancePartitions);
            }
        }
        throw new ControllerApplicationException(LOGGER, "Instance partitions cannot be applied to the table", Response.Status.BAD_REQUEST);
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/instancePartitions")
    @Authenticate(value=AccessType.DELETE)
    @ApiOperation(value="Remove the instance partitions")
    public SuccessResponse removeInstancePartitions(@ApiParam(value="Name of the table") @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|CONSUMING|COMPLETED") @QueryParam(value="type") @Nullable InstancePartitionsType instancePartitionsType) {
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        if (tableType != TableType.REALTIME && (instancePartitionsType == InstancePartitionsType.OFFLINE || instancePartitionsType == null)) {
            this.removeInstancePartitionsHelper(InstancePartitionsType.OFFLINE.getInstancePartitionsName(rawTableName));
        }
        if (tableType != TableType.OFFLINE) {
            if (instancePartitionsType == InstancePartitionsType.CONSUMING || instancePartitionsType == null) {
                this.removeInstancePartitionsHelper(InstancePartitionsType.CONSUMING.getInstancePartitionsName(rawTableName));
            }
            if (instancePartitionsType == InstancePartitionsType.COMPLETED || instancePartitionsType == null) {
                this.removeInstancePartitionsHelper(InstancePartitionsType.COMPLETED.getInstancePartitionsName(rawTableName));
            }
        }
        return new SuccessResponse("Instance partitions removed");
    }

    private void removeInstancePartitionsHelper(String instancePartitionsName) {
        try {
            LOGGER.info("Removing instance partitions: {}", (Object)instancePartitionsName);
            InstancePartitionsUtils.removeInstancePartitions(this._resourceManager.getPropertyStore(), (String)instancePartitionsName);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Caught Exception while removing the instance partitions", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/replaceInstance")
    @Authenticate(value=AccessType.CREATE)
    @ApiOperation(value="Replace an instance in the instance partitions")
    public Map<InstancePartitionsType, InstancePartitions> replaceInstance(@ApiParam(value="Name of the table") @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|CONSUMING|COMPLETED") @QueryParam(value="type") @Nullable InstancePartitionsType instancePartitionsType, @ApiParam(value="Old instance to be replaced", required=true) @QueryParam(value="oldInstanceId") String oldInstanceId, @ApiParam(value="New instance to replace with", required=true) @QueryParam(value="newInstanceId") String newInstanceId) {
        Map<InstancePartitionsType, InstancePartitions> instancePartitionsMap = this.getInstancePartitions(tableName, instancePartitionsType);
        Iterator<InstancePartitions> iterator = instancePartitionsMap.values().iterator();
        while (iterator.hasNext()) {
            InstancePartitions instancePartitions = iterator.next();
            boolean oldInstanceFound = false;
            Map partitionToInstancesMap = instancePartitions.getPartitionToInstancesMap();
            for (List instances : partitionToInstancesMap.values()) {
                oldInstanceFound |= Collections.replaceAll(instances, oldInstanceId, newInstanceId);
            }
            if (oldInstanceFound) {
                this.persistInstancePartitionsHelper(instancePartitions);
                continue;
            }
            iterator.remove();
        }
        if (instancePartitionsMap.isEmpty()) {
            throw new ControllerApplicationException(LOGGER, "Failed to find the old instance", Response.Status.NOT_FOUND);
        }
        return instancePartitionsMap;
    }
}

