/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.pinot.common.config.tuner.TableConfigTunerRegistry;
import org.apache.pinot.common.exception.TableNotFoundException;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.api.access.AccessControlFactory;
import org.apache.pinot.controller.api.access.AccessControlUtils;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.resources.Constants;
import org.apache.pinot.controller.api.resources.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.StateType;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.rebalance.RebalanceResult;
import org.apache.pinot.controller.recommender.RecommenderDriver;
import org.apache.pinot.core.util.ReplicationUtils;
import org.apache.pinot.core.util.TableConfigUtils;
import org.apache.pinot.spi.config.table.QuotaConfig;
import org.apache.pinot.spi.config.table.SegmentsValidationAndRetentionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableStats;
import org.apache.pinot.spi.config.table.TableTaskConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.TunerConfig;
import org.apache.pinot.spi.config.table.tuner.TableConfigTuner;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.DataSizeUtils;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.glassfish.grizzly.http.server.Request;
import org.quartz.CronScheduleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Table"})
@Path(value="/")
public class PinotTableRestletResource {
    public static Logger LOGGER = LoggerFactory.getLogger(PinotTableRestletResource.class);
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;
    @Inject
    ControllerConf _controllerConf;
    @Inject
    ControllerMetrics _controllerMetrics;
    @Inject
    ExecutorService _executorService;
    @Inject
    AccessControlFactory _accessControlFactory;
    AccessControlUtils _accessControlUtils = new AccessControlUtils();

    @POST
    @Produces(value={"application/json"})
    @Path(value="/tables")
    @ApiOperation(value="Adds a table", notes="Adds a table")
    public SuccessResponse addTable(String tableConfigStr, @Context HttpHeaders httpHeaders, @Context Request request) {
        String tableName;
        TableConfig tableConfig;
        try {
            tableConfig = (TableConfig)JsonUtils.stringToObject((String)tableConfigStr, TableConfig.class);
            tableName = tableConfig.getTableName();
            String endpointUrl = request.getRequestURL().toString();
            this._accessControlUtils.validatePermission(tableName, AccessType.CREATE, httpHeaders, endpointUrl, this._accessControlFactory.create());
            Schema schema = this._pinotHelixResourceManager.getSchemaForTableConfig(tableConfig);
            TunerConfig tunerConfig = tableConfig.getTunerConfig();
            if (tunerConfig != null && tunerConfig.getName() != null && !tunerConfig.getName().isEmpty()) {
                TableConfigTuner tuner = TableConfigTunerRegistry.getTuner((String)tunerConfig.getName());
                tuner.init(tunerConfig, schema);
                tableConfig = tuner.apply(tableConfig);
            }
            TableConfigUtils.validate((TableConfig)tableConfig, (Schema)schema);
            TableConfigUtils.validateTableName((TableConfig)tableConfig);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST, (Throwable)e);
        }
        try {
            this.ensureMinReplicas(tableConfig);
            this.ensureStorageQuotaConstraints(tableConfig);
            this.verifyTableConfigs(tableConfig);
            this._pinotHelixResourceManager.addTable(tableConfig);
            return new SuccessResponse("Table " + tableName + " succesfully added");
        }
        catch (Exception e) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_ADD_ERROR, 1L);
            if (e instanceof PinotHelixResourceManager.InvalidTableConfigException) {
                String errStr = String.format("Invalid table config for table %s: %s", tableName, e.getMessage());
                throw new ControllerApplicationException(LOGGER, errStr, Response.Status.BAD_REQUEST, (Throwable)e);
            }
            if (e instanceof PinotHelixResourceManager.TableAlreadyExistsException) {
                throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.CONFLICT, (Throwable)e);
            }
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/tables/recommender")
    @ApiOperation(value="Recommend config", notes="Recommend a config with input json")
    public String recommendConfig(String inputStr) {
        try {
            return RecommenderDriver.run(inputStr);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST, (Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tables")
    @ApiOperation(value="Lists all tables in cluster", notes="Lists all tables in cluster")
    public String listTableConfigs(@ApiParam(value="realtime|offline") @QueryParam(value="type") String tableTypeStr) {
        try {
            TableType tableType = null;
            if (tableTypeStr != null) {
                tableType = TableType.valueOf((String)tableTypeStr.toUpperCase());
            }
            List<String> tableNames = tableType == null ? this._pinotHelixResourceManager.getAllRawTables() : (tableType == TableType.REALTIME ? this._pinotHelixResourceManager.getAllRealtimeTables() : this._pinotHelixResourceManager.getAllOfflineTables());
            Collections.sort(tableNames);
            return JsonUtils.newObjectNode().set("tables", JsonUtils.objectToJsonNode(tableNames)).toString();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private String listTableConfigs(String tableName, @Nullable String tableTypeStr) {
        try {
            TableConfig tableConfig;
            ObjectNode ret = JsonUtils.newObjectNode();
            if ((tableTypeStr == null || TableType.OFFLINE.name().equalsIgnoreCase(tableTypeStr)) && this._pinotHelixResourceManager.hasOfflineTable(tableName)) {
                tableConfig = this._pinotHelixResourceManager.getOfflineTableConfig(tableName);
                Preconditions.checkNotNull((Object)tableConfig);
                ret.set(TableType.OFFLINE.name(), tableConfig.toJsonNode());
            }
            if ((tableTypeStr == null || TableType.REALTIME.name().equalsIgnoreCase(tableTypeStr)) && this._pinotHelixResourceManager.hasRealtimeTable(tableName)) {
                tableConfig = this._pinotHelixResourceManager.getRealtimeTableConfig(tableName);
                Preconditions.checkNotNull((Object)tableConfig);
                ret.set(TableType.REALTIME.name(), tableConfig.toJsonNode());
            }
            return ret.toString();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}")
    @Authenticate(value=AccessType.UPDATE)
    @ApiOperation(value="Get/Enable/Disable/Drop a table", notes="Get/Enable/Disable/Drop a table. If table name is the only parameter specified , the tableconfig will be printed")
    public String alterTableStateOrListTableConfig(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="enable|disable|drop") @QueryParam(value="state") String stateStr, @ApiParam(value="realtime|offline") @QueryParam(value="type") String tableTypeStr) {
        try {
            if (stateStr == null) {
                return this.listTableConfigs(tableName, tableTypeStr);
            }
            StateType stateType = Constants.validateState(stateStr);
            TableType tableType = Constants.validateTableType(tableTypeStr);
            ArrayNode ret = JsonUtils.newArrayNode();
            boolean tableExists = false;
            if (tableType != TableType.REALTIME && this._pinotHelixResourceManager.hasOfflineTable(tableName)) {
                String offlineTableName = TableNameBuilder.OFFLINE.tableNameWithType(tableName);
                ObjectNode offline = JsonUtils.newObjectNode();
                tableExists = true;
                offline.put("tableName", offlineTableName);
                offline.set("state", JsonUtils.objectToJsonNode((Object)this._pinotHelixResourceManager.toggleTableState(offlineTableName, stateType)));
                ret.add((JsonNode)offline);
            }
            if (tableType != TableType.OFFLINE && this._pinotHelixResourceManager.hasRealtimeTable(tableName)) {
                String realtimeTableName = TableNameBuilder.REALTIME.tableNameWithType(tableName);
                ObjectNode realtime = JsonUtils.newObjectNode();
                tableExists = true;
                realtime.put("tableName", realtimeTableName);
                realtime.set("state", JsonUtils.objectToJsonNode((Object)this._pinotHelixResourceManager.toggleTableState(realtimeTableName, stateType)));
                ret.add((JsonNode)realtime);
            }
            if (tableExists) {
                return ret.toString();
            }
            throw new ControllerApplicationException(LOGGER, "Table '" + tableName + "' does not exist", Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @DELETE
    @Path(value="/tables/{tableName}")
    @Authenticate(value=AccessType.DELETE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Deletes a table", notes="Deletes a table")
    public SuccessResponse deleteTable(@ApiParam(value="Name of the table to delete", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="realtime|offline") @QueryParam(value="type") String tableTypeStr) {
        TableType tableType = Constants.validateTableType(tableTypeStr);
        LinkedList<String> tablesDeleted = new LinkedList<String>();
        try {
            boolean tableExist = false;
            if (this.verifyTableType(tableName, tableType, TableType.OFFLINE)) {
                tableExist = this._pinotHelixResourceManager.hasOfflineTable(tableName);
                this._pinotHelixResourceManager.deleteOfflineTable(tableName);
                if (tableExist) {
                    tablesDeleted.add(TableNameBuilder.OFFLINE.tableNameWithType(tableName));
                }
            }
            if (this.verifyTableType(tableName, tableType, TableType.REALTIME)) {
                tableExist = this._pinotHelixResourceManager.hasRealtimeTable(tableName);
                this._pinotHelixResourceManager.deleteRealtimeTable(tableName);
                if (tableExist) {
                    tablesDeleted.add(TableNameBuilder.REALTIME.tableNameWithType(tableName));
                }
            }
            if (!tablesDeleted.isEmpty()) {
                return new SuccessResponse("Tables: " + tablesDeleted + " deleted");
            }
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        throw new ControllerApplicationException(LOGGER, "Table '" + tableName + "' with type " + tableType + " does not exist", Response.Status.NOT_FOUND);
    }

    private boolean verifyTableType(String tableName, TableType tableType, TableType expectedType) {
        if (tableType != null && tableType != expectedType) {
            return false;
        }
        TableType typeFromTableName = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        return typeFromTableName == null || typeFromTableName == expectedType;
    }

    @PUT
    @Path(value="/tables/{tableName}")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates table config for a table", notes="Updates table config for a table")
    public SuccessResponse updateTableConfig(@ApiParam(value="Name of the table to update", required=true) @PathParam(value="tableName") String tableName, String tableConfigString) throws Exception {
        TableConfig tableConfig;
        try {
            tableConfig = (TableConfig)JsonUtils.stringToObject((String)tableConfigString, TableConfig.class);
            Schema schema = this._pinotHelixResourceManager.getSchemaForTableConfig(tableConfig);
            TableConfigUtils.validate((TableConfig)tableConfig, (Schema)schema);
        }
        catch (Exception e) {
            String msg = String.format("Invalid table config: %s", tableName);
            throw new ControllerApplicationException(LOGGER, msg, Response.Status.BAD_REQUEST, (Throwable)e);
        }
        try {
            String tableNameWithType = tableConfig.getTableName();
            if (!TableNameBuilder.forType((TableType)tableConfig.getTableType()).tableNameWithType(tableName).equals(tableNameWithType)) {
                throw new ControllerApplicationException(LOGGER, "Request table " + tableName + " does not match table name in the body " + tableNameWithType, Response.Status.BAD_REQUEST);
            }
            if (!this._pinotHelixResourceManager.hasTable(tableNameWithType)) {
                throw new ControllerApplicationException(LOGGER, "Table " + tableNameWithType + " does not exist", Response.Status.NOT_FOUND);
            }
            this.ensureMinReplicas(tableConfig);
            this.ensureStorageQuotaConstraints(tableConfig);
            this.verifyTableConfigs(tableConfig);
            this._pinotHelixResourceManager.updateTableConfig(tableConfig);
        }
        catch (PinotHelixResourceManager.InvalidTableConfigException e) {
            String errStr = String.format("Failed to update configuration for %s due to: %s", tableName, e.getMessage());
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_UPDATE_ERROR, 1L);
            throw new ControllerApplicationException(LOGGER, errStr, Response.Status.BAD_REQUEST, (Throwable)e);
        }
        catch (Exception e) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_UPDATE_ERROR, 1L);
            throw e;
        }
        return new SuccessResponse("Table config updated for " + tableName);
    }

    @POST
    @Path(value="/tables/validate")
    @Produces(value={"application/json"})
    @ApiOperation(value="Validate table config for a table", notes="This API returns the table config that matches the one you get from 'GET /tables/{tableName}'. This allows us to validate table config before apply.")
    public String checkTableConfig(String tableConfigStr) {
        TableConfig tableConfig;
        try {
            tableConfig = (TableConfig)JsonUtils.stringToObject((String)tableConfigStr, TableConfig.class);
        }
        catch (IOException e) {
            String msg = String.format("Invalid table config json string: %s", tableConfigStr);
            throw new ControllerApplicationException(LOGGER, msg, Response.Status.BAD_REQUEST, (Throwable)e);
        }
        try {
            Schema schema = this._pinotHelixResourceManager.getSchemaForTableConfig(tableConfig);
            TableConfigUtils.validate((TableConfig)tableConfig, (Schema)schema);
            ObjectNode tableConfigValidateStr = JsonUtils.newObjectNode();
            if (tableConfig.getTableType() == TableType.OFFLINE) {
                tableConfigValidateStr.set(TableType.OFFLINE.name(), tableConfig.toJsonNode());
            } else {
                tableConfigValidateStr.set(TableType.REALTIME.name(), tableConfig.toJsonNode());
            }
            return tableConfigValidateStr.toString();
        }
        catch (Exception e) {
            String msg = String.format("Invalid table config: %s. %s", tableConfig.getTableName(), e.getMessage());
            throw new ControllerApplicationException(LOGGER, msg, Response.Status.BAD_REQUEST, (Throwable)e);
        }
    }

    private void ensureMinReplicas(TableConfig tableConfig) {
        boolean verifyReplication;
        boolean verifyReplicasPerPartition;
        SegmentsValidationAndRetentionConfig segmentsConfig = tableConfig.getValidationConfig();
        int configMinReplication = this._controllerConf.getDefaultTableMinReplicas();
        try {
            verifyReplicasPerPartition = ReplicationUtils.useReplicasPerPartition((TableConfig)tableConfig);
            verifyReplication = ReplicationUtils.useReplication((TableConfig)tableConfig);
        }
        catch (Exception e) {
            String errorMsg = String.format("Invalid tableIndexConfig or streamConfig: %s", e.getMessage());
            throw new PinotHelixResourceManager.InvalidTableConfigException(errorMsg, e);
        }
        if (verifyReplication) {
            try {
                int requestReplication = segmentsConfig.getReplicationNumber();
                if (requestReplication < configMinReplication) {
                    LOGGER.info("Creating table with minimum replication factor of: {} instead of requested replication: {}", (Object)configMinReplication, (Object)requestReplication);
                    segmentsConfig.setReplication(String.valueOf(configMinReplication));
                }
            }
            catch (NumberFormatException e) {
                throw new PinotHelixResourceManager.InvalidTableConfigException("Invalid replication number", e);
            }
        }
        if (verifyReplicasPerPartition) {
            String replicasPerPartitionStr = segmentsConfig.getReplicasPerPartition();
            if (replicasPerPartitionStr == null) {
                throw new PinotHelixResourceManager.InvalidTableConfigException("Field replicasPerPartition needs to be specified");
            }
            try {
                int replicasPerPartition = Integer.valueOf(replicasPerPartitionStr);
                if (replicasPerPartition < configMinReplication) {
                    LOGGER.info("Creating table with minimum replicasPerPartition of: {} instead of requested replicasPerPartition: {}", (Object)configMinReplication, (Object)replicasPerPartition);
                    segmentsConfig.setReplicasPerPartition(String.valueOf(configMinReplication));
                }
            }
            catch (NumberFormatException e) {
                throw new PinotHelixResourceManager.InvalidTableConfigException("Invalid value for replicasPerPartition: '" + replicasPerPartitionStr + "'", e);
            }
        }
    }

    private void ensureStorageQuotaConstraints(TableConfig tableConfig) {
        if (tableConfig.isDimTable()) {
            QuotaConfig quotaConfig = tableConfig.getQuotaConfig();
            String maxAllowedSize = this._controllerConf.getDimTableMaxSize();
            long maxAllowedSizeInBytes = DataSizeUtils.toBytes((String)maxAllowedSize);
            if (quotaConfig == null) {
                tableConfig.setQuotaConfig(new QuotaConfig(maxAllowedSize, null));
                LOGGER.info("Assigning default storage quota ({}) for dimension table: {}", (Object)maxAllowedSize, (Object)tableConfig.getTableName());
            } else if (quotaConfig.getStorage() == null) {
                tableConfig.setQuotaConfig(new QuotaConfig(maxAllowedSize, quotaConfig.getMaxQueriesPerSecond()));
                LOGGER.info("Assigning default storage quota ({}) for dimension table: {}", (Object)maxAllowedSize, (Object)tableConfig.getTableName());
            } else if (quotaConfig.getStorageInBytes() > maxAllowedSizeInBytes) {
                throw new PinotHelixResourceManager.InvalidTableConfigException(String.format("Invalid storage quota: %d, max allowed size: %d", quotaConfig.getStorageInBytes(), maxAllowedSizeInBytes));
            }
        }
    }

    private void verifyTableConfigs(TableConfig newTableConfig) {
        TimeUnit newTimeColumnType;
        Map taskTypeConfig;
        TableTaskConfig taskConfig;
        String rawTableName = TableNameBuilder.extractRawTableName((String)newTableConfig.getTableName());
        LOGGER.info("Validating table configs for Table: {}", (Object)rawTableName);
        TableConfig tableConfigToCompare = null;
        if (newTableConfig.getTableType() == TableType.REALTIME) {
            if (this._pinotHelixResourceManager.hasOfflineTable(rawTableName)) {
                tableConfigToCompare = this._pinotHelixResourceManager.getOfflineTableConfig(rawTableName);
            }
        } else if (this._pinotHelixResourceManager.hasRealtimeTable(rawTableName)) {
            tableConfigToCompare = this._pinotHelixResourceManager.getRealtimeTableConfig(rawTableName);
        }
        if ((taskConfig = newTableConfig.getTaskConfig()) != null && taskConfig.isTaskTypeEnabled("SegmentGenerationAndPushTask") && (taskTypeConfig = taskConfig.getConfigsForTaskType("SegmentGenerationAndPushTask")) != null && taskTypeConfig.containsKey("schedule")) {
            String cronExprStr = (String)taskTypeConfig.get("schedule");
            try {
                CronScheduleBuilder.cronSchedule((String)cronExprStr);
            }
            catch (Exception e) {
                throw new PinotHelixResourceManager.InvalidTableConfigException(String.format("SegmentGenerationAndPushTask contains an invalid cron schedule: %s", cronExprStr), e);
            }
        }
        if (tableConfigToCompare == null) {
            LOGGER.info("Table: {} is not a hybrid table. Skipping consistency check across realtime and offline parts of the table.", (Object)rawTableName);
            return;
        }
        SegmentsValidationAndRetentionConfig newSegmentConfig = newTableConfig.getValidationConfig();
        SegmentsValidationAndRetentionConfig SegmentConfigToCompare = tableConfigToCompare.getValidationConfig();
        String newTimeColumnName = newSegmentConfig.getTimeColumnName();
        String existingTimeColumnName = SegmentConfigToCompare.getTimeColumnName();
        if (!Objects.equal((Object)existingTimeColumnName, (Object)newTimeColumnName)) {
            throw new PinotHelixResourceManager.InvalidTableConfigException(String.format("Time column names are different! Existing time column name: %s. New time column name: %s", existingTimeColumnName, newTimeColumnName));
        }
        TimeUnit existingTimeColumnType = SegmentConfigToCompare.getTimeType();
        if (existingTimeColumnType != (newTimeColumnType = newSegmentConfig.getTimeType())) {
            throw new PinotHelixResourceManager.InvalidTableConfigException(String.format("Time column types are different! Existing time column type: %s. New time column type: %s", new Object[]{existingTimeColumnType, newTimeColumnType}));
        }
        LOGGER.info("Finished validating tables config for Table: {}", (Object)rawTableName);
    }

    @POST
    @Produces(value={"application/json"})
    @Authenticate(value=AccessType.UPDATE)
    @Path(value="/tables/{tableName}/rebalance")
    @ApiOperation(value="Rebalances a table (reassign instances and segments for a table)", notes="Rebalances a table (reassign instances and segments for a table)")
    public RebalanceResult rebalance(@ApiParam(value="Name of the table to rebalance", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME", required=true) @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Whether to rebalance table in dry-run mode") @DefaultValue(value="false") @QueryParam(value="dryRun") boolean dryRun, @ApiParam(value="Whether to reassign instances before reassigning segments") @DefaultValue(value="false") @QueryParam(value="reassignInstances") boolean reassignInstances, @ApiParam(value="Whether to reassign CONSUMING segments for real-time table") @DefaultValue(value="false") @QueryParam(value="includeConsuming") boolean includeConsuming, @ApiParam(value="Whether to rebalance table in bootstrap mode (regardless of minimum segment movement, reassign all segments in a round-robin fashion as if adding new segments to an empty table)") @DefaultValue(value="false") @QueryParam(value="bootstrap") boolean bootstrap, @ApiParam(value="Whether to allow downtime for the rebalance") @DefaultValue(value="false") @QueryParam(value="downtime") boolean downtime, @ApiParam(value="For no-downtime rebalance, minimum number of replicas to keep alive during rebalance, or maximum number of replicas allowed to be unavailable if value is negative") @DefaultValue(value="1") @QueryParam(value="minAvailableReplicas") int minAvailableReplicas, @ApiParam(value="Whether to use best-efforts to rebalance (not fail the rebalance when the no-downtime contract cannot be achieved)") @DefaultValue(value="false") @QueryParam(value="bestEfforts") boolean bestEfforts) {
        String tableNameWithType = this.constructTableNameWithType(tableName, tableTypeStr);
        BaseConfiguration rebalanceConfig = new BaseConfiguration();
        rebalanceConfig.addProperty("dryRun", (Object)dryRun);
        rebalanceConfig.addProperty("reassignInstances", (Object)reassignInstances);
        rebalanceConfig.addProperty("includeConsuming", (Object)includeConsuming);
        rebalanceConfig.addProperty("bootstrap", (Object)bootstrap);
        rebalanceConfig.addProperty("downtime", (Object)downtime);
        rebalanceConfig.addProperty("minReplicasToKeepUpForNoDowntime", (Object)minAvailableReplicas);
        rebalanceConfig.addProperty("bestEfforts", (Object)bestEfforts);
        try {
            if (dryRun || downtime) {
                return this._pinotHelixResourceManager.rebalanceTable(tableNameWithType, (Configuration)rebalanceConfig);
            }
            rebalanceConfig.setProperty("dryRun", (Object)true);
            RebalanceResult dryRunResult = this._pinotHelixResourceManager.rebalanceTable(tableNameWithType, (Configuration)rebalanceConfig);
            if (dryRunResult.getStatus() == RebalanceResult.Status.DONE) {
                rebalanceConfig.setProperty("dryRun", (Object)false);
                this._executorService.submit(() -> this.lambda$rebalance$0(tableNameWithType, (Configuration)rebalanceConfig));
                return new RebalanceResult(RebalanceResult.Status.IN_PROGRESS, "In progress, check controller logs for updates", dryRunResult.getInstanceAssignment(), dryRunResult.getSegmentAssignment());
            }
            return dryRunResult;
        }
        catch (TableNotFoundException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/state")
    @ApiOperation(value="Get current table state", notes="Get current table state")
    public String getTableState(@ApiParam(value="Name of the table to get its state", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="realtime|offline", required=true) @QueryParam(value="type") String tableTypeStr) {
        String tableNameWithType = this.constructTableNameWithType(tableName, tableTypeStr);
        try {
            ObjectNode data = JsonUtils.newObjectNode();
            data.put("state", this._pinotHelixResourceManager.isTableEnabled(tableNameWithType) ? "enabled" : "disabled");
            return data.toString();
        }
        catch (TableNotFoundException e) {
            throw new ControllerApplicationException(LOGGER, "Failed to find table: " + tableNameWithType, Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="/tables/{tableName}/stats")
    @Produces(value={"application/json"})
    @ApiOperation(value="table stats", notes="Provides metadata info/stats about the table.")
    public String getTableStats(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="realtime|offline") @QueryParam(value="type") String tableTypeStr) {
        TableStats tableStats;
        String tableNameWithType;
        ObjectNode ret = JsonUtils.newObjectNode();
        if ((tableTypeStr == null || TableType.OFFLINE.name().equalsIgnoreCase(tableTypeStr)) && this._pinotHelixResourceManager.hasOfflineTable(tableName)) {
            tableNameWithType = TableNameBuilder.forType((TableType)TableType.OFFLINE).tableNameWithType(tableName);
            tableStats = this._pinotHelixResourceManager.getTableStats(tableNameWithType);
            ret.set(TableType.OFFLINE.name(), JsonUtils.objectToJsonNode((Object)tableStats));
        }
        if ((tableTypeStr == null || TableType.REALTIME.name().equalsIgnoreCase(tableTypeStr)) && this._pinotHelixResourceManager.hasRealtimeTable(tableName)) {
            tableNameWithType = TableNameBuilder.forType((TableType)TableType.REALTIME).tableNameWithType(tableName);
            tableStats = this._pinotHelixResourceManager.getTableStats(tableNameWithType);
            ret.set(TableType.REALTIME.name(), JsonUtils.objectToJsonNode((Object)tableStats));
        }
        return ret.toString();
    }

    private String constructTableNameWithType(String tableName, String tableTypeStr) {
        TableType tableType;
        try {
            tableType = TableType.valueOf((String)tableTypeStr.toUpperCase());
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Illegal table type: " + tableTypeStr, Response.Status.BAD_REQUEST);
        }
        return TableNameBuilder.forType((TableType)tableType).tableNameWithType(tableName);
    }

    private /* synthetic */ void lambda$rebalance$0(String tableNameWithType, Configuration rebalanceConfig) {
        try {
            this._pinotHelixResourceManager.rebalanceTable(tableNameWithType, rebalanceConfig);
        }
        catch (Throwable t) {
            LOGGER.error("Caught exception/error while rebalancing table: {}", (Object)tableNameWithType, (Object)t);
        }
    }
}

