/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.instance;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.spi.config.table.assignment.InstanceTagPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceTagPoolSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceTagPoolSelector.class);
    private final InstanceTagPoolConfig _tagPoolConfig;
    private final String _tableNameWithType;

    public InstanceTagPoolSelector(InstanceTagPoolConfig tagPoolConfig, String tableNameWithType) {
        this._tagPoolConfig = tagPoolConfig;
        this._tableNameWithType = tableNameWithType;
    }

    /*
     * WARNING - void declaration
     */
    public Map<Integer, List<InstanceConfig>> selectInstances(List<InstanceConfig> instanceConfigs) {
        int tableNameHash = Math.abs(this._tableNameWithType.hashCode());
        LOGGER.info("Starting instance tag/pool selection for table: {} with hash: {}", (Object)this._tableNameWithType, (Object)tableNameHash);
        String tag = this._tagPoolConfig.getTag();
        ArrayList<InstanceConfig> candidateInstanceConfigs = new ArrayList<InstanceConfig>();
        for (InstanceConfig instanceConfig : instanceConfigs) {
            if (!instanceConfig.getTags().contains(tag)) continue;
            candidateInstanceConfigs.add(instanceConfig);
        }
        candidateInstanceConfigs.sort(Comparator.comparing(InstanceConfig::getInstanceName));
        int numCandidateInstances = candidateInstanceConfigs.size();
        Preconditions.checkState((numCandidateInstances > 0 ? 1 : 0) != 0, (String)"No enabled instance has the tag: %s", (Object)tag);
        LOGGER.info("{} enabled instances have the tag: {} for table: {}", new Object[]{numCandidateInstances, tag, this._tableNameWithType});
        TreeMap<Integer, List<InstanceConfig>> poolToInstanceConfigsMap = new TreeMap<Integer, List<InstanceConfig>>();
        if (this._tagPoolConfig.isPoolBased()) {
            void var9_17;
            for (InstanceConfig instanceConfig : candidateInstanceConfigs) {
                Map map = instanceConfig.getRecord().getMapField("pool");
                if (map == null || !map.containsKey(tag)) continue;
                int pool = Integer.parseInt((String)map.get(tag));
                poolToInstanceConfigsMap.computeIfAbsent(pool, k -> new ArrayList()).add(instanceConfig);
            }
            Preconditions.checkState((!poolToInstanceConfigsMap.isEmpty() ? 1 : 0) != 0, (String)"No enabled instance has the pool configured for the tag: %s", (Object)tag);
            TreeMap poolToNumInstancesMap = new TreeMap();
            for (Map.Entry entry : poolToInstanceConfigsMap.entrySet()) {
                poolToNumInstancesMap.put(entry.getKey(), ((List)entry.getValue()).size());
            }
            LOGGER.info("Number instances for each pool: {} for table: {}", poolToNumInstancesMap, (Object)this._tableNameWithType);
            Set set = poolToInstanceConfigsMap.keySet();
            List list = this._tagPoolConfig.getPools();
            if (list != null && !list.isEmpty()) {
                Preconditions.checkState((boolean)set.containsAll(list), (String)"Cannot find all instance pools configured: %s", (Object)list);
            } else {
                int numPools = poolToInstanceConfigsMap.size();
                int numPoolsToSelect = this._tagPoolConfig.getNumPools();
                if (numPoolsToSelect > 0) {
                    Preconditions.checkState((numPoolsToSelect <= numPools ? 1 : 0) != 0, (String)"Not enough instance pools (%s in the cluster, asked for %s)", (int)numPools, (int)numPoolsToSelect);
                } else {
                    numPoolsToSelect = numPools;
                }
                if (numPools == numPoolsToSelect) {
                    LOGGER.info("Selecting all {} pools: {} for table: {}", new Object[]{numPools, set, this._tableNameWithType});
                    return poolToInstanceConfigsMap;
                }
                ArrayList arrayList = new ArrayList(numPoolsToSelect);
                ArrayList poolsInCluster = new ArrayList(set);
                for (int i = 0; i < numPoolsToSelect; ++i) {
                    arrayList.add(poolsInCluster.get((tableNameHash + i) % numPools));
                }
            }
            LOGGER.info("Selecting pools: {} for table: {}", (Object)var9_17, (Object)this._tableNameWithType);
            set.retainAll((Collection<?>)var9_17);
        } else {
            LOGGER.info("Selecting {} instances for table: {}", (Object)numCandidateInstances, (Object)this._tableNameWithType);
            poolToInstanceConfigsMap.put(0, candidateInstanceConfigs);
        }
        return poolToInstanceConfigsMap;
    }
}

