/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.retention.strategy;

import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.controller.helix.core.retention.strategy.RetentionStrategy;
import org.apache.pinot.spi.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeRetentionStrategy
implements RetentionStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeRetentionStrategy.class);
    private final long _retentionMs;

    public TimeRetentionStrategy(TimeUnit timeUnit, long timeValue) {
        this._retentionMs = timeUnit.toMillis(timeValue);
    }

    @Override
    public boolean isPurgeable(String tableNameWithType, SegmentZKMetadata segmentZKMetadata) {
        long endTimeMs = segmentZKMetadata.getEndTimeMs();
        if (!TimeUtils.timeValueInValidRange((long)endTimeMs)) {
            LOGGER.warn("{} segment: {} of table: {} has invalid end time in millis: {}", new Object[]{segmentZKMetadata.getSegmentType(), segmentZKMetadata.getSegmentName(), tableNameWithType, endTimeMs});
            return false;
        }
        return System.currentTimeMillis() - endTimeMs > this._retentionMs;
    }
}

