/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.pinot.controller.recommender.exceptions.InvalidInputException;
import org.apache.pinot.controller.recommender.io.ConfigManager;
import org.apache.pinot.controller.recommender.io.InputManager;
import org.apache.pinot.controller.recommender.rules.AbstractRule;
import org.apache.pinot.controller.recommender.rules.RulesToExecute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecommenderDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecommenderDriver.class);
    private static final String RULE_EXECUTION_PREFIX = "isRecommend";
    private static final String RULE_EXECUTION_SUFFIX = "Rule";

    public static String run(String inputJson) throws InvalidInputException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        InputManager inputManager = (InputManager)objectMapper.readValue(inputJson, InputManager.class);
        inputManager.init();
        ConfigManager outputManager = inputManager.getOverWrittenConfigs();
        for (RulesToExecute.Rule value : RulesToExecute.Rule.values()) {
            try {
                AbstractRule abstractRule;
                Method ruleExecuteFlag = inputManager.getRulesToExecute().getClass().getDeclaredMethod(RULE_EXECUTION_PREFIX + value.name().replace(RULE_EXECUTION_SUFFIX, ""), new Class[0]);
                LOGGER.info("{}:{}", (Object)ruleExecuteFlag.getName(), ruleExecuteFlag.invoke((Object)inputManager.getRulesToExecute(), new Object[0]));
                if (!((Boolean)ruleExecuteFlag.invoke((Object)inputManager.getRulesToExecute(), new Object[0])).booleanValue() || (abstractRule = RulesToExecute.RuleFactory.getRule(value, inputManager, outputManager)) == null) continue;
                abstractRule.run();
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Error while executing strategy:{}", (Object)value, (Object)e);
            }
        }
        try {
            return objectMapper.writeValueAsString((Object)outputManager);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error while writing the output json string! Stack trace:", (Throwable)e);
            return "";
        }
    }
}

