/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.net.URI;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.utils.TarGzCompressionUtils;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.util.FileIngestionUtils;
import org.apache.pinot.core.indexsegment.generator.SegmentGeneratorConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.ingestion.batch.BatchConfig;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIngestionHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileIngestionHelper.class);
    private static final String WORKING_DIR_PREFIX = "working_dir";
    private static final String INPUT_DATA_DIR = "input_data_dir";
    private static final String OUTPUT_SEGMENT_DIR = "output_segment_dir";
    private static final String SEGMENT_TAR_DIR = "segment_tar_dir";
    private static final String DATA_FILE_PREFIX = "data";
    private final TableConfig _tableConfig;
    private final Schema _schema;
    private final BatchConfig _batchConfig;
    private final String _controllerHost;
    private final int _controllerPort;
    private final File _uploadDir;

    public FileIngestionHelper(TableConfig tableConfig, Schema schema, BatchConfig batchConfig, String controllerHost, int controllerPort, File uploadDir) {
        this._tableConfig = tableConfig;
        this._schema = schema;
        this._batchConfig = batchConfig;
        this._controllerHost = controllerHost;
        this._controllerPort = controllerPort;
        this._uploadDir = uploadDir;
    }

    public SuccessResponse buildSegmentAndPush(DataPayload payload) throws Exception {
        String tableNameWithType = this._tableConfig.getTableName();
        File workingDir = new File(this._uploadDir, String.format("%s_%s_%d", WORKING_DIR_PREFIX, tableNameWithType, System.currentTimeMillis()));
        LOGGER.info("Starting ingestion of {} payload to table: {} using working dir: {}", new Object[]{payload._payloadType, tableNameWithType, workingDir.getAbsolutePath()});
        File inputDir = new File(workingDir, INPUT_DATA_DIR);
        File outputDir = new File(workingDir, OUTPUT_SEGMENT_DIR);
        File segmentTarDir = new File(workingDir, SEGMENT_TAR_DIR);
        try {
            Preconditions.checkState((boolean)inputDir.mkdirs(), (String)"Could not create directory for downloading input file locally: %s", (Object)inputDir);
            Preconditions.checkState((boolean)segmentTarDir.mkdirs(), (String)"Could not create directory for segment tar file: %s", (Object)inputDir);
            File inputFile = new File(inputDir, String.format("%s.%s", DATA_FILE_PREFIX, this._batchConfig.getInputFormat().toString().toLowerCase()));
            if (payload._payloadType == PayloadType.URI) {
                FileIngestionUtils.copyURIToLocal(this._batchConfig, payload._uri, inputFile);
                LOGGER.info("Copied from URI: {} to local file: {}", (Object)payload._uri, (Object)inputFile.getAbsolutePath());
            } else {
                FileIngestionUtils.copyMultipartToLocal(payload._multiPart, inputFile);
                LOGGER.info("Copied multipart payload to local file: {}", (Object)inputDir.getAbsolutePath());
            }
            SegmentGeneratorConfig segmentGeneratorConfig = FileIngestionUtils.generateSegmentGeneratorConfig(this._tableConfig, this._batchConfig, this._schema, inputFile, outputDir);
            String segmentName = FileIngestionUtils.buildSegment(segmentGeneratorConfig);
            LOGGER.info("Built segment: {}", (Object)segmentName);
            File segmentTarFile = new File(segmentTarDir, segmentName + ".tar.gz");
            TarGzCompressionUtils.createTarGzFile((File)new File(outputDir, segmentName), (File)segmentTarFile);
            FileIngestionUtils.uploadSegment(tableNameWithType, Lists.newArrayList((Object[])new File[]{segmentTarFile}), this._controllerHost, this._controllerPort);
            LOGGER.info("Uploaded tar: {} to {}:{}", new Object[]{segmentTarFile.getAbsolutePath(), this._controllerHost, this._controllerPort});
            SuccessResponse successResponse = new SuccessResponse("Successfully ingested file into table: " + tableNameWithType + " as segment: " + segmentName);
            return successResponse;
        }
        catch (Exception e) {
            LOGGER.error("Caught exception when ingesting file to table: {}", (Object)tableNameWithType, (Object)e);
            throw e;
        }
        finally {
            FileUtils.deleteQuietly((File)workingDir);
        }
    }

    public static class DataPayload {
        PayloadType _payloadType;
        FormDataMultiPart _multiPart;
        URI _uri;

        public DataPayload(FormDataMultiPart multiPart) {
            this._payloadType = PayloadType.FILE;
            this._multiPart = multiPart;
        }

        public DataPayload(URI uri) {
            this._payloadType = PayloadType.URI;
            this._uri = uri;
        }
    }

    private static enum PayloadType {
        URI,
        FILE;

    }
}

