/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.common.metadata.segment.SegmentPartitionMetadata;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadataCustomMapModifier;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.segment.spi.partition.metadata.ColumnPartitionMetadata;
import org.apache.pinot.spi.utils.CommonConstants;

public class ZKMetadataUtils {
    private ZKMetadataUtils() {
    }

    public static void updateSegmentMetadata(SegmentZKMetadata segmentZKMetadata, SegmentMetadata segmentMetadata, CommonConstants.Segment.SegmentType segmentType) {
        segmentZKMetadata.setTableName(segmentMetadata.getTableName());
        segmentZKMetadata.setSegmentType(segmentType);
        SegmentVersion segmentVersion = segmentMetadata.getVersion();
        if (segmentVersion != null) {
            segmentZKMetadata.setIndexVersion(segmentVersion.name());
        }
        if (segmentMetadata.getTimeInterval() != null) {
            segmentZKMetadata.setStartTime(segmentMetadata.getStartTime());
            segmentZKMetadata.setEndTime(segmentMetadata.getEndTime());
            segmentZKMetadata.setTimeUnit(segmentMetadata.getTimeUnit());
        }
        segmentZKMetadata.setTotalDocs((long)segmentMetadata.getTotalDocs());
        segmentZKMetadata.setCreationTime(segmentMetadata.getIndexCreationTime());
        segmentZKMetadata.setCrc(Long.parseLong(segmentMetadata.getCrc()));
        SegmentZKMetadataCustomMapModifier segmentZKMetadataCustomMapModifier = new SegmentZKMetadataCustomMapModifier(SegmentZKMetadataCustomMapModifier.ModifyMode.UPDATE, segmentZKMetadata.getCustomMap());
        segmentZKMetadata.setCustomMap(segmentZKMetadataCustomMapModifier.modifyMap(segmentMetadata.getCustomMap()));
        HashMap<String, ColumnPartitionMetadata> columnPartitionMap = new HashMap<String, ColumnPartitionMetadata>();
        if (segmentMetadata instanceof SegmentMetadataImpl) {
            for (Map.Entry entry : segmentMetadata.getColumnMetadataMap().entrySet()) {
                String column = (String)entry.getKey();
                ColumnMetadata columnMetadata = (ColumnMetadata)entry.getValue();
                PartitionFunction partitionFunction = columnMetadata.getPartitionFunction();
                if (partitionFunction == null) continue;
                ColumnPartitionMetadata columnPartitionMetadata = new ColumnPartitionMetadata(partitionFunction.toString(), partitionFunction.getNumPartitions(), columnMetadata.getPartitions());
                columnPartitionMap.put(column, columnPartitionMetadata);
            }
        }
        if (!columnPartitionMap.isEmpty()) {
            segmentZKMetadata.setPartitionMetadata(new SegmentPartitionMetadata(columnPartitionMap));
        }
    }
}

