/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.recommender.data.generator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Random;
import org.apache.pinot.controller.recommender.data.generator.Generator;
import org.apache.pinot.controller.recommender.data.generator.MultiValueGeneratorHelper;
import org.apache.pinot.spi.data.FieldSpec;

public class NumberGenerator
implements Generator {
    private static final double DEFAULT_NUMBER_OF_VALUES_PER_ENTRY = 1.0;
    private final int _cardinality;
    private final FieldSpec.DataType _columnType;
    private final double _numberOfValuesPerEntry;
    private final int _initialValue;
    private final Random _random;
    private int _counter = 0;

    public NumberGenerator(Integer cardinality, FieldSpec.DataType type, Double numberOfValuesPerEntry) {
        this(cardinality, type, numberOfValuesPerEntry, new Random(System.currentTimeMillis()));
    }

    @VisibleForTesting
    NumberGenerator(Integer cardinality, FieldSpec.DataType type, Double numberOfValuesPerEntry, Random random) {
        this._cardinality = cardinality;
        this._numberOfValuesPerEntry = numberOfValuesPerEntry != null ? numberOfValuesPerEntry : 1.0;
        Preconditions.checkState((this._numberOfValuesPerEntry >= 1.0 ? 1 : 0) != 0, (Object)("Number of values per entry (should be >= 1): " + this._numberOfValuesPerEntry));
        this._columnType = type;
        this._random = random;
        this._initialValue = random.nextInt(100);
    }

    @Override
    public void init() {
    }

    @Override
    public Object next() {
        if (this._numberOfValuesPerEntry == 1.0) {
            return this.getNextNumber();
        }
        return MultiValueGeneratorHelper.generateMultiValueEntries(this._numberOfValuesPerEntry, this._random, this::getNextNumber);
    }

    private Number getNextNumber() {
        if (this._counter == this._cardinality) {
            this._counter = 0;
        }
        int newValue = this._initialValue + this._counter;
        ++this._counter;
        switch (this._columnType) {
            case INT: {
                return newValue;
            }
            case LONG: {
                return (long)newValue;
            }
            case FLOAT: {
                return Float.valueOf((float)newValue + 0.5f);
            }
            case DOUBLE: {
                return (double)newValue + 0.5;
            }
        }
        throw new RuntimeException("number generator can only accept a column of type number and this : " + this._columnType + " is not a supported number type");
    }

    public static void main(String[] args) {
        NumberGenerator gen = new NumberGenerator(10000000, FieldSpec.DataType.LONG, null);
        gen.init();
        for (int i = 0; i < 1000; ++i) {
            System.out.println(gen.next());
        }
    }
}

