/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.tuner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pinot.controller.tuner.TableConfigTuner;
import org.apache.pinot.controller.tuner.Tuner;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableConfigTunerRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableConfigTunerRegistry.class);
    private static final Map<String, TableConfigTuner> CONFIG_TUNER_MAP = new ConcurrentHashMap<String, TableConfigTuner>();
    private static boolean _init = false;

    private TableConfigTunerRegistry() {
    }

    public static void init(List<String> packages) {
        if (_init) {
            LOGGER.info("TableConfigTunerRegistry already initialized, skipping.");
            return;
        }
        long startTime = System.currentTimeMillis();
        ArrayList urls = new ArrayList();
        for (String pack : packages) {
            urls.addAll(ClasspathHelper.forPackage((String)pack, (ClassLoader[])new ClassLoader[0]));
        }
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(urls).filterInputsBy((Predicate)new FilterBuilder.Include(".*\\.tuner\\..*")).setScanners(new Scanner[]{new ResourcesScanner(), new TypeAnnotationsScanner(), new SubTypesScanner()}));
        Set classes = reflections.getTypesAnnotatedWith(Tuner.class);
        classes.forEach(tunerClass -> {
            Tuner tunerAnnotation = tunerClass.getAnnotation(Tuner.class);
            if (tunerAnnotation.enabled()) {
                if (tunerAnnotation.name().isEmpty()) {
                    LOGGER.error("Cannot register an unnamed config tuner for annotation {} ", (Object)tunerAnnotation);
                } else {
                    String tunerName = tunerAnnotation.name();
                    try {
                        TableConfigTuner tuner = (TableConfigTuner)tunerClass.newInstance();
                        CONFIG_TUNER_MAP.putIfAbsent(tunerName, tuner);
                    }
                    catch (Exception e) {
                        LOGGER.error(String.format("Unable to register tuner %s . Cannot instantiate.", tunerName), (Throwable)e);
                    }
                }
            }
        });
        _init = true;
        LOGGER.info("Initialized TableConfigTunerRegistry with {} tuners: {} in {} ms", new Object[]{CONFIG_TUNER_MAP.size(), CONFIG_TUNER_MAP.keySet(), System.currentTimeMillis() - startTime});
    }

    public static TableConfigTuner getTuner(String name) {
        Preconditions.checkState((boolean)_init, (Object)"TableConfigTunerRegistry not yet initialized.");
        return CONFIG_TUNER_MAP.get(name);
    }
}

