/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.segment;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.common.tier.Tier;
import org.apache.pinot.common.utils.config.TagNameUtils;
import org.apache.pinot.common.utils.helix.HelixHelper;
import org.apache.pinot.controller.helix.core.assignment.segment.SegmentAssignment;
import org.apache.pinot.controller.helix.core.assignment.segment.SegmentAssignmentUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TenantConfig;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;

public class OfflineDimTableSegmentAssignment
implements SegmentAssignment {
    private HelixManager _helixManager;
    private String _offlineTableName;
    private TenantConfig _tenantConfig;

    @Override
    public void init(HelixManager helixManager, TableConfig tableConfig) {
        Preconditions.checkState((boolean)tableConfig.isDimTable(), (Object)("Not a dimension table: %s" + this._offlineTableName));
        this._helixManager = helixManager;
        this._offlineTableName = tableConfig.getTableName();
        this._tenantConfig = tableConfig.getTenantConfig();
    }

    @Override
    public List<String> assignSegment(String segmentName, Map<String, Map<String, String>> currentAssignment, Map<InstancePartitionsType, InstancePartitions> instancePartitionsMap) {
        String serverTag = this._tenantConfig.getServer();
        Set instances = HelixHelper.getServerInstancesForTenant((HelixManager)this._helixManager, (String)serverTag);
        int numInstances = instances.size();
        Preconditions.checkState((numInstances > 0 ? 1 : 0) != 0, (String)"No instance found with tag: %s or %s", (Object)TagNameUtils.getOfflineTagForTenant((String)serverTag), (Object)TagNameUtils.getRealtimeTagForTenant((String)serverTag));
        return new ArrayList<String>(instances);
    }

    @Override
    public Map<String, Map<String, String>> rebalanceTable(Map<String, Map<String, String>> currentAssignment, Map<InstancePartitionsType, InstancePartitions> instancePartitionsMap, @Nullable List<Tier> sortedTiers, @Nullable Map<String, InstancePartitions> tierInstancePartitionsMap, Configuration config) {
        String serverTag = this._tenantConfig.getServer();
        Set instances = HelixHelper.getServerInstancesForTenant((HelixManager)this._helixManager, (String)serverTag);
        TreeMap<String, Map<String, String>> newAssignment = new TreeMap<String, Map<String, String>>();
        for (String segment : currentAssignment.keySet()) {
            newAssignment.put(segment, SegmentAssignmentUtils.getInstanceStateMap(instances, "ONLINE"));
        }
        return newAssignment;
    }
}

