/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.access;

import javax.annotation.Nullable;
import javax.ws.rs.core.HttpHeaders;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.core.auth.FineGrainedAccessControl;
import org.apache.pinot.spi.annotations.InterfaceAudience;
import org.apache.pinot.spi.annotations.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public interface AccessControl
extends FineGrainedAccessControl {
    public static final String WORKFLOW_NONE = "NONE";
    public static final String WORKFLOW_BASIC = "BASIC";

    @Deprecated
    default public boolean hasDataAccess(HttpHeaders httpHeaders, String tableName) {
        return this.hasAccess(tableName, AccessType.READ, httpHeaders, null);
    }

    default public boolean hasAccess(@Nullable String tableName, AccessType accessType, HttpHeaders httpHeaders, @Nullable String endpointUrl) {
        return true;
    }

    default public boolean hasAccess(AccessType accessType, HttpHeaders httpHeaders, @Nullable String endpointUrl) {
        return this.hasAccess(null, accessType, httpHeaders, endpointUrl);
    }

    default public boolean protectAnnotatedOnly() {
        return true;
    }

    default public AuthWorkflowInfo getAuthWorkflowInfo() {
        return new AuthWorkflowInfo(WORKFLOW_NONE);
    }

    public static class AuthWorkflowInfo {
        String _workflow;

        public AuthWorkflowInfo(String workflow) {
            this._workflow = workflow;
        }

        public String getWorkflow() {
            return this._workflow;
        }

        public void setWorkflow(String workflow) {
            this._workflow = workflow;
        }
    }
}

