/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.events;

import org.apache.pinot.controller.api.events.DefaultMetadataEventNotifierFactory;
import org.apache.pinot.controller.api.events.MetadataEventNotifier;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetadataEventNotifierFactory {
    public static final Logger LOGGER = LoggerFactory.getLogger(MetadataEventNotifierFactory.class);
    public static final String METADATA_EVENT_CLASS_CONFIG = "factory.class";

    public abstract void init(PinotConfiguration var1, PinotHelixResourceManager var2);

    public abstract MetadataEventNotifier create();

    public static MetadataEventNotifierFactory loadFactory(PinotConfiguration configuration, PinotHelixResourceManager helixResourceManager) {
        String metadataEventNotifierClassName = configuration.getProperty(METADATA_EVENT_CLASS_CONFIG, DefaultMetadataEventNotifierFactory.class.getName());
        try {
            LOGGER.info("Instantiating metadata event notifier factory class {}", (Object)metadataEventNotifierClassName);
            MetadataEventNotifierFactory metadataEventNotifierFactory = (MetadataEventNotifierFactory)Class.forName(metadataEventNotifierClassName).newInstance();
            metadataEventNotifierFactory.init(configuration, helixResourceManager);
            return metadataEventNotifierFactory;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

