/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerGauge;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.restlet.resources.EndReplaceSegmentsRequest;
import org.apache.pinot.common.restlet.resources.RevertReplaceSegmentsRequest;
import org.apache.pinot.common.restlet.resources.StartReplaceSegmentsRequest;
import org.apache.pinot.common.utils.FileUploadDownloadClient;
import org.apache.pinot.common.utils.URIUtils;
import org.apache.pinot.common.utils.fetcher.SegmentFetcherFactory;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.api.access.AccessControl;
import org.apache.pinot.controller.api.access.AccessControlFactory;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.Constants;
import org.apache.pinot.controller.api.resources.ControllerFilePathProvider;
import org.apache.pinot.controller.api.resources.ResourceUtils;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.api.resources.TrackInflightRequestMetrics;
import org.apache.pinot.controller.api.resources.TrackedByGauge;
import org.apache.pinot.controller.api.upload.SegmentValidationUtils;
import org.apache.pinot.controller.api.upload.ZKOperator;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.core.auth.Authorize;
import org.apache.pinot.core.auth.TargetType;
import org.apache.pinot.core.metadata.DefaultMetadataExtractor;
import org.apache.pinot.core.metadata.MetadataExtractorFactory;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.crypt.PinotCrypter;
import org.apache.pinot.spi.crypt.PinotCrypterFactory;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.server.ManagedAsync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Segment"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class PinotSegmentUploadDownloadRestletResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotSegmentUploadDownloadRestletResource.class);
    private static final String TMP_DIR_PREFIX = "tmp-";
    private static final String ENCRYPTED_SUFFIX = "_encrypted";
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;
    @Inject
    ControllerConf _controllerConf;
    @Inject
    ControllerMetrics _controllerMetrics;
    @Inject
    HttpClientConnectionManager _connectionManager;
    @Inject
    Executor _executor;
    @Inject
    AccessControlFactory _accessControlFactory;
    @Inject
    LeadControllerManager _leadControllerManager;

    @GET
    @Produces(value={"application/octet-stream"})
    @Path(value="/segments/{tableName}/{segmentName}")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="DownloadSegment")
    @ApiOperation(value="Download a segment", notes="Download a segment")
    @TrackInflightRequestMetrics
    @TrackedByGauge(gauge=ControllerGauge.SEGMENT_DOWNLOADS_IN_PROGRESS)
    @Authenticate(value=AccessType.READ)
    public Response downloadSegment(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @Context HttpHeaders httpHeaders) throws Exception {
        File segmentFile;
        boolean hasDataAccess;
        try {
            AccessControl accessControl = this._accessControlFactory.create();
            hasDataAccess = accessControl.hasDataAccess(httpHeaders, tableName);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Caught exception while validating access to table: " + tableName, Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        if (!hasDataAccess) {
            throw new ControllerApplicationException(LOGGER, "No data access to table: " + tableName, Response.Status.FORBIDDEN);
        }
        segmentName = URIUtils.decode((String)segmentName);
        URI dataDirURI = ControllerFilePathProvider.getInstance().getDataDirURI();
        Response.ResponseBuilder builder = Response.ok();
        if ("file".equals(dataDirURI.getScheme())) {
            File dataDir = new File(dataDirURI);
            File tableDir = org.apache.pinot.common.utils.FileUtils.concatAndValidateFile((File)dataDir, (String)tableName, (String)"Invalid table name: %s", (Object[])new Object[]{tableName});
            segmentFile = org.apache.pinot.common.utils.FileUtils.concatAndValidateFile((File)tableDir, (String)segmentName, (String)"Invalid segment name: %s", (Object[])new Object[]{segmentName});
            if (!segmentFile.exists()) {
                throw new ControllerApplicationException(LOGGER, "Segment " + segmentName + " or table " + tableName + " not found in " + segmentFile.getAbsolutePath(), Response.Status.NOT_FOUND);
            }
            builder.entity((Object)segmentFile);
        } else {
            URI remoteSegmentFileURI = URIUtils.getUri((String)dataDirURI.toString(), (String[])new String[]{tableName, URIUtils.encode((String)segmentName)});
            PinotFS pinotFS = PinotFSFactory.create((String)dataDirURI.getScheme());
            if (!pinotFS.exists(remoteSegmentFileURI)) {
                throw new ControllerApplicationException(LOGGER, "Segment: " + segmentName + " of table: " + tableName + " not found at: " + remoteSegmentFileURI, Response.Status.NOT_FOUND);
            }
            File downloadTempDir = ControllerFilePathProvider.getInstance().getFileDownloadTempDir();
            File tableDir = org.apache.pinot.common.utils.FileUtils.concatAndValidateFile((File)downloadTempDir, (String)tableName, (String)"Invalid table name: %s", (Object[])new Object[]{tableName});
            segmentFile = org.apache.pinot.common.utils.FileUtils.concatAndValidateFile((File)tableDir, (String)(segmentName + "-" + UUID.randomUUID()), (String)"Invalid segment name: %s", (Object[])new Object[]{segmentName});
            pinotFS.copyToLocalFile(remoteSegmentFileURI, segmentFile);
            builder.entity(output -> {
                try {
                    Files.copy(segmentFile.toPath(), output);
                }
                finally {
                    FileUtils.deleteQuietly((File)segmentFile);
                }
            });
        }
        builder.header("Content-Disposition", (Object)("attachment; filename=" + segmentFile.getName()));
        builder.header("Content-Length", (Object)segmentFile.length());
        return builder.build();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SuccessResponse uploadSegment(@Nullable String tableName, TableType tableType, @Nullable FormDataMultiPart multiPart, boolean copySegmentToFinalLocation, boolean enableParallelPushProtection, boolean allowRefresh, HttpHeaders headers, Request request) {
        SuccessResponse successResponse;
        TableType tableTypeFromTableName;
        if (StringUtils.isNotEmpty((String)tableName) && (tableTypeFromTableName = TableNameBuilder.getTableTypeFromTableName((String)tableName)) != null && tableTypeFromTableName != tableType) {
            throw new ControllerApplicationException(LOGGER, String.format("Table name: %s does not match table type: %s", tableName, tableType), Response.Status.BAD_REQUEST);
        }
        this.extractHttpHeader(headers, "Pinot-Segment-Name");
        this.extractHttpHeader(headers, "Pinot-Table-Name");
        String uploadTypeStr = this.extractHttpHeader(headers, "UPLOAD_TYPE");
        String sourceDownloadURIStr = this.extractHttpHeader(headers, "DOWNLOAD_URI");
        String crypterClassNameInHeader = this.extractHttpHeader(headers, "CRYPTER");
        String ingestionDescriptor = this.extractHttpHeader(headers, "Pinot-Ingestion-Descriptor");
        File tempEncryptedFile = null;
        File tempDecryptedFile = null;
        File tempSegmentDir = null;
        String segmentDownloadURIStr = sourceDownloadURIStr;
        try {
            String rawTableName;
            long segmentSizeInBytes;
            ControllerFilePathProvider provider = ControllerFilePathProvider.getInstance();
            String tempFileName = TMP_DIR_PREFIX + UUID.randomUUID();
            tempEncryptedFile = new File(provider.getFileUploadTempDir(), tempFileName + ENCRYPTED_SUFFIX);
            tempDecryptedFile = new File(provider.getFileUploadTempDir(), tempFileName);
            tempSegmentDir = new File(provider.getUntarredFileTempDir(), tempFileName);
            boolean uploadedSegmentIsEncrypted = StringUtils.isNotEmpty((String)crypterClassNameInHeader);
            FileUploadDownloadClient.FileUploadType uploadType = this.getUploadType(uploadTypeStr);
            File destFile = uploadedSegmentIsEncrypted ? tempEncryptedFile : tempDecryptedFile;
            switch (uploadType) {
                case SEGMENT: {
                    if (multiPart == null) {
                        throw new ControllerApplicationException(LOGGER, "Segment file (as multipart/form-data) is required for SEGMENT upload mode", Response.Status.BAD_REQUEST);
                    }
                    if (!copySegmentToFinalLocation && StringUtils.isEmpty((String)sourceDownloadURIStr)) {
                        throw new ControllerApplicationException(LOGGER, "Source download URI is required in header field 'DOWNLOAD_URI' if segment should not be copied to the deep store", Response.Status.BAD_REQUEST);
                    }
                    PinotSegmentUploadDownloadRestletResource.createSegmentFileFromMultipart(multiPart, destFile);
                    segmentSizeInBytes = destFile.length();
                    break;
                }
                case URI: {
                    if (StringUtils.isEmpty((String)sourceDownloadURIStr)) {
                        throw new ControllerApplicationException(LOGGER, "Source download URI is required in header field 'DOWNLOAD_URI' for URI upload mode", Response.Status.BAD_REQUEST);
                    }
                    this.downloadSegmentFileFromURI(sourceDownloadURIStr, destFile, tableName);
                    segmentSizeInBytes = destFile.length();
                    break;
                }
                case METADATA: {
                    if (multiPart == null) {
                        throw new ControllerApplicationException(LOGGER, "Segment metadata file (as multipart/form-data) is required for METADATA upload mode", Response.Status.BAD_REQUEST);
                    }
                    if (StringUtils.isEmpty((String)sourceDownloadURIStr)) {
                        throw new ControllerApplicationException(LOGGER, "Source download URI is required in header field 'DOWNLOAD_URI' for METADATA upload mode", Response.Status.BAD_REQUEST);
                    }
                    String copySegmentToDeepStore = this.extractHttpHeader(headers, "COPY_SEGMENT_TO_DEEP_STORE");
                    copySegmentToFinalLocation = Boolean.parseBoolean(copySegmentToDeepStore);
                    PinotSegmentUploadDownloadRestletResource.createSegmentFileFromMultipart(multiPart, destFile);
                    try {
                        URI segmentURI = new URI(sourceDownloadURIStr);
                        PinotFS pinotFS = PinotFSFactory.create((String)segmentURI.getScheme());
                        segmentSizeInBytes = pinotFS.length(segmentURI);
                    }
                    catch (Exception e) {
                        segmentSizeInBytes = -1L;
                        LOGGER.warn("Could not fetch segment size for metadata push", (Throwable)e);
                    }
                    break;
                }
                default: {
                    throw new ControllerApplicationException(LOGGER, "Unsupported upload type: " + uploadType, Response.Status.BAD_REQUEST);
                }
            }
            if (uploadedSegmentIsEncrypted) {
                this.decryptFile(crypterClassNameInHeader, tempEncryptedFile, tempDecryptedFile);
            }
            String metadataProviderClass = DefaultMetadataExtractor.class.getName();
            SegmentMetadata segmentMetadata = this.getSegmentMetadata(tempDecryptedFile, tempSegmentDir, metadataProviderClass);
            String segmentName = segmentMetadata.getName();
            if (StringUtils.isNotEmpty((String)tableName)) {
                rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
            } else {
                rawTableName = segmentMetadata.getTableName();
                LOGGER.warn("Table name is not provided as request query parameter when uploading segment: {} for table: {}", (Object)segmentName, (Object)rawTableName);
            }
            String tableNameWithType = tableType == TableType.OFFLINE ? TableNameBuilder.OFFLINE.tableNameWithType(rawTableName) : TableNameBuilder.REALTIME.tableNameWithType(rawTableName);
            String clientAddress = InetAddress.getByName(request.getRemoteAddr()).getHostName();
            LOGGER.info("Processing upload request for segment: {} of table: {} with upload type: {} from client: {}, ingestion descriptor: {}", new Object[]{segmentName, tableNameWithType, uploadType, clientAddress, ingestionDescriptor});
            TableConfig tableConfig = this._pinotHelixResourceManager.getTableConfig(tableNameWithType);
            if (tableConfig == null) {
                throw new ControllerApplicationException(LOGGER, "Failed to find table: " + tableNameWithType, Response.Status.BAD_REQUEST);
            }
            if (tableConfig.getIngestionConfig() == null || tableConfig.getIngestionConfig().isSegmentTimeValueCheck()) {
                SegmentValidationUtils.validateTimeInterval(segmentMetadata, tableConfig);
            }
            long untarredSegmentSizeInBytes = uploadType == FileUploadDownloadClient.FileUploadType.METADATA && segmentSizeInBytes > 0L ? segmentSizeInBytes : FileUtils.sizeOfDirectory((File)tempSegmentDir);
            SegmentValidationUtils.checkStorageQuota(segmentName, untarredSegmentSizeInBytes, tableConfig, this._pinotHelixResourceManager, this._controllerConf, this._controllerMetrics, this._connectionManager, this._executor, this._leadControllerManager.isLeaderForTable(tableNameWithType));
            String crypterNameInTableConfig = tableConfig.getValidationConfig().getCrypterClassName();
            Pair<String, File> encryptionInfo = this.encryptSegmentIfNeeded(tempDecryptedFile, tempEncryptedFile, uploadedSegmentIsEncrypted, crypterClassNameInHeader, crypterNameInTableConfig, segmentName, tableNameWithType);
            String crypterName = (String)encryptionInfo.getLeft();
            File segmentFile = (File)encryptionInfo.getRight();
            URI finalSegmentLocationURI = null;
            if (copySegmentToFinalLocation) {
                URI dataDirURI = provider.getDataDirURI();
                String dataDirPath = dataDirURI.toString();
                String encodedSegmentName = URIUtils.encode((String)segmentName);
                String finalSegmentLocationPath = URIUtils.getPath((String)dataDirPath, (String[])new String[]{rawTableName, encodedSegmentName});
                segmentDownloadURIStr = dataDirURI.getScheme().equalsIgnoreCase("file") ? URIUtils.getPath((String)provider.getVip(), (String[])new String[]{"segments", rawTableName, encodedSegmentName}) : finalSegmentLocationPath;
                finalSegmentLocationURI = URIUtils.getUri((String)finalSegmentLocationPath);
            }
            LOGGER.info("Using segment download URI: {} for segment: {} of table: {} (move segment: {})", new Object[]{segmentDownloadURIStr, segmentFile, tableNameWithType, copySegmentToFinalLocation});
            ZKOperator zkOperator = new ZKOperator(this._pinotHelixResourceManager, this._controllerConf, this._controllerMetrics);
            zkOperator.completeSegmentOperations(tableNameWithType, segmentMetadata, uploadType, finalSegmentLocationURI, segmentFile, sourceDownloadURIStr, segmentDownloadURIStr, crypterName, segmentSizeInBytes, enableParallelPushProtection, allowRefresh, headers);
            successResponse = new SuccessResponse("Successfully uploaded segment: " + segmentName + " of table: " + tableNameWithType);
        }
        catch (WebApplicationException e) {
            try {
                throw e;
                catch (Exception e2) {
                    this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_SEGMENT_UPLOAD_ERROR, 1L);
                    throw new ControllerApplicationException(LOGGER, "Exception while uploading segment: " + e2.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(tempEncryptedFile);
                FileUtils.deleteQuietly(tempDecryptedFile);
                FileUtils.deleteQuietly(tempSegmentDir);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)tempEncryptedFile);
        FileUtils.deleteQuietly((File)tempDecryptedFile);
        FileUtils.deleteQuietly((File)tempSegmentDir);
        return successResponse;
    }

    @Nullable
    private String extractHttpHeader(HttpHeaders headers, String name) {
        String value = headers.getHeaderString(name);
        if (value != null) {
            LOGGER.info("HTTP Header: {} is: {}", (Object)name, (Object)value);
        }
        return value;
    }

    @VisibleForTesting
    Pair<String, File> encryptSegmentIfNeeded(File tempDecryptedFile, File tempEncryptedFile, boolean isUploadedSegmentEncrypted, String crypterUsedInUploadedSegment, String crypterClassNameInTableConfig, String segmentName, String tableNameWithType) {
        boolean segmentNeedsEncryption = StringUtils.isNotEmpty((String)crypterClassNameInTableConfig);
        File finalSegmentFile = isUploadedSegmentEncrypted || segmentNeedsEncryption ? tempEncryptedFile : tempDecryptedFile;
        String crypterClassName = StringUtils.isEmpty((String)crypterClassNameInTableConfig) ? crypterUsedInUploadedSegment : crypterClassNameInTableConfig;
        ImmutablePair out = ImmutablePair.of((Object)crypterClassName, (Object)finalSegmentFile);
        if (!segmentNeedsEncryption) {
            return out;
        }
        if (isUploadedSegmentEncrypted && !crypterClassNameInTableConfig.equals(crypterUsedInUploadedSegment)) {
            throw new ControllerApplicationException(LOGGER, String.format("Uploaded segment is encrypted with '%s' while table config requires '%s' as crypter (segment name = '%s', table name = '%s').", crypterUsedInUploadedSegment, crypterClassNameInTableConfig, segmentName, tableNameWithType), Response.Status.INTERNAL_SERVER_ERROR);
        }
        PinotCrypter pinotCrypter = PinotCrypterFactory.create((String)crypterClassNameInTableConfig);
        LOGGER.info("Using crypter class '{}' for encrypting '{}' to '{}' (segment name = '{}', table name = '{}').", new Object[]{crypterClassNameInTableConfig, tempDecryptedFile, tempEncryptedFile, segmentName, tableNameWithType});
        pinotCrypter.encrypt(tempDecryptedFile, tempEncryptedFile);
        return out;
    }

    private void downloadSegmentFileFromURI(String currentSegmentLocationURI, File destFile, String tableName) throws Exception {
        if (currentSegmentLocationURI == null || currentSegmentLocationURI.isEmpty()) {
            throw new ControllerApplicationException(LOGGER, "Failed to get downloadURI, needed for URI upload", Response.Status.BAD_REQUEST);
        }
        LOGGER.info("Downloading segment from {} to {} for table {}", new Object[]{currentSegmentLocationURI, destFile.getAbsolutePath(), tableName});
        URI uri = new URI(currentSegmentLocationURI);
        if (uri.getScheme().equalsIgnoreCase("file")) {
            throw new ControllerApplicationException(LOGGER, "Unsupported URI: " + currentSegmentLocationURI, Response.Status.BAD_REQUEST);
        }
        SegmentFetcherFactory.fetchSegmentToLocal((String)currentSegmentLocationURI, (File)destFile);
    }

    private SegmentMetadata getSegmentMetadata(File tempDecryptedFile, File tempSegmentDir, String metadataProviderClass) throws Exception {
        return MetadataExtractorFactory.create((String)metadataProviderClass).extractMetadata(tempDecryptedFile, tempSegmentDir);
    }

    private void decryptFile(String crypterClassName, File tempEncryptedFile, File tempDecryptedFile) {
        PinotCrypter pinotCrypter = PinotCrypterFactory.create((String)crypterClassName);
        LOGGER.info("Using crypter class {} for decrypting {} to {}", new Object[]{pinotCrypter.getClass().getName(), tempEncryptedFile, tempDecryptedFile});
        pinotCrypter.decrypt(tempEncryptedFile, tempDecryptedFile);
    }

    @POST
    @ManagedAsync
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/segments")
    @Authorize(targetType=TargetType.CLUSTER, action="UploadSegment")
    @Authenticate(value=AccessType.CREATE)
    @ApiOperation(value="Upload a segment", notes="Upload a segment as json")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully uploaded segment"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=403, message="Segment validation fails"), @ApiResponse(code=409, message="Segment already exists or another parallel push in progress"), @ApiResponse(code=410, message="Segment to refresh does not exist"), @ApiResponse(code=412, message="CRC check fails"), @ApiResponse(code=500, message="Internal error")})
    @TrackInflightRequestMetrics
    @TrackedByGauge(gauge=ControllerGauge.SEGMENT_UPLOADS_IN_PROGRESS)
    public void uploadSegmentAsJson(String segmentJsonStr, @ApiParam(value="Name of the table") @QueryParam(value="tableName") String tableName, @ApiParam(value="Type of the table") @QueryParam(value="tableType") @DefaultValue(value="OFFLINE") String tableType, @ApiParam(value="Whether to enable parallel push protection") @DefaultValue(value="false") @QueryParam(value="enableParallelPushProtection") boolean enableParallelPushProtection, @ApiParam(value="Whether to refresh if the segment already exists") @DefaultValue(value="true") @QueryParam(value="allowRefresh") boolean allowRefresh, @Context HttpHeaders headers, @Context Request request, @Suspended AsyncResponse asyncResponse) {
        try {
            asyncResponse.resume((Object)this.uploadSegment(tableName, TableType.valueOf((String)tableType.toUpperCase()), null, false, enableParallelPushProtection, allowRefresh, headers, request));
        }
        catch (Throwable t) {
            asyncResponse.resume(t);
        }
    }

    @POST
    @ManagedAsync
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/segments")
    @Authorize(targetType=TargetType.CLUSTER, action="UploadSegment")
    @Authenticate(value=AccessType.CREATE)
    @ApiOperation(value="Upload a segment", notes="Upload a segment as binary")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully uploaded segment"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=403, message="Segment validation fails"), @ApiResponse(code=409, message="Segment already exists or another parallel push in progress"), @ApiResponse(code=410, message="Segment to refresh does not exist"), @ApiResponse(code=412, message="CRC check fails"), @ApiResponse(code=500, message="Internal error")})
    @TrackInflightRequestMetrics
    @TrackedByGauge(gauge=ControllerGauge.SEGMENT_UPLOADS_IN_PROGRESS)
    public void uploadSegmentAsMultiPart(FormDataMultiPart multiPart, @ApiParam(value="Name of the table") @QueryParam(value="tableName") String tableName, @ApiParam(value="Type of the table") @QueryParam(value="tableType") @DefaultValue(value="OFFLINE") String tableType, @ApiParam(value="Whether to enable parallel push protection") @DefaultValue(value="false") @QueryParam(value="enableParallelPushProtection") boolean enableParallelPushProtection, @ApiParam(value="Whether to refresh if the segment already exists") @DefaultValue(value="true") @QueryParam(value="allowRefresh") boolean allowRefresh, @Context HttpHeaders headers, @Context Request request, @Suspended AsyncResponse asyncResponse) {
        try {
            asyncResponse.resume((Object)this.uploadSegment(tableName, TableType.valueOf((String)tableType.toUpperCase()), multiPart, true, enableParallelPushProtection, allowRefresh, headers, request));
        }
        catch (Throwable t) {
            asyncResponse.resume(t);
        }
    }

    @POST
    @ManagedAsync
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/v2/segments")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="UploadSegment")
    @Authenticate(value=AccessType.CREATE)
    @ApiOperation(value="Upload a segment", notes="Upload a segment as json")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully uploaded segment"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=403, message="Segment validation fails"), @ApiResponse(code=409, message="Segment already exists or another parallel push in progress"), @ApiResponse(code=410, message="Segment to refresh does not exist"), @ApiResponse(code=412, message="CRC check fails"), @ApiResponse(code=500, message="Internal error")})
    @TrackInflightRequestMetrics
    @TrackedByGauge(gauge=ControllerGauge.SEGMENT_UPLOADS_IN_PROGRESS)
    public void uploadSegmentAsJsonV2(String segmentJsonStr, @ApiParam(value="Name of the table") @QueryParam(value="tableName") String tableName, @ApiParam(value="Type of the table") @QueryParam(value="tableType") @DefaultValue(value="OFFLINE") String tableType, @ApiParam(value="Whether to enable parallel push protection") @DefaultValue(value="false") @QueryParam(value="enableParallelPushProtection") boolean enableParallelPushProtection, @ApiParam(value="Whether to refresh if the segment already exists") @DefaultValue(value="true") @QueryParam(value="allowRefresh") boolean allowRefresh, @Context HttpHeaders headers, @Context Request request, @Suspended AsyncResponse asyncResponse) {
        try {
            asyncResponse.resume((Object)this.uploadSegment(tableName, TableType.valueOf((String)tableType.toUpperCase()), null, true, enableParallelPushProtection, allowRefresh, headers, request));
        }
        catch (Throwable t) {
            asyncResponse.resume(t);
        }
    }

    @POST
    @ManagedAsync
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    @Path(value="/v2/segments")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="UploadSegment")
    @Authenticate(value=AccessType.CREATE)
    @ApiOperation(value="Upload a segment", notes="Upload a segment as binary")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully uploaded segment"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=403, message="Segment validation fails"), @ApiResponse(code=409, message="Segment already exists or another parallel push in progress"), @ApiResponse(code=410, message="Segment to refresh does not exist"), @ApiResponse(code=412, message="CRC check fails"), @ApiResponse(code=500, message="Internal error")})
    @TrackInflightRequestMetrics
    @TrackedByGauge(gauge=ControllerGauge.SEGMENT_UPLOADS_IN_PROGRESS)
    public void uploadSegmentAsMultiPartV2(FormDataMultiPart multiPart, @ApiParam(value="Name of the table") @QueryParam(value="tableName") String tableName, @ApiParam(value="Type of the table") @QueryParam(value="tableType") @DefaultValue(value="OFFLINE") String tableType, @ApiParam(value="Whether to enable parallel push protection") @DefaultValue(value="false") @QueryParam(value="enableParallelPushProtection") boolean enableParallelPushProtection, @ApiParam(value="Whether to refresh if the segment already exists") @DefaultValue(value="true") @QueryParam(value="allowRefresh") boolean allowRefresh, @Context HttpHeaders headers, @Context Request request, @Suspended AsyncResponse asyncResponse) {
        try {
            asyncResponse.resume((Object)this.uploadSegment(tableName, TableType.valueOf((String)tableType.toUpperCase()), multiPart, true, enableParallelPushProtection, allowRefresh, headers, request));
        }
        catch (Throwable t) {
            asyncResponse.resume(t);
        }
    }

    @POST
    @Path(value="segments/{tableName}/startReplaceSegments")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="ReplaceSegment")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Start to replace segments", notes="Start to replace segments")
    public Response startReplaceSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME", required=true) @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Force cleanup") @QueryParam(value="forceCleanup") @DefaultValue(value="false") boolean forceCleanup, @ApiParam(value="Fields belonging to start replace segment request", required=true) StartReplaceSegmentsRequest startReplaceSegmentsRequest) {
        TableType tableType = Constants.validateTableType(tableTypeStr);
        if (tableType == null) {
            throw new ControllerApplicationException(LOGGER, "Table type should either be offline or realtime", Response.Status.BAD_REQUEST);
        }
        String tableNameWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER).get(0);
        try {
            String segmentLineageEntryId = this._pinotHelixResourceManager.startReplaceSegments(tableNameWithType, startReplaceSegmentsRequest.getSegmentsFrom(), startReplaceSegmentsRequest.getSegmentsTo(), forceCleanup, startReplaceSegmentsRequest.getCustomMap());
            return Response.ok((Object)JsonUtils.newObjectNode().put("segmentLineageEntryId", segmentLineageEntryId)).build();
        }
        catch (Exception e) {
            this._controllerMetrics.addMeteredTableValue(tableNameWithType, (AbstractMetrics.Meter)ControllerMeter.NUMBER_START_REPLACE_FAILURE, 1L);
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @POST
    @Path(value="segments/{tableName}/endReplaceSegments")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="ReplaceSegment")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="End to replace segments", notes="End to replace segments")
    public Response endReplaceSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME", required=true) @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Segment lineage entry id returned by startReplaceSegments API", required=true) @QueryParam(value="segmentLineageEntryId") String segmentLineageEntryId, @ApiParam(value="Fields belonging to end replace segment request", required=false) EndReplaceSegmentsRequest endReplaceSegmentsRequest) {
        TableType tableType = Constants.validateTableType(tableTypeStr);
        if (tableType == null) {
            throw new ControllerApplicationException(LOGGER, "Table type should either be offline or realtime", Response.Status.BAD_REQUEST);
        }
        String tableNameWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER).get(0);
        try {
            Preconditions.checkNotNull((Object)segmentLineageEntryId, (Object)"'segmentLineageEntryId' should not be null");
            this._pinotHelixResourceManager.endReplaceSegments(tableNameWithType, segmentLineageEntryId, endReplaceSegmentsRequest);
            return Response.ok().build();
        }
        catch (Exception e) {
            this._controllerMetrics.addMeteredTableValue(tableNameWithType, (AbstractMetrics.Meter)ControllerMeter.NUMBER_END_REPLACE_FAILURE, 1L);
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @POST
    @Path(value="segments/{tableName}/revertReplaceSegments")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="ReplaceSegment")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Revert segments replacement", notes="Revert segments replacement")
    public Response revertReplaceSegments(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME", required=true) @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Segment lineage entry id to revert", required=true) @QueryParam(value="segmentLineageEntryId") String segmentLineageEntryId, @ApiParam(value="Force revert in case the user knows that the lineage entry is interrupted") @QueryParam(value="forceRevert") @DefaultValue(value="false") boolean forceRevert, @ApiParam(value="Fields belonging to revert replace segment request", required=false) RevertReplaceSegmentsRequest revertReplaceSegmentsRequest) {
        TableType tableType = Constants.validateTableType(tableTypeStr);
        if (tableType == null) {
            throw new ControllerApplicationException(LOGGER, "Table type should either be offline or realtime", Response.Status.BAD_REQUEST);
        }
        String tableNameWithType = ResourceUtils.getExistingTableNamesWithType(this._pinotHelixResourceManager, tableName, tableType, LOGGER).get(0);
        try {
            Preconditions.checkNotNull((Object)segmentLineageEntryId, (Object)"'segmentLineageEntryId' should not be null");
            this._pinotHelixResourceManager.revertReplaceSegments(tableNameWithType, segmentLineageEntryId, forceRevert, revertReplaceSegmentsRequest);
            return Response.ok().build();
        }
        catch (Exception e) {
            this._controllerMetrics.addMeteredTableValue(tableNameWithType, (AbstractMetrics.Meter)ControllerMeter.NUMBER_REVERT_REPLACE_FAILURE, 1L);
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createSegmentFileFromMultipart(FormDataMultiPart multiPart, File destFile) throws IOException {
        Map segmentMetadataMap = multiPart.getFields();
        if (!PinotSegmentUploadDownloadRestletResource.validateMultiPart(segmentMetadataMap, null)) {
            throw new ControllerApplicationException(LOGGER, "Invalid multi-part form for segment metadata", Response.Status.BAD_REQUEST);
        }
        FormDataBodyPart segmentMetadataBodyPart = (FormDataBodyPart)((List)segmentMetadataMap.values().iterator().next()).get(0);
        try (InputStream inputStream = (InputStream)segmentMetadataBodyPart.getValueAs(InputStream.class);
             FileOutputStream outputStream = new FileOutputStream(destFile);){
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            multiPart.cleanup();
        }
    }

    private FileUploadDownloadClient.FileUploadType getUploadType(String uploadTypeStr) {
        if (uploadTypeStr != null) {
            return FileUploadDownloadClient.FileUploadType.valueOf((String)uploadTypeStr);
        }
        return FileUploadDownloadClient.FileUploadType.getDefaultUploadType();
    }

    public static boolean validateMultiPart(Map<String, List<FormDataBodyPart>> map, String segmentName) {
        List<FormDataBodyPart> bodyParts;
        boolean isGood = true;
        if (map.size() != 1) {
            LOGGER.warn("Incorrect number of multi-part elements: {} (segmentName {}). Picking one", (Object)map.size(), (Object)segmentName);
            isGood = false;
        }
        if ((bodyParts = map.values().iterator().next()).size() != 1) {
            LOGGER.warn("Incorrect number of elements in list in first part: {} (segmentName {}). Picking first one", (Object)bodyParts.size(), (Object)segmentName);
            isGood = false;
        }
        return isGood;
    }
}

