/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.services;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.resources.InstanceInfo;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.core.auth.Authorize;
import org.apache.pinot.core.auth.TargetType;

@Api(tags={"Broker"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public interface PinotBrokerService {
    @GET
    @Produces(value={"application/json"})
    @Path(value="/brokers")
    @Authorize(targetType=TargetType.CLUSTER, action="GetBroker")
    @ApiOperation(value="List tenants and tables to brokers mappings", notes="List tenants and tables to brokers mappings")
    public Map<String, Map<String, List<String>>> listBrokersMapping(@ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String var1);

    @GET
    @Produces(value={"application/json"})
    @Path(value="/brokers/tenants")
    @Authorize(targetType=TargetType.CLUSTER, action="GetBroker")
    @ApiOperation(value="List tenants to brokers mappings", notes="List tenants to brokers mappings")
    public Map<String, List<String>> getTenantsToBrokersMapping(@ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String var1);

    @GET
    @Produces(value={"application/json"})
    @Path(value="/brokers/tenants/{tenantName}")
    @Authorize(targetType=TargetType.CLUSTER, action="GetBroker")
    @ApiOperation(value="List brokers for a given tenant", notes="List brokers for a given tenant")
    public List<String> getBrokersForTenant(@ApiParam(value="Name of the tenant", required=true) @PathParam(value="tenantName") String var1, @ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String var2);

    @GET
    @Produces(value={"application/json"})
    @Path(value="/brokers/tables")
    @Authorize(targetType=TargetType.CLUSTER, action="GetBroker")
    @ApiOperation(value="List tables to brokers mappings", notes="List tables to brokers mappings")
    public Map<String, List<String>> getTablesToBrokersMapping(@ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String var1);

    @GET
    @Produces(value={"application/json"})
    @Path(value="/brokers/tables/{tableName}")
    @Authorize(targetType=TargetType.TABLE, paramName="tableName", action="GetBroker")
    @ApiOperation(value="List brokers for a given table", notes="List brokers for a given table")
    public List<String> getBrokersForTable(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String var1, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String var2, @ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String var3);

    @GET
    @Produces(value={"application/json"})
    @Path(value="/v2/brokers")
    @Authorize(targetType=TargetType.CLUSTER, action="GetBroker")
    @ApiOperation(value="List tenants and tables to brokers mappings", notes="List tenants and tables to brokers mappings")
    public Map<String, Map<String, List<InstanceInfo>>> listBrokersMappingV2(@ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String var1);

    @GET
    @Produces(value={"application/json"})
    @Path(value="/v2/brokers/tenants")
    @Authorize(targetType=TargetType.CLUSTER, action="GetBroker")
    @ApiOperation(value="List tenants to brokers mappings", notes="List tenants to brokers mappings")
    public Map<String, List<InstanceInfo>> getTenantsToBrokersMappingV2(@ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String var1);

    @GET
    @Produces(value={"application/json"})
    @Path(value="/v2/brokers/tenants/{tenantName}")
    @Authorize(targetType=TargetType.CLUSTER, action="GetBroker")
    @ApiOperation(value="List brokers for a given tenant", notes="List brokers for a given tenant")
    public List<InstanceInfo> getBrokersForTenantV2(@ApiParam(value="Name of the tenant", required=true) @PathParam(value="tenantName") String var1, @ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String var2);

    @GET
    @Produces(value={"application/json"})
    @Path(value="/v2/brokers/tables")
    @Authorize(targetType=TargetType.CLUSTER, action="GetBroker")
    @ApiOperation(value="List tables to brokers mappings", notes="List tables to brokers mappings")
    public Map<String, List<InstanceInfo>> getTablesToBrokersMappingV2(@ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String var1);

    @GET
    @Produces(value={"application/json"})
    @Path(value="/v2/brokers/tables/{tableName}")
    @Authorize(targetType=TargetType.CLUSTER, paramName="tableName", action="GetBroker")
    @ApiOperation(value="List brokers for a given table", notes="List brokers for a given table")
    public List<InstanceInfo> getBrokersForTableV2(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String var1, @ApiParam(value="OFFLINE|REALTIME") @QueryParam(value="type") String var2, @ApiParam(value="ONLINE|OFFLINE") @QueryParam(value="state") String var3);

    @POST
    @Path(value="/brokers/instances/{instanceName}/qps")
    @Authorize(targetType=TargetType.CLUSTER, action="UpdateQPS")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Enable/disable the query rate limiting for a broker instance", notes="Enable/disable the query rate limiting for a broker instance")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=404, message="Instance not found"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse toggleQueryRateLimiting(@ApiParam(value="Broker instance name", required=true, example="Broker_my.broker.com_30000") @PathParam(value="instanceName") String var1, @ApiParam(value="ENABLE|DISABLE", allowableValues="ENABLE, DISABLE", required=true) @QueryParam(value="state") String var2);
}

