/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.instance;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.assignment.InstanceAssignmentConfigUtils;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.common.assignment.InstancePartitionsUtils;
import org.apache.pinot.controller.helix.core.assignment.instance.HashBasedRotateInstanceConstraintApplier;
import org.apache.pinot.controller.helix.core.assignment.instance.InstanceConstraintApplier;
import org.apache.pinot.controller.helix.core.assignment.instance.InstancePartitionSelector;
import org.apache.pinot.controller.helix.core.assignment.instance.InstancePartitionSelectorFactory;
import org.apache.pinot.controller.helix.core.assignment.instance.InstanceTagPoolSelector;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.assignment.InstanceAssignmentConfig;
import org.apache.pinot.spi.config.table.assignment.InstanceConstraintConfig;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceAssignmentDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceAssignmentDriver.class);
    private final TableConfig _tableConfig;

    public InstanceAssignmentDriver(TableConfig tableConfig) {
        this._tableConfig = tableConfig;
    }

    public InstancePartitions assignInstances(InstancePartitionsType instancePartitionsType, List<InstanceConfig> instanceConfigs, @Nullable InstancePartitions existingInstancePartitions) {
        String tableNameWithType = this._tableConfig.getTableName();
        InstanceAssignmentConfig assignmentConfig = InstanceAssignmentConfigUtils.getInstanceAssignmentConfig((TableConfig)this._tableConfig, (InstancePartitionsType)instancePartitionsType);
        return this.getInstancePartitions(instancePartitionsType.getInstancePartitionsName(TableNameBuilder.extractRawTableName((String)tableNameWithType)), assignmentConfig, instanceConfigs, existingInstancePartitions);
    }

    public InstancePartitions assignInstances(String tierName, List<InstanceConfig> instanceConfigs, @Nullable InstancePartitions existingInstancePartitions, InstanceAssignmentConfig instanceAssignmentConfig) {
        return this.getInstancePartitions(InstancePartitionsUtils.getInstancePartitionsNameForTier((String)this._tableConfig.getTableName(), (String)tierName), instanceAssignmentConfig, instanceConfigs, existingInstancePartitions);
    }

    private InstancePartitions getInstancePartitions(String instancePartitionsName, InstanceAssignmentConfig instanceAssignmentConfig, List<InstanceConfig> instanceConfigs, @Nullable InstancePartitions existingInstancePartitions) {
        String tableNameWithType = this._tableConfig.getTableName();
        LOGGER.info("Starting {} instance assignment for table {}", (Object)instancePartitionsName, (Object)tableNameWithType);
        InstanceTagPoolSelector tagPoolSelector = new InstanceTagPoolSelector(instanceAssignmentConfig.getTagPoolConfig(), tableNameWithType);
        Map<Integer, List<InstanceConfig>> poolToInstanceConfigsMap = tagPoolSelector.selectInstances(instanceConfigs);
        InstanceConstraintConfig constraintConfig = instanceAssignmentConfig.getConstraintConfig();
        ArrayList<HashBasedRotateInstanceConstraintApplier> constraintAppliers = new ArrayList<HashBasedRotateInstanceConstraintApplier>();
        if (constraintConfig == null) {
            LOGGER.info("No instance constraint is configured, using default hash-based-rotate instance constraint");
            constraintAppliers.add(new HashBasedRotateInstanceConstraintApplier(tableNameWithType));
        }
        for (InstanceConstraintApplier instanceConstraintApplier : constraintAppliers) {
            poolToInstanceConfigsMap = instanceConstraintApplier.applyConstraint(poolToInstanceConfigsMap);
        }
        InstancePartitionSelector instancePartitionSelector = InstancePartitionSelectorFactory.getInstance(instanceAssignmentConfig.getPartitionSelector(), instanceAssignmentConfig.getReplicaGroupPartitionConfig(), tableNameWithType, existingInstancePartitions);
        InstancePartitions instancePartitions = new InstancePartitions(instancePartitionsName);
        instancePartitionSelector.selectInstances(poolToInstanceConfigsMap, instancePartitions);
        return instancePartitions;
    }
}

