/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.segment;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.common.tier.Tier;
import org.apache.pinot.controller.helix.core.assignment.segment.BaseSegmentAssignment;
import org.apache.pinot.controller.helix.core.assignment.segment.SegmentAssignmentUtils;
import org.apache.pinot.controller.helix.core.assignment.segment.strategy.SegmentAssignmentStrategy;
import org.apache.pinot.controller.helix.core.assignment.segment.strategy.SegmentAssignmentStrategyFactory;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;

public class RealtimeSegmentAssignment
extends BaseSegmentAssignment {
    @Override
    public List<String> assignSegment(String segmentName, Map<String, Map<String, String>> currentAssignment, Map<InstancePartitionsType, InstancePartitions> instancePartitionsMap) {
        List<String> instancesAssigned;
        Preconditions.checkState((instancePartitionsMap.size() == 1 ? 1 : 0) != 0, (Object)"One instance partition type should be provided");
        Map.Entry<InstancePartitionsType, InstancePartitions> typeToInstancePartitions = instancePartitionsMap.entrySet().iterator().next();
        InstancePartitionsType instancePartitionsType = typeToInstancePartitions.getKey();
        InstancePartitions instancePartitions = typeToInstancePartitions.getValue();
        this._logger.info("Assigning segment: {} with instance partitions: {} for table: {}", new Object[]{segmentName, instancePartitions, this._tableNameWithType});
        if (instancePartitionsType == InstancePartitionsType.COMPLETED) {
            SegmentAssignmentStrategy segmentAssignmentStrategy = SegmentAssignmentStrategyFactory.getSegmentAssignmentStrategy(this._helixManager, this._tableConfig, instancePartitionsType.toString(), instancePartitions);
            instancesAssigned = segmentAssignmentStrategy.assignSegment(segmentName, currentAssignment, instancePartitions, InstancePartitionsType.COMPLETED);
        } else {
            instancesAssigned = this.assignConsumingSegment(segmentName, instancePartitions);
        }
        this._logger.info("Assigned segment: {} to instances: {} for table: {}", new Object[]{segmentName, instancesAssigned, this._tableNameWithType});
        return instancesAssigned;
    }

    private List<String> assignConsumingSegment(String segmentName, InstancePartitions instancePartitions) {
        int segmentPartitionId = SegmentAssignmentUtils.getRealtimeSegmentPartitionId(segmentName, this._tableNameWithType, this._helixManager, this._partitionColumn);
        int numReplicaGroups = instancePartitions.getNumReplicaGroups();
        int numPartitions = instancePartitions.getNumPartitions();
        if (numReplicaGroups == 1 && numPartitions == 1) {
            List<String> instances = SegmentAssignmentUtils.getInstancesForNonReplicaGroupBasedAssignment(instancePartitions, this._replication);
            int numInstances = instances.size();
            ArrayList<String> instancesAssigned = new ArrayList<String>(this._replication);
            for (int replicaId = 0; replicaId < this._replication; ++replicaId) {
                int instanceIndex = (segmentPartitionId * this._replication + replicaId) % numInstances;
                instancesAssigned.add(instances.get(instanceIndex));
            }
            return instancesAssigned;
        }
        if (numReplicaGroups != this._replication) {
            this._logger.warn("Number of replica-groups in instance partitions {}: {} does not match replication in table config: {} for table: {}, using: {}", new Object[]{instancePartitions.getInstancePartitionsName(), numReplicaGroups, this._replication, this._tableNameWithType, numReplicaGroups});
        }
        ArrayList<String> instancesAssigned = new ArrayList<String>(numReplicaGroups);
        if (numPartitions == 1) {
            for (int replicaGroupId = 0; replicaGroupId < numReplicaGroups; ++replicaGroupId) {
                List instances = instancePartitions.getInstances(0, replicaGroupId);
                instancesAssigned.add((String)instances.get(segmentPartitionId % instances.size()));
            }
        } else {
            for (int replicaGroupId = 0; replicaGroupId < numReplicaGroups; ++replicaGroupId) {
                int partitionId = segmentPartitionId % numPartitions;
                instancesAssigned.add((String)instancePartitions.getInstances(partitionId, replicaGroupId).get(0));
            }
        }
        return instancesAssigned;
    }

    @Override
    public Map<String, Map<String, String>> rebalanceTable(Map<String, Map<String, String>> currentAssignment, Map<InstancePartitionsType, InstancePartitions> instancePartitionsMap, @Nullable List<Tier> sortedTiers, @Nullable Map<String, InstancePartitions> tierInstancePartitionsMap, Configuration config) {
        Map<Object, Object> newAssignment;
        InstancePartitions completedInstancePartitions = instancePartitionsMap.get(InstancePartitionsType.COMPLETED);
        InstancePartitions consumingInstancePartitions = instancePartitionsMap.get(InstancePartitionsType.CONSUMING);
        Preconditions.checkState((consumingInstancePartitions != null ? 1 : 0) != 0, (String)"Failed to find CONSUMING instance partitions for table: %s", (Object)this._tableNameWithType);
        boolean includeConsuming = config.getBoolean("includeConsuming", false);
        boolean bootstrap = config.getBoolean("bootstrap", false);
        Pair<List<Map<String, Map<String, String>>>, Map<String, Map<String, String>>> pair = this.rebalanceTiers(currentAssignment, sortedTiers, tierInstancePartitionsMap, bootstrap, InstancePartitionsType.COMPLETED);
        List newTierAssignments = (List)pair.getLeft();
        Map nonTierAssignment = (Map)pair.getRight();
        this._logger.info("Rebalancing table: {} with COMPLETED instance partitions: {}, CONSUMING instance partitions: {}, includeConsuming: {}, bootstrap: {}", new Object[]{this._tableNameWithType, completedInstancePartitions, consumingInstancePartitions, includeConsuming, bootstrap});
        SegmentAssignmentUtils.CompletedConsumingOfflineSegmentAssignment completedConsumingOfflineSegmentAssignment = new SegmentAssignmentUtils.CompletedConsumingOfflineSegmentAssignment(nonTierAssignment);
        Map<String, Map<String, String>> completedSegmentAssignment = completedConsumingOfflineSegmentAssignment.getCompletedSegmentAssignment();
        if (completedInstancePartitions != null) {
            SegmentAssignmentStrategy segmentAssignmentStrategy = SegmentAssignmentStrategyFactory.getSegmentAssignmentStrategy(this._helixManager, this._tableConfig, InstancePartitionsType.COMPLETED.toString(), completedInstancePartitions);
            this._logger.info("Reassigning COMPLETED segments with COMPLETED instance partitions for table: {}", (Object)this._tableNameWithType);
            newAssignment = this.reassignSegments(InstancePartitionsType.COMPLETED.toString(), completedSegmentAssignment, completedInstancePartitions, bootstrap, segmentAssignmentStrategy, InstancePartitionsType.COMPLETED);
        } else {
            this._logger.info("No COMPLETED instance partitions found, reassigning COMPLETED segments the same way as CONSUMING segments with CONSUMING instance partitions for table: {}", (Object)this._tableNameWithType);
            newAssignment = new TreeMap<String, Map<String, String>>();
            for (String segmentName : completedSegmentAssignment.keySet()) {
                List<String> instancesAssigned = this.assignConsumingSegment(segmentName, consumingInstancePartitions);
                Map<String, String> instanceStateMap = SegmentAssignmentUtils.getInstanceStateMap(instancesAssigned, "ONLINE");
                newAssignment.put(segmentName, instanceStateMap);
            }
        }
        Map<String, Map<String, String>> consumingSegmentAssignment = completedConsumingOfflineSegmentAssignment.getConsumingSegmentAssignment();
        if (includeConsuming) {
            this._logger.info("Reassigning CONSUMING segments with CONSUMING instance partitions for table: {}", (Object)this._tableNameWithType);
            for (String segmentName : consumingSegmentAssignment.keySet()) {
                List<String> instancesAssigned = this.assignConsumingSegment(segmentName, consumingInstancePartitions);
                Map<String, String> instanceStateMap = SegmentAssignmentUtils.getInstanceStateMap(instancesAssigned, "CONSUMING");
                newAssignment.put(segmentName, instanceStateMap);
            }
        } else {
            newAssignment.putAll(consumingSegmentAssignment);
        }
        newAssignment.putAll(completedConsumingOfflineSegmentAssignment.getOfflineSegmentAssignment());
        if (CollectionUtils.isNotEmpty((Collection)newTierAssignments)) {
            newTierAssignments.forEach(newAssignment::putAll);
        }
        this._logger.info("Rebalanced table: {}, number of segments to be moved to each instance: {}", (Object)this._tableNameWithType, SegmentAssignmentUtils.getNumSegmentsToBeMovedPerInstance(currentAssignment, newAssignment));
        return newAssignment;
    }
}

