/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.lineage;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.lineage.LineageEntry;
import org.apache.pinot.common.lineage.LineageEntryState;
import org.apache.pinot.common.lineage.SegmentLineage;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.helix.core.lineage.LineageManager;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.utils.IngestionConfigUtils;

public class DefaultLineageManager
implements LineageManager {
    private static final long REPLACED_SEGMENTS_RETENTION_IN_MILLIS = TimeUnit.DAYS.toMillis(1L);
    private static final long LINEAGE_ENTRY_CLEANUP_RETENTION_IN_MILLIS = TimeUnit.DAYS.toMillis(1L);
    protected ControllerConf _controllerConf;

    public DefaultLineageManager(ControllerConf controllerConf) {
        this._controllerConf = controllerConf;
    }

    @Override
    public void updateLineageForStartReplaceSegments(TableConfig tableConfig, String lineageEntryId, Map<String, String> customMap, SegmentLineage lineage) {
    }

    @Override
    public void updateLineageForEndReplaceSegments(TableConfig tableConfig, String lineageEntryId, Map<String, String> customMap, SegmentLineage lineage) {
    }

    @Override
    public void updateLineageForRevertReplaceSegments(TableConfig tableConfig, String lineageEntryId, Map<String, String> customMap, SegmentLineage lineage) {
    }

    @Override
    public void updateLineageForRetention(TableConfig tableConfig, SegmentLineage lineage, List<String> allSegments, List<String> segmentsToDelete, Set<String> consumingSegments) {
        HashSet<String> segmentsForTable = new HashSet<String>(allSegments);
        Iterator lineageEntryIterator = lineage.getLineageEntries().values().iterator();
        while (lineageEntryIterator.hasNext()) {
            LineageEntry lineageEntry = (LineageEntry)lineageEntryIterator.next();
            if (lineageEntry.getState() == LineageEntryState.COMPLETED) {
                HashSet sourceSegments = new HashSet(lineageEntry.getSegmentsFrom());
                sourceSegments.retainAll(segmentsForTable);
                if (sourceSegments.isEmpty()) {
                    lineageEntryIterator.remove();
                    continue;
                }
                if (!this.shouldDeleteReplacedSegments(tableConfig, lineageEntry)) continue;
                segmentsToDelete.addAll(sourceSegments);
                continue;
            }
            if (lineageEntry.getState() != LineageEntryState.REVERTED && (lineageEntry.getState() != LineageEntryState.IN_PROGRESS || lineageEntry.getTimestamp() >= System.currentTimeMillis() - LINEAGE_ENTRY_CLEANUP_RETENTION_IN_MILLIS)) continue;
            HashSet destinationSegments = new HashSet(lineageEntry.getSegmentsTo());
            destinationSegments.retainAll(segmentsForTable);
            if (destinationSegments.isEmpty()) {
                lineageEntryIterator.remove();
                continue;
            }
            segmentsToDelete.addAll(destinationSegments);
        }
    }

    private boolean shouldDeleteReplacedSegments(TableConfig tableConfig, LineageEntry lineageEntry) {
        String batchSegmentIngestionType = IngestionConfigUtils.getBatchSegmentIngestionType((TableConfig)tableConfig);
        return !batchSegmentIngestionType.equalsIgnoreCase("REFRESH") || lineageEntry.getTimestamp() < System.currentTimeMillis() - REPLACED_SEGMENTS_RETENTION_IN_MILLIS;
    }
}

