/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion.generator;

import java.util.List;
import java.util.Map;
import org.apache.pinot.controller.api.exception.UnknownTaskTypeException;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoAccessor;
import org.apache.pinot.controller.helix.core.minion.generator.PinotTaskGenerator;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTaskGenerator
implements PinotTaskGenerator {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseTaskGenerator.class);
    protected ClusterInfoAccessor _clusterInfoAccessor;

    @Override
    public void init(ClusterInfoAccessor clusterInfoAccessor) {
        this._clusterInfoAccessor = clusterInfoAccessor;
    }

    @Override
    public long getTaskTimeoutMs() {
        String taskType = this.getTaskType();
        String configKey = taskType + ".timeoutMs";
        String configValue = this._clusterInfoAccessor.getClusterConfig(configKey);
        if (configValue != null) {
            try {
                return Long.parseLong(configValue);
            }
            catch (Exception e) {
                LOGGER.error("Invalid cluster config {}: '{}'", new Object[]{configKey, configValue, e});
            }
        }
        return 3600000L;
    }

    @Override
    public int getNumConcurrentTasksPerInstance() {
        String taskType = this.getTaskType();
        String configKey = taskType + ".numConcurrentTasksPerInstance";
        String configValue = this._clusterInfoAccessor.getClusterConfig(configKey);
        if (configValue != null) {
            try {
                return Integer.parseInt(configValue);
            }
            catch (Exception e) {
                LOGGER.error("Invalid config {}: '{}'", new Object[]{configKey, configValue, e});
            }
        }
        return 1;
    }

    @Override
    public int getMaxAttemptsPerTask() {
        String taskType = this.getTaskType();
        String configKey = taskType + ".maxAttemptsPerTask";
        String configValue = this._clusterInfoAccessor.getClusterConfig(configKey);
        if (configValue != null) {
            try {
                return Integer.parseInt(configValue);
            }
            catch (Exception e) {
                LOGGER.error("Invalid config {}: '{}'", new Object[]{configKey, configValue, e});
            }
        }
        return 1;
    }

    @Override
    public List<PinotTaskConfig> generateTasks(TableConfig tableConfig, Map<String, String> taskConfigs) throws Exception {
        throw new UnknownTaskTypeException("Adhoc task generation is not supported for task type - " + this.getTaskType());
    }
}

