/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.realtime.segment;

import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.controller.helix.core.realtime.segment.CommittingSegmentDescriptor;
import org.apache.pinot.controller.helix.core.realtime.segment.SegmentSizeBasedFlushThresholdUpdater;
import org.apache.pinot.spi.stream.PartitionGroupMetadata;
import org.apache.pinot.spi.stream.PartitionLevelStreamConfig;
import org.apache.pinot.spi.utils.TimeUtils;

class SegmentFlushThresholdComputer {
    public static final int MINIMUM_NUM_ROWS_THRESHOLD = 10000;
    static final double CURRENT_SEGMENT_RATIO_WEIGHT = 0.1;
    static final double PREVIOUS_SEGMENT_RATIO_WEIGHT = 0.9;
    static final double ROWS_MULTIPLIER_WHEN_TIME_THRESHOLD_HIT = 1.1;
    private double _latestSegmentRowsToSizeRatio;
    private final Clock _clock;

    SegmentFlushThresholdComputer() {
        this(Clock.systemUTC(), 0.0);
    }

    @VisibleForTesting
    SegmentFlushThresholdComputer(Clock clock, double latestSegmentRowsToSizeRatio) {
        this._clock = clock;
        this._latestSegmentRowsToSizeRatio = latestSegmentRowsToSizeRatio;
    }

    @VisibleForTesting
    SegmentFlushThresholdComputer(Clock clock) {
        this(clock, 0.0);
    }

    double getLatestSegmentRowsToSizeRatio() {
        return this._latestSegmentRowsToSizeRatio;
    }

    public int computeThreshold(PartitionLevelStreamConfig streamConfig, CommittingSegmentDescriptor committingSegmentDescriptor, @Nullable SegmentZKMetadata committingSegmentZKMetadata, List<PartitionGroupMetadata> partitionGroupMetadataList, String newSegmentName) {
        long desiredSegmentSizeBytes = streamConfig.getFlushThresholdSegmentSizeBytes();
        long optimalSegmentSizeBytesMin = desiredSegmentSizeBytes / 2L;
        double optimalSegmentSizeBytesMax = (double)desiredSegmentSizeBytes * 1.5;
        if (committingSegmentZKMetadata == null) {
            if (this._latestSegmentRowsToSizeRatio > 0.0) {
                long targetSegmentNumRows = (long)((double)desiredSegmentSizeBytes * this._latestSegmentRowsToSizeRatio);
                targetSegmentNumRows = this.capNumRowsIfOverflow(targetSegmentNumRows);
                SegmentSizeBasedFlushThresholdUpdater.LOGGER.info("Committing segment zk metadata is not available, using prev ratio {}, setting rows threshold for {} as {}", new Object[]{this._latestSegmentRowsToSizeRatio, newSegmentName, targetSegmentNumRows});
                return (int)targetSegmentNumRows;
            }
            int autotuneInitialRows = streamConfig.getFlushAutotuneInitialRows();
            SegmentSizeBasedFlushThresholdUpdater.LOGGER.info("Committing segment zk metadata is not available, setting threshold for {} as {}", (Object)newSegmentName, (Object)autotuneInitialRows);
            return autotuneInitialRows;
        }
        long committingSegmentSizeBytes = committingSegmentDescriptor.getSegmentSizeBytes();
        if (committingSegmentSizeBytes <= 0L) {
            int targetNumRows = committingSegmentZKMetadata.getSizeThresholdToFlushSegment();
            SegmentSizeBasedFlushThresholdUpdater.LOGGER.info("Committing segment size is not available, setting thresholds from previous segment for {} as {}", (Object)newSegmentName, (Object)targetNumRows);
            return targetNumRows;
        }
        long timeConsumed = this._clock.millis() - committingSegmentZKMetadata.getCreationTime();
        long numRowsConsumed = committingSegmentZKMetadata.getTotalDocs();
        int numRowsThreshold = committingSegmentZKMetadata.getSizeThresholdToFlushSegment();
        SegmentSizeBasedFlushThresholdUpdater.LOGGER.info("{}: Data from committing segment: Time {}  numRows {} threshold {} segmentSize(bytes) {}", new Object[]{newSegmentName, TimeUtils.convertMillisToPeriod((Long)timeConsumed), numRowsConsumed, numRowsThreshold, committingSegmentSizeBytes});
        double currentRatio = (double)numRowsConsumed / (double)committingSegmentSizeBytes;
        int smallestAvailablePartitionGroupId = partitionGroupMetadataList.stream().mapToInt(PartitionGroupMetadata::getPartitionGroupId).min().orElse(0);
        if (new LLCSegmentName(newSegmentName).getPartitionGroupId() == smallestAvailablePartitionGroupId || this._latestSegmentRowsToSizeRatio == 0.0) {
            this._latestSegmentRowsToSizeRatio = this._latestSegmentRowsToSizeRatio > 0.0 ? 0.1 * currentRatio + 0.9 * this._latestSegmentRowsToSizeRatio : currentRatio;
        }
        if (numRowsConsumed < (long)numRowsThreshold && committingSegmentSizeBytes < desiredSegmentSizeBytes) {
            long timeThresholdMillis = streamConfig.getFlushThresholdTimeMillis();
            long currentNumRows = numRowsConsumed;
            StringBuilder logStringBuilder = new StringBuilder().append("Time threshold reached. ");
            if (timeThresholdMillis < timeConsumed) {
                currentNumRows = timeThresholdMillis * numRowsConsumed / timeConsumed;
                logStringBuilder.append(" Detected lower time threshold, adjusting numRowsConsumed to ").append(currentNumRows).append(". ");
            }
            long targetSegmentNumRows = (long)((double)currentNumRows * 1.1);
            targetSegmentNumRows = this.capNumRowsIfOverflow(targetSegmentNumRows);
            logStringBuilder.append("Setting segment size for {} as {}");
            SegmentSizeBasedFlushThresholdUpdater.LOGGER.info(logStringBuilder.toString(), (Object)newSegmentName, (Object)targetSegmentNumRows);
            return (int)targetSegmentNumRows;
        }
        long targetSegmentNumRows = committingSegmentSizeBytes < optimalSegmentSizeBytesMin ? numRowsConsumed + numRowsConsumed / 2L : ((double)committingSegmentSizeBytes > optimalSegmentSizeBytesMax ? numRowsConsumed / 2L : (this._latestSegmentRowsToSizeRatio > 0.0 ? (long)((double)desiredSegmentSizeBytes * this._latestSegmentRowsToSizeRatio) : (long)((double)desiredSegmentSizeBytes * currentRatio)));
        targetSegmentNumRows = this.capNumRowsIfOverflow(targetSegmentNumRows);
        SegmentSizeBasedFlushThresholdUpdater.LOGGER.info("Committing segment size {}, current ratio {}, setting threshold for {} as {}", new Object[]{committingSegmentSizeBytes, this._latestSegmentRowsToSizeRatio, newSegmentName, targetSegmentNumRows});
        return (int)targetSegmentNumRows;
    }

    private long capNumRowsIfOverflow(long targetSegmentNumRows) {
        if (targetSegmentNumRows > Integer.MAX_VALUE) {
            targetSegmentNumRows = Integer.MAX_VALUE;
        }
        return Math.max(targetSegmentNumRows, 10000L);
    }
}

