/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.utils.TarGzCompressionUtils;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.segment.local.utils.IngestionUtils;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.spi.auth.AuthProvider;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.BatchIngestionConfig;
import org.apache.pinot.spi.config.table.ingestion.IngestionConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.ingestion.segment.uploader.SegmentUploader;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.apache.pinot.spi.utils.builder.TableConfigBuilder;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIngestionHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileIngestionHelper.class);
    private static final String SEGMENT_UPLOADER_CLASS = "org.apache.pinot.plugin.segmentuploader.SegmentUploaderDefault";
    private static final String WORKING_DIR_PREFIX = "working_dir";
    private static final String INPUT_DATA_DIR = "input_data_dir";
    private static final String OUTPUT_SEGMENT_DIR = "output_segment_dir";
    private static final String SEGMENT_TAR_DIR = "segment_tar_dir";
    private static final String DATA_FILE_PREFIX = "data";
    private final TableConfig _tableConfig;
    private final Schema _schema;
    private final Map<String, String> _batchConfigMap;
    private final URI _controllerUri;
    private final File _ingestionDir;
    private final AuthProvider _authProvider;

    public FileIngestionHelper(TableConfig tableConfig, Schema schema, Map<String, String> batchConfigMap, URI controllerUri, File ingestionDir, AuthProvider authProvider) {
        this._tableConfig = tableConfig;
        this._schema = schema;
        this._batchConfigMap = batchConfigMap;
        this._controllerUri = controllerUri;
        this._ingestionDir = ingestionDir;
        this._authProvider = authProvider;
    }

    public SuccessResponse buildSegmentAndPush(DataPayload payload) throws Exception {
        String tableNameWithType = this._tableConfig.getTableName();
        File workingDir = org.apache.pinot.common.utils.FileUtils.concatAndValidateFile((File)this._ingestionDir, (String)String.format("%s_%s_%d_%s", WORKING_DIR_PREFIX, tableNameWithType, System.currentTimeMillis(), RandomStringUtils.random((int)10, (boolean)true, (boolean)false)), (String)"Invalid table name: %S", (Object[])new Object[]{tableNameWithType});
        LOGGER.info("Starting ingestion of {} payload to table: {} using working dir: {}", new Object[]{payload._payloadType, tableNameWithType, workingDir.getAbsolutePath()});
        File inputDir = new File(workingDir, INPUT_DATA_DIR);
        File outputDir = new File(workingDir, OUTPUT_SEGMENT_DIR);
        File segmentTarDir = new File(workingDir, SEGMENT_TAR_DIR);
        try {
            Preconditions.checkState((boolean)inputDir.mkdirs(), (String)"Could not create directory for downloading input file locally: %s", (Object)inputDir);
            Preconditions.checkState((boolean)segmentTarDir.mkdirs(), (String)"Could not create directory for segment tar file: %s", (Object)inputDir);
            File inputFile = new File(inputDir, String.format("%s.%s", DATA_FILE_PREFIX, this._batchConfigMap.get("inputFormat").toLowerCase()));
            if (payload._payloadType == PayloadType.URI) {
                FileIngestionHelper.copyURIToLocal(this._batchConfigMap, payload._uri, inputFile);
                LOGGER.info("Copied from URI: {} to local file: {}", (Object)payload._uri, (Object)inputFile.getAbsolutePath());
            } else {
                FileIngestionHelper.copyMultipartToLocal(payload._multiPart, inputFile);
                LOGGER.info("Copied multipart payload to local file: {}", (Object)inputDir.getAbsolutePath());
            }
            HashMap<String, String> batchConfigMapOverride = new HashMap<String, String>(this._batchConfigMap);
            batchConfigMapOverride.put("inputDirURI", inputFile.getAbsolutePath());
            batchConfigMapOverride.put("outputDirURI", outputDir.getAbsolutePath());
            batchConfigMapOverride.put("push.controllerUri", this._controllerUri.toString());
            String segmentNamePostfixProp = String.format("%s.%s", "segmentNameGenerator.configs", "segment.name.postfix");
            if (StringUtils.isBlank((CharSequence)((CharSequence)batchConfigMapOverride.get(segmentNamePostfixProp)))) {
                batchConfigMapOverride.put(segmentNamePostfixProp, String.valueOf(System.currentTimeMillis()));
            }
            BatchIngestionConfig batchIngestionConfigOverride = new BatchIngestionConfig(Collections.singletonList(batchConfigMapOverride), IngestionConfigUtils.getBatchSegmentIngestionType((TableConfig)this._tableConfig), IngestionConfigUtils.getBatchSegmentIngestionFrequency((TableConfig)this._tableConfig));
            SegmentGeneratorConfig segmentGeneratorConfig = IngestionUtils.generateSegmentGeneratorConfig((TableConfig)this._tableConfig, (Schema)this._schema, (BatchIngestionConfig)batchIngestionConfigOverride);
            String segmentName = IngestionUtils.buildSegment((SegmentGeneratorConfig)segmentGeneratorConfig);
            LOGGER.info("Built segment: {}", (Object)segmentName);
            File segmentTarFile = new File(segmentTarDir, segmentName + ".tar.gz");
            TarGzCompressionUtils.createTarGzFile((File)new File(outputDir, segmentName), (File)segmentTarFile);
            IngestionConfig ingestionConfigOverride = new IngestionConfig();
            ingestionConfigOverride.setBatchIngestionConfig(batchIngestionConfigOverride);
            TableConfig tableConfigOverride = new TableConfigBuilder(this._tableConfig.getTableType()).setTableName(this._tableConfig.getTableName()).setIngestionConfig(ingestionConfigOverride).build();
            SegmentUploader segmentUploader = (SegmentUploader)PluginManager.get().createInstance(SEGMENT_UPLOADER_CLASS);
            segmentUploader.init(tableConfigOverride);
            segmentUploader.uploadSegment(segmentTarFile.toURI(), this._authProvider);
            LOGGER.info("Uploaded tar: {} to table: {}", (Object)segmentTarFile.getAbsolutePath(), (Object)tableNameWithType);
            SuccessResponse successResponse = new SuccessResponse("Successfully ingested file into table: " + tableNameWithType + " as segment: " + segmentName);
            return successResponse;
        }
        catch (Exception e) {
            LOGGER.error("Caught exception when ingesting file to table: {}", (Object)tableNameWithType, (Object)e);
            throw e;
        }
        finally {
            FileUtils.deleteQuietly((File)workingDir);
        }
    }

    public static void copyURIToLocal(Map<String, String> batchConfigMap, URI sourceFileURI, File destFile) throws Exception {
        String sourceFileURIScheme = sourceFileURI.getScheme();
        if (!PinotFSFactory.isSchemeSupported((String)sourceFileURIScheme)) {
            PinotFSFactory.register((String)sourceFileURIScheme, (String)batchConfigMap.get("input.fs.className"), (PinotConfiguration)IngestionConfigUtils.getInputFsProps(batchConfigMap));
        }
        PinotFSFactory.create((String)sourceFileURIScheme).copyToLocalFile(sourceFileURI, destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyMultipartToLocal(FormDataMultiPart multiPart, File destFile) throws IOException {
        FormDataBodyPart formDataBodyPart = (FormDataBodyPart)((List)multiPart.getFields().values().iterator().next()).get(0);
        try (InputStream inputStream = (InputStream)formDataBodyPart.getValueAs(InputStream.class);
             FileOutputStream outputStream = new FileOutputStream(destFile);){
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            multiPart.cleanup();
        }
    }

    public static class DataPayload {
        PayloadType _payloadType;
        FormDataMultiPart _multiPart;
        URI _uri;

        public DataPayload(FormDataMultiPart multiPart) {
            this._payloadType = PayloadType.FILE;
            this._multiPart = multiPart;
        }

        public DataPayload(URI uri) {
            this._payloadType = PayloadType.URI;
            this._uri = uri;
        }
    }

    private static enum PayloadType {
        URI,
        FILE;

    }
}

