/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import com.google.common.collect.BiMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.pinot.common.restlet.resources.TableTierInfo;
import org.apache.pinot.controller.util.CompletionServiceHelper;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTableTierReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerTableTierReader.class);
    private final Executor _executor;
    private final HttpClientConnectionManager _connectionManager;

    public ServerTableTierReader(Executor executor, HttpClientConnectionManager connectionManager) {
        this._executor = executor;
        this._connectionManager = connectionManager;
    }

    public Map<String, TableTierInfo> getTableTierInfoFromServers(BiMap<String, String> serverEndPoints, String tableNameWithType, @Nullable String segmentName, int timeoutMs) {
        int numServers = serverEndPoints.size();
        LOGGER.info("Getting segment storage tiers from {} servers for table: {} with timeout: {}ms", new Object[]{numServers, tableNameWithType, timeoutMs});
        ArrayList<String> serverUrls = new ArrayList<String>(numServers);
        BiMap endpointsToServers = serverEndPoints.inverse();
        for (String endpoint : endpointsToServers.keySet()) {
            Object tierUri = endpoint;
            tierUri = segmentName == null ? (String)tierUri + "/tables/" + tableNameWithType + "/tiers" : (String)tierUri + "/segments/" + tableNameWithType + "/" + segmentName + "/tiers";
            serverUrls.add((String)tierUri);
        }
        LOGGER.debug("Getting table tier info with serverUrls: {}", serverUrls);
        CompletionServiceHelper completionServiceHelper = new CompletionServiceHelper(this._executor, this._connectionManager, (BiMap<String, String>)endpointsToServers);
        CompletionServiceHelper.CompletionServiceResponse serviceResponse = completionServiceHelper.doMultiGetRequest(serverUrls, tableNameWithType, false, timeoutMs);
        HashMap<String, TableTierInfo> serverToTableTierInfoMap = new HashMap<String, TableTierInfo>();
        int failedParses = 0;
        for (Map.Entry<String, String> streamResponse : serviceResponse._httpResponses.entrySet()) {
            try {
                TableTierInfo tableTierInfo = (TableTierInfo)JsonUtils.stringToObject((String)streamResponse.getValue(), TableTierInfo.class);
                serverToTableTierInfoMap.put(streamResponse.getKey(), tableTierInfo);
            }
            catch (IOException e) {
                ++failedParses;
                LOGGER.error("Failed to parse server {} response", (Object)streamResponse.getKey(), (Object)e);
            }
        }
        if (failedParses != 0) {
            LOGGER.warn("Failed to parse {} / {} TableTierInfo responses from servers.", (Object)failedParses, (Object)serverUrls.size());
        }
        return serverToTableTierInfoMap;
    }
}

