/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller;

import java.util.Map;
import java.util.Properties;
import org.apache.helix.NotificationContext;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.model.Message;
import org.apache.pinot.common.messages.RunPeriodicTaskMessage;
import org.apache.pinot.core.periodictask.PeriodicTaskScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerUserDefinedMessageHandlerFactory
implements MessageHandlerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerUserDefinedMessageHandlerFactory.class);
    private static final String USER_DEFINED_MSG_STRING = Message.MessageType.USER_DEFINE_MSG.toString();
    private final PeriodicTaskScheduler _periodicTaskScheduler;

    public ControllerUserDefinedMessageHandlerFactory(PeriodicTaskScheduler periodicTaskScheduler) {
        this._periodicTaskScheduler = periodicTaskScheduler;
    }

    public MessageHandler createHandler(Message message, NotificationContext notificationContext) {
        String messageType = message.getMsgSubType();
        if (messageType.equals("RUN_PERIODIC_TASK")) {
            return new RunPeriodicTaskMessageHandler(new RunPeriodicTaskMessage(message), notificationContext, this._periodicTaskScheduler);
        }
        LOGGER.warn("Received message with unsupported sub-type: {}, using no-op message handler", (Object)messageType);
        return new NoOpMessageHandler(message, notificationContext);
    }

    public String getMessageType() {
        return USER_DEFINED_MSG_STRING;
    }

    public void reset() {
    }

    private static class NoOpMessageHandler
    extends MessageHandler {
        NoOpMessageHandler(Message message, NotificationContext context) {
            super(message, context);
        }

        public HelixTaskResult handleMessage() {
            HelixTaskResult result = new HelixTaskResult();
            result.setSuccess(true);
            return result;
        }

        public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
            LOGGER.error("Got error for no-op message handling (error code: {}, error type: {})", new Object[]{code, type, e});
        }
    }

    private static class RunPeriodicTaskMessageHandler
    extends MessageHandler {
        private final String _periodicTaskRequestId;
        private final String _periodicTaskName;
        private final String _tableNameWithType;
        private final Map<String, String> _taskProperties;
        private final PeriodicTaskScheduler _periodicTaskScheduler;

        RunPeriodicTaskMessageHandler(RunPeriodicTaskMessage message, NotificationContext context, PeriodicTaskScheduler periodicTaskScheduler) {
            super((Message)message, context);
            this._periodicTaskRequestId = message.getPeriodicTaskRequestId();
            this._periodicTaskName = message.getPeriodicTaskName();
            this._tableNameWithType = message.getTableNameWithType();
            this._taskProperties = message.getTaskProperties();
            this._periodicTaskScheduler = periodicTaskScheduler;
        }

        public HelixTaskResult handleMessage() throws InterruptedException {
            LOGGER.info("[TaskRequestId: {}] Handling RunPeriodicTaskMessage by executing task {}", (Object)this._periodicTaskRequestId, (Object)this._periodicTaskName);
            this._periodicTaskScheduler.scheduleNow(this._periodicTaskName, RunPeriodicTaskMessageHandler.createTaskProperties(this._periodicTaskRequestId, this._tableNameWithType, this._taskProperties));
            HelixTaskResult helixTaskResult = new HelixTaskResult();
            helixTaskResult.setSuccess(true);
            return helixTaskResult;
        }

        public void onError(Exception e, MessageHandler.ErrorCode errorCode, MessageHandler.ErrorType errorType) {
            LOGGER.error("[TaskRequestId: {}] Message handling error.", (Object)this._periodicTaskRequestId, (Object)e);
        }

        private static Properties createTaskProperties(String periodicTaskRequestId, String tableNameWithType, Map<String, String> taskProperties) {
            Properties periodicTaskParameters = new Properties();
            if (periodicTaskRequestId != null) {
                periodicTaskParameters.setProperty("requestId", periodicTaskRequestId);
            }
            if (tableNameWithType != null) {
                periodicTaskParameters.setProperty("tableNameWithType", tableNameWithType);
            }
            if (taskProperties != null) {
                taskProperties.forEach(periodicTaskParameters::setProperty);
            }
            return periodicTaskParameters;
        }
    }
}

