/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.access;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.pinot.controller.api.access.AccessControl;
import org.apache.pinot.controller.api.access.AccessControlFactory;
import org.apache.pinot.controller.api.access.AccessControlUtils;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.core.auth.FineGrainedAccessControl;
import org.apache.pinot.core.auth.FineGrainedAuthUtils;
import org.apache.pinot.core.auth.ManualAuthorization;
import org.glassfish.grizzly.http.server.Request;

@Provider
public class AuthenticationFilter
implements ContainerRequestFilter {
    private static final Set<String> UNPROTECTED_PATHS = new HashSet<String>(Arrays.asList("", "help", "auth/info", "auth/verify", "health"));
    private static final String KEY_TABLE_NAME = "tableName";
    private static final String KEY_TABLE_NAME_WITH_TYPE = "tableNameWithType";
    private static final String KEY_SCHEMA_NAME = "schemaName";
    @Inject
    javax.inject.Provider<Request> _requestProvider;
    @Inject
    AccessControlFactory _accessControlFactory;
    @Context
    ResourceInfo _resourceInfo;
    @Context
    HttpHeaders _httpHeaders;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Request request = (Request)this._requestProvider.get();
        Method endpointMethod = this._resourceInfo.getResourceMethod();
        AccessControl accessControl = this._accessControlFactory.create();
        String endpointUrl = request.getRequestURI().substring(request.getContextPath().length());
        UriInfo uriInfo = requestContext.getUriInfo();
        if (AuthenticationFilter.isBaseFile(uriInfo.getPath()) || UNPROTECTED_PATHS.contains(uriInfo.getPath())) {
            return;
        }
        if (accessControl.protectAnnotatedOnly() && !endpointMethod.isAnnotationPresent(Authenticate.class)) {
            return;
        }
        if (endpointMethod.isAnnotationPresent(ManualAuthorization.class)) {
            return;
        }
        String tableName = AuthenticationFilter.extractTableName((MultivaluedMap<String, String>)uriInfo.getPathParameters(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        AccessType accessType = this.extractAccessType(endpointMethod);
        AccessControlUtils.validatePermission(tableName, accessType, this._httpHeaders, endpointUrl, accessControl);
        FineGrainedAuthUtils.validateFineGrainedAuth((Method)endpointMethod, (UriInfo)uriInfo, (HttpHeaders)this._httpHeaders, (FineGrainedAccessControl)accessControl);
    }

    @VisibleForTesting
    AccessType extractAccessType(Method endpointMethod) {
        if (endpointMethod.isAnnotationPresent(Authenticate.class)) {
            return endpointMethod.getAnnotation(Authenticate.class).value();
        }
        if (endpointMethod.getAnnotation(POST.class) != null) {
            return AccessType.CREATE;
        }
        if (endpointMethod.getAnnotation(PUT.class) != null) {
            return AccessType.UPDATE;
        }
        if (endpointMethod.getAnnotation(DELETE.class) != null) {
            return AccessType.DELETE;
        }
        return AccessType.READ;
    }

    @VisibleForTesting
    static String extractTableName(MultivaluedMap<String, String> pathParameters, MultivaluedMap<String, String> queryParameters) {
        String tableName = AuthenticationFilter.extractTableName(pathParameters);
        if (tableName != null) {
            return tableName;
        }
        return AuthenticationFilter.extractTableName(queryParameters);
    }

    private static String extractTableName(MultivaluedMap<String, String> mmap) {
        if (mmap.containsKey((Object)KEY_TABLE_NAME)) {
            return (String)mmap.getFirst((Object)KEY_TABLE_NAME);
        }
        if (mmap.containsKey((Object)KEY_TABLE_NAME_WITH_TYPE)) {
            return (String)mmap.getFirst((Object)KEY_TABLE_NAME_WITH_TYPE);
        }
        if (mmap.containsKey((Object)KEY_SCHEMA_NAME)) {
            return (String)mmap.getFirst((Object)KEY_SCHEMA_NAME);
        }
        return null;
    }

    private static boolean isBaseFile(String path) {
        return !path.contains("/") && path.contains(".");
    }
}

