/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.access;

import com.google.common.cache.Cache;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.core.HttpHeaders;
import org.apache.pinot.common.config.provider.AccessControlUserCache;
import org.apache.pinot.common.utils.BcryptUtils;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.api.access.AccessControl;
import org.apache.pinot.controller.api.access.AccessControlFactory;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.core.auth.BasicAuthPrincipal;
import org.apache.pinot.core.auth.BasicAuthUtils;
import org.apache.pinot.core.auth.ZkBasicAuthPrincipal;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

public class ZkBasicAuthAccessControlFactory
implements AccessControlFactory {
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private AccessControl _accessControl;

    @Override
    public void init(PinotConfiguration pinotConfiguration, PinotHelixResourceManager pinotHelixResourceManager) throws IOException {
        pinotHelixResourceManager.initUserACLConfig((ControllerConf)pinotConfiguration);
        this._accessControl = new BasicAuthAccessControl(new AccessControlUserCache(pinotHelixResourceManager.getPropertyStore()));
    }

    @Override
    public AccessControl create() {
        return this._accessControl;
    }

    private static class BasicAuthAccessControl
    implements AccessControl {
        private Map<String, ZkBasicAuthPrincipal> _name2principal;
        private final AccessControlUserCache _userCache;

        public BasicAuthAccessControl(AccessControlUserCache userCache) {
            this._userCache = userCache;
        }

        @Override
        public boolean protectAnnotatedOnly() {
            return false;
        }

        @Override
        public boolean hasDataAccess(HttpHeaders httpHeaders, String tableName) {
            return this.getPrincipal(httpHeaders).filter(p -> p.hasTable(tableName)).isPresent();
        }

        @Override
        public boolean hasAccess(String tableName, AccessType accessType, HttpHeaders httpHeaders, String endpointUrl) {
            return this.getPrincipal(httpHeaders).filter(p -> p.hasTable(TableNameBuilder.extractRawTableName((String)tableName)) && p.hasPermission(Objects.toString((Object)accessType))).isPresent();
        }

        @Override
        public boolean hasAccess(AccessType accessType, HttpHeaders httpHeaders, String endpointUrl) {
            return this.getPrincipal(httpHeaders).isPresent();
        }

        private Optional<ZkBasicAuthPrincipal> getPrincipal(HttpHeaders headers) {
            if (headers == null) {
                return Optional.empty();
            }
            this._name2principal = BasicAuthUtils.extractBasicAuthPrincipals((List)this._userCache.getAllControllerUserConfig()).stream().collect(Collectors.toMap(BasicAuthPrincipal::getName, p -> p));
            List authHeaders = headers.getRequestHeader(ZkBasicAuthAccessControlFactory.HEADER_AUTHORIZATION);
            if (authHeaders == null) {
                return Optional.empty();
            }
            Map<String, String> name2password = authHeaders.stream().collect(Collectors.toMap(org.apache.pinot.common.auth.BasicAuthUtils::extractUsername, org.apache.pinot.common.auth.BasicAuthUtils::extractPassword));
            Map<String, ZkBasicAuthPrincipal> password2principal = name2password.keySet().stream().collect(Collectors.toMap(name2password::get, this._name2principal::get));
            return password2principal.entrySet().stream().filter(entry -> BcryptUtils.checkpwWithCache((String)((String)entry.getKey()), (String)((ZkBasicAuthPrincipal)entry.getValue()).getPassword(), (Cache)this._userCache.getUserPasswordAuthCache())).map(u -> (ZkBasicAuthPrincipal)u.getValue()).filter(Objects::nonNull).findFirst();
        }

        @Override
        public AccessControl.AuthWorkflowInfo getAuthWorkflowInfo() {
            return new AccessControl.AuthWorkflowInfo("BASIC");
        }
    }
}

