/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.pinot.controller.api.access.AccessControl;
import org.apache.pinot.controller.api.access.AccessControlFactory;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.core.auth.Authorize;
import org.apache.pinot.core.auth.TargetType;

@Api(tags={"Auth"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class PinotControllerAuthResource {
    @Inject
    private AccessControlFactory _accessControlFactory;
    @Context
    HttpHeaders _httpHeaders;

    @GET
    @Path(value="auth/verify")
    @Authorize(targetType=TargetType.CLUSTER, action="GetAuth")
    @Produces(value={"application/json"})
    @ApiOperation(value="Check whether authentication is enabled")
    @ApiResponses(value={@ApiResponse(code=200, message="Verification result provided"), @ApiResponse(code=500, message="Verification error")})
    public boolean verify(@ApiParam(value="Table name without type") @QueryParam(value="tableName") String tableName, @ApiParam(value="API access type") @DefaultValue(value="READ") @QueryParam(value="accessType") AccessType accessType, @ApiParam(value="Endpoint URL") @QueryParam(value="endpointUrl") String endpointUrl) {
        AccessControl accessControl = this._accessControlFactory.create();
        return accessControl.hasAccess(tableName, accessType, this._httpHeaders, endpointUrl);
    }

    @GET
    @Path(value="auth/info")
    @Authorize(targetType=TargetType.CLUSTER, action="GetAuth")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve auth workflow info")
    @ApiResponses(value={@ApiResponse(code=200, message="Auth workflow info provided")})
    public AccessControl.AuthWorkflowInfo info() {
        return this._accessControlFactory.create().getAuthWorkflowInfo();
    }
}

