/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.common.utils.config.InstanceUtils;
import org.apache.pinot.common.utils.config.TagNameUtils;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.InstanceTagUpdateRequest;
import org.apache.pinot.controller.api.resources.OperationValidationResponse;
import org.apache.pinot.controller.api.resources.StateType;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.PinotResourceManagerResponse;
import org.apache.pinot.core.auth.Authorize;
import org.apache.pinot.core.auth.TargetType;
import org.apache.pinot.spi.config.instance.Instance;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Instance"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class PinotInstanceRestletResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotInstanceRestletResource.class);
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;

    @GET
    @Path(value="/instances")
    @Authorize(targetType=TargetType.CLUSTER, action="GetInstance")
    @Produces(value={"application/json"})
    @ApiOperation(value="List all instances")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal error")})
    public Instances getAllInstances() {
        return new Instances(this._pinotHelixResourceManager.getAllInstances());
    }

    @GET
    @Path(value="/instances/{instanceName}")
    @Authorize(targetType=TargetType.CLUSTER, action="GetInstance")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get instance information", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Instance not found"), @ApiResponse(code=500, message="Internal error")})
    public String getInstance(@ApiParam(value="Instance name", required=true, example="Server_a.b.com_20000 | Broker_my.broker.com_30000") @PathParam(value="instanceName") String instanceName) {
        InstanceConfig instanceConfig = this._pinotHelixResourceManager.getHelixInstanceConfig(instanceName);
        if (instanceConfig == null) {
            throw new ControllerApplicationException(LOGGER, "Instance " + instanceName + " not found", Response.Status.NOT_FOUND);
        }
        ObjectNode response = JsonUtils.newObjectNode();
        response.put("instanceName", instanceConfig.getInstanceName());
        response.put("hostName", instanceConfig.getHostName());
        response.put("enabled", instanceConfig.getInstanceEnabled());
        response.put("port", instanceConfig.getPort());
        response.set("tags", JsonUtils.objectToJsonNode((Object)instanceConfig.getTags()));
        response.set("pools", JsonUtils.objectToJsonNode((Object)instanceConfig.getRecord().getMapField("pool")));
        response.put("grpcPort", this.getGrpcPort(instanceConfig));
        response.put("adminPort", this.getAdminPort(instanceConfig));
        response.put("queryServicePort", this.getQueryServicePort(instanceConfig));
        response.put("queryMailboxPort", this.getQueryMailboxPort(instanceConfig));
        String queriesDisabled = instanceConfig.getRecord().getSimpleField("queriesDisabled");
        if ("true".equalsIgnoreCase(queriesDisabled)) {
            response.put("queriesDisabled", "true");
        }
        response.put("systemResourceInfo", JsonUtils.objectToJsonNode(this.getSystemResourceInfo(instanceConfig)));
        return response.toString();
    }

    private int getGrpcPort(InstanceConfig instanceConfig) {
        String grpcPortStr = instanceConfig.getRecord().getSimpleField("grpcPort");
        if (grpcPortStr != null) {
            try {
                return Integer.parseInt(grpcPortStr);
            }
            catch (Exception e) {
                LOGGER.warn("Illegal gRPC port: {} for instance: {}", (Object)grpcPortStr, (Object)instanceConfig.getInstanceName());
            }
        }
        return -1;
    }

    private int getAdminPort(InstanceConfig instanceConfig) {
        String adminPortStr = instanceConfig.getRecord().getSimpleField("adminPort");
        if (adminPortStr != null) {
            try {
                return Integer.parseInt(adminPortStr);
            }
            catch (Exception e) {
                LOGGER.warn("Illegal admin port: {} for instance: {}", (Object)adminPortStr, (Object)instanceConfig.getInstanceName());
            }
        }
        return -1;
    }

    private int getQueryServicePort(InstanceConfig instanceConfig) {
        String queryServicePortStr = instanceConfig.getRecord().getSimpleField("queryServerPort");
        if (queryServicePortStr != null) {
            try {
                return Integer.parseInt(queryServicePortStr);
            }
            catch (Exception e) {
                LOGGER.warn("Illegal service port: {} for instance: {}", (Object)queryServicePortStr, (Object)instanceConfig.getInstanceName());
            }
        }
        return -1;
    }

    private int getQueryMailboxPort(InstanceConfig instanceConfig) {
        String queryMailboxPortStr = instanceConfig.getRecord().getSimpleField("queryMailboxPort");
        if (queryMailboxPortStr != null) {
            try {
                return Integer.parseInt(queryMailboxPortStr);
            }
            catch (Exception e) {
                LOGGER.warn("Illegal mailbox port: {} for instance: {}", (Object)queryMailboxPortStr, (Object)instanceConfig.getInstanceName());
            }
        }
        return -1;
    }

    private Map<String, String> getSystemResourceInfo(InstanceConfig instanceConfig) {
        return instanceConfig.getRecord().getMapField("SYSTEM_RESOURCE_INFO");
    }

    @POST
    @Path(value="/instances")
    @Authorize(targetType=TargetType.CLUSTER, action="CreateInstance")
    @Authenticate(value=AccessType.CREATE)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new instance", consumes="application/json", notes="Creates a new instance with given instance config")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=409, message="Instance already exists"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse addInstance(@ApiParam(value="Whether to update broker resource for broker instance") @QueryParam(value="updateBrokerResource") @DefaultValue(value="false") boolean updateBrokerResource, Instance instance) {
        String instanceId = InstanceUtils.getHelixInstanceId((Instance)instance);
        LOGGER.info("Instance creation request received for instance: {}, updateBrokerResource: {}", (Object)instanceId, (Object)updateBrokerResource);
        try {
            PinotResourceManagerResponse response = this._pinotHelixResourceManager.addInstance(instance, updateBrokerResource);
            return new SuccessResponse(response.getMessage());
        }
        catch (ClientErrorException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), e.getResponse().getStatus());
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Failed to create instance: " + instanceId, Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @PUT
    @Path(value="/instances/{instanceName}/state")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Enable/disable an instance", notes="Enable/disable an instance")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=404, message="Instance not found"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse toggleInstanceState(@ApiParam(value="Instance name", required=true, example="Server_a.b.com_20000 | Broker_my.broker.com_30000") @PathParam(value="instanceName") String instanceName, @ApiParam(value="enable|disable", required=true) @QueryParam(value="state") String state) {
        if (!this._pinotHelixResourceManager.instanceExists(instanceName)) {
            throw new ControllerApplicationException(LOGGER, "Instance '" + instanceName + "' does not exist", Response.Status.NOT_FOUND);
        }
        if (StateType.ENABLE.name().equalsIgnoreCase(state)) {
            PinotResourceManagerResponse response = this._pinotHelixResourceManager.enableInstance(instanceName);
            if (!response.isSuccessful()) {
                throw new ControllerApplicationException(LOGGER, "Failed to enable instance '" + instanceName + "': " + response.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
            }
        } else if (StateType.DISABLE.name().equalsIgnoreCase(state)) {
            PinotResourceManagerResponse response = this._pinotHelixResourceManager.disableInstance(instanceName);
            if (!response.isSuccessful()) {
                throw new ControllerApplicationException(LOGGER, "Failed to disable instance '" + instanceName + "': " + response.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
            }
        } else {
            throw new ControllerApplicationException(LOGGER, "Unknown state '" + state + "'", Response.Status.BAD_REQUEST);
        }
        return new SuccessResponse("Request to " + state + " instance '" + instanceName + "' is successful");
    }

    @Deprecated
    @POST
    @Path(value="/instances/{instanceName}/state")
    @Authorize(targetType=TargetType.CLUSTER, action="UpdateInstance")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Enable/disable/drop an instance", notes="Enable/disable/drop an instance")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=404, message="Instance not found"), @ApiResponse(code=409, message="Instance cannot be dropped"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse toggleInstanceStateDeprecated(@ApiParam(value="Instance name", required=true, example="Server_a.b.com_20000 | Broker_my.broker.com_30000") @PathParam(value="instanceName") String instanceName, String state) {
        if (!this._pinotHelixResourceManager.instanceExists(instanceName)) {
            throw new ControllerApplicationException(LOGGER, "Instance " + instanceName + " not found", Response.Status.NOT_FOUND);
        }
        if (StateType.ENABLE.name().equalsIgnoreCase(state)) {
            PinotResourceManagerResponse response = this._pinotHelixResourceManager.enableInstance(instanceName);
            if (!response.isSuccessful()) {
                throw new ControllerApplicationException(LOGGER, "Failed to enable instance " + instanceName + " - " + response.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
            }
        } else if (StateType.DISABLE.name().equalsIgnoreCase(state)) {
            PinotResourceManagerResponse response = this._pinotHelixResourceManager.disableInstance(instanceName);
            if (!response.isSuccessful()) {
                throw new ControllerApplicationException(LOGGER, "Failed to disable instance " + instanceName + " - " + response.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
            }
        } else if (StateType.DROP.name().equalsIgnoreCase(state)) {
            PinotResourceManagerResponse response = this._pinotHelixResourceManager.dropInstance(instanceName);
            if (!response.isSuccessful()) {
                throw new ControllerApplicationException(LOGGER, "Failed to drop instance " + instanceName + " - " + response.getMessage(), Response.Status.CONFLICT);
            }
        } else {
            throw new ControllerApplicationException(LOGGER, "Unknown state " + state + " for instance request", Response.Status.BAD_REQUEST);
        }
        return new SuccessResponse("Request to " + state + " instance " + instanceName + " is successful");
    }

    @DELETE
    @Path(value="/instances/{instanceName}")
    @Authorize(targetType=TargetType.CLUSTER, action="DeleteInstance")
    @Authenticate(value=AccessType.DELETE)
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Drop an instance", notes="Drop an instance")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Instance not found"), @ApiResponse(code=409, message="Instance cannot be dropped"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse dropInstance(@ApiParam(value="Instance name", required=true, example="Server_a.b.com_20000 | Broker_my.broker.com_30000") @PathParam(value="instanceName") String instanceName) {
        boolean instanceExists = this._pinotHelixResourceManager.instanceExists(instanceName);
        PinotResourceManagerResponse response = this._pinotHelixResourceManager.dropInstance(instanceName);
        if (response.isSuccessful()) {
            if (instanceExists) {
                return new SuccessResponse("Successfully dropped instance");
            }
            throw new ControllerApplicationException(LOGGER, "Instance " + instanceName + " not found", Response.Status.NOT_FOUND);
        }
        throw new ControllerApplicationException(LOGGER, "Failed to drop instance " + instanceName + " - " + response.getMessage(), Response.Status.CONFLICT);
    }

    @PUT
    @Path(value="/instances/{instanceName}")
    @Authorize(targetType=TargetType.CLUSTER, action="UpdateInstance")
    @Authenticate(value=AccessType.UPDATE)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update the specified instance", consumes="application/json", notes="Update specified instance with given instance config")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse updateInstance(@ApiParam(value="Instance name", required=true, example="Server_a.b.com_20000 | Broker_my.broker.com_30000") @PathParam(value="instanceName") String instanceName, @ApiParam(value="Whether to update broker resource for broker instance") @QueryParam(value="updateBrokerResource") @DefaultValue(value="false") boolean updateBrokerResource, Instance instance) {
        LOGGER.info("Instance update request received for instance: {}, updateBrokerResource: {}", (Object)instanceName, (Object)updateBrokerResource);
        try {
            PinotResourceManagerResponse response = this._pinotHelixResourceManager.updateInstance(instanceName, instance, updateBrokerResource);
            return new SuccessResponse(response.getMessage());
        }
        catch (ClientErrorException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), e.getResponse().getStatus());
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Failed to update instance: " + instanceName, Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @PUT
    @Path(value="/instances/{instanceName}/updateTags")
    @Authorize(targetType=TargetType.CLUSTER, action="UpdateInstance")
    @Authenticate(value=AccessType.UPDATE)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update the tags of the specified instance", consumes="application/json", notes="Update the tags of the specified instance")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=404, message="Instance not found"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse updateInstanceTags(@ApiParam(value="Instance name", required=true, example="Server_a.b.com_20000 | Broker_my.broker.com_30000") @PathParam(value="instanceName") String instanceName, @ApiParam(value="Comma separated tags list", required=true) @QueryParam(value="tags") String tags, @ApiParam(value="Whether to update broker resource for broker instance") @QueryParam(value="updateBrokerResource") @DefaultValue(value="false") boolean updateBrokerResource) {
        LOGGER.info("Instance update request received for instance: {}, tags: {}, updateBrokerResource: {}", new Object[]{instanceName, tags, updateBrokerResource});
        if (tags == null) {
            throw new ControllerApplicationException(LOGGER, "Must provide tags to update", Response.Status.BAD_REQUEST);
        }
        try {
            PinotResourceManagerResponse response = this._pinotHelixResourceManager.updateInstanceTags(instanceName, tags, updateBrokerResource);
            return new SuccessResponse(response.getMessage());
        }
        catch (ClientErrorException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), e.getResponse().getStatus());
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to update instance: %s with tags: %s", instanceName, tags), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @POST
    @Path(value="/instances/{instanceName}/updateBrokerResource")
    @Authorize(targetType=TargetType.CLUSTER, action="UpdateBrokerResource")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Update the tables served by the specified broker instance in the broker resource", notes="Broker resource should be updated when a new broker instance is added, or the tags for an existing broker are changed. Updating broker resource requires reading all the table configs, which can be costly for large cluster. Consider updating broker resource for each table individually.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=404, message="Instance not found"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse updateBrokerResource(@ApiParam(value="Instance name", required=true, example="Broker_my.broker.com_30000") @PathParam(value="instanceName") String instanceName) {
        LOGGER.info("Update broker resource request received for instance: {}", (Object)instanceName);
        try {
            PinotResourceManagerResponse response = this._pinotHelixResourceManager.updateBrokerResource(instanceName);
            return new SuccessResponse(response.getMessage());
        }
        catch (ClientErrorException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), e.getResponse().getStatus());
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Failed to update broker resource for instance: " + instanceName, Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @GET
    @Path(value="/instances/dropInstance/validate")
    @Authorize(targetType=TargetType.CLUSTER, action="GetInstance")
    @Produces(value={"application/json"})
    @ApiOperation(value="Check if it's safe to drop the given instances. If not list all the reasons why its not safe.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal error")})
    public List<OperationValidationResponse> instanceDropSafetyCheck(@ApiParam(value="Instance names", required=true, example="Broker_my.broker.com_30000") @QueryParam(value="instanceNames") List<String> instanceNames) {
        LOGGER.info("Performing safety check on drop operation request received for instances: {}", instanceNames);
        try {
            return instanceNames.stream().map(instance -> this._pinotHelixResourceManager.instanceDropSafetyCheck((String)instance)).collect(Collectors.toList());
        }
        catch (ClientErrorException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), e.getResponse().getStatus());
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Failed to check the safety for instance drop operation.", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @POST
    @Path(value="/instances/updateTags/validate")
    @Produces(value={"application/json"})
    @ApiOperation(value="Check if it's safe to update the tags of the given instances. If not list all the reasons.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal error")})
    public List<OperationValidationResponse> instanceTagUpdateSafetyCheck(List<InstanceTagUpdateRequest> requests) {
        LOGGER.info("Performing safety check on tag update request received for instances: {}", requests.stream().map(InstanceTagUpdateRequest::getInstanceName).collect(Collectors.toList()));
        Map<String, Integer> tagMinServerMap = this._pinotHelixResourceManager.minimumInstancesRequiredForTags();
        Map<String, Integer> tagToInstanceCountMap = this.getUpdatedTagToInstanceCountMap(requests);
        Map<String, Integer> tagDeficiency = this.computeTagDeficiency(tagToInstanceCountMap, tagMinServerMap);
        HashMap<String, List> responseMap = new HashMap<String, List>(HashUtil.getHashMapCapacity((int)requests.size()));
        ArrayList<OperationValidationResponse.ErrorWrapper> tenantIssues = new ArrayList<OperationValidationResponse.ErrorWrapper>();
        requests.forEach(request -> responseMap.put(request.getInstanceName(), new ArrayList()));
        for (InstanceTagUpdateRequest request2 : requests) {
            HashSet<String> oldTags;
            String name = request2.getInstanceName();
            try {
                oldTags = new HashSet<String>(this._pinotHelixResourceManager.getTagsForInstance(name));
            }
            catch (NullPointerException exception) {
                throw new ControllerApplicationException(LOGGER, String.format("Instance %s is not a valid instance name.", name), Response.Status.PRECONDITION_FAILED);
            }
            HashSet<String> newTags = new HashSet<String>(request2.getNewTags());
            for (String tag : Sets.difference(oldTags, newTags)) {
                Integer deficiency = tagDeficiency.get(tag);
                if (deficiency == null || deficiency <= 0) continue;
                String tenant = TagNameUtils.getTenantFromTag((String)tag);
                String tagType = this.getInstanceTypeFromTag(tag);
                ((List)responseMap.get(name)).add(new OperationValidationResponse.ErrorWrapper(OperationValidationResponse.ErrorCode.MINIMUM_INSTANCE_UNSATISFIED, tenant, tagType, tag, tagType, name));
                tagDeficiency.put(tag, deficiency - 1);
            }
            for (String tag : newTags) {
                String tagType = this.getInstanceTypeFromTag(tag);
                if (tagType == null && (name.startsWith("Broker_") || name.startsWith("Server_"))) {
                    ((List)responseMap.get(name)).add(new OperationValidationResponse.ErrorWrapper(OperationValidationResponse.ErrorCode.UNRECOGNISED_TAG_TYPE, tag));
                    continue;
                }
                Integer deficiency = tagDeficiency.get(tag);
                if (deficiency == null || deficiency <= 0) continue;
                tenantIssues.add(new OperationValidationResponse.ErrorWrapper(OperationValidationResponse.ErrorCode.ALREADY_DEFICIENT_TENANT, TagNameUtils.getTenantFromTag((String)tag), tagType, deficiency.toString(), name));
            }
        }
        ArrayList<OperationValidationResponse> response = new ArrayList<OperationValidationResponse>(requests.size());
        responseMap.forEach((instance, issueList) -> response.add(issueList.isEmpty() ? new OperationValidationResponse().setInstanceName((String)instance).setSafe(true) : new OperationValidationResponse().putAllIssues((List<OperationValidationResponse.ErrorWrapper>)issueList).setInstanceName((String)instance).setSafe(false)));
        if (!tenantIssues.isEmpty()) {
            response.add(new OperationValidationResponse().putAllIssues(tenantIssues).setSafe(false));
        }
        return response;
    }

    private String getInstanceTypeFromTag(String tag) {
        if (TagNameUtils.isServerTag((String)tag)) {
            return "server";
        }
        if (TagNameUtils.isBrokerTag((String)tag)) {
            return "broker";
        }
        return null;
    }

    private Map<String, Integer> computeTagDeficiency(Map<String, Integer> tagToInstanceCountMap, Map<String, Integer> tagToMinInstanceCountMap) {
        HashMap<String, Integer> tagDeficiency = new HashMap<String, Integer>();
        HashMap<String, Integer> tagToInstanceCountMapCopy = new HashMap<String, Integer>(tagToInstanceCountMap);
        tagToMinInstanceCountMap.forEach((tag, minInstances) -> {
            Integer updatedInstances = (Integer)tagToInstanceCountMapCopy.remove(tag);
            tagDeficiency.put((String)tag, minInstances - (updatedInstances != null ? updatedInstances : 0));
        });
        tagToInstanceCountMapCopy.forEach((tag, updatedInstances) -> tagDeficiency.put((String)tag, 0));
        return tagDeficiency;
    }

    private Map<String, Integer> getUpdatedTagToInstanceCountMap(List<InstanceTagUpdateRequest> requests) {
        HashMap<String, Integer> updatedTagInstanceMap = new HashMap<String, Integer>();
        HashSet visitedInstances = new HashSet();
        requests.forEach(instance -> {
            instance.getNewTags().forEach(tag -> updatedTagInstanceMap.put((String)tag, updatedTagInstanceMap.getOrDefault(tag, 0) + 1));
            visitedInstances.add(instance.getInstanceName());
        });
        this._pinotHelixResourceManager.getAllInstances().forEach(instance -> {
            if (!visitedInstances.contains(instance)) {
                this._pinotHelixResourceManager.getTagsForInstance((String)instance).forEach(tag -> updatedTagInstanceMap.put((String)tag, updatedTagInstanceMap.getOrDefault(tag, 0) + 1));
                visitedInstances.add(instance);
            }
        });
        return updatedTagInstanceMap;
    }

    public static class Instances {
        List<String> _instances;

        public Instances(@JsonProperty(value="instances") List<String> instances) {
            this._instances = instances;
        }

        public List<String> getInstances() {
            return this._instances;
        }
    }
}

