/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.common.assignment.InstancePartitionsUtils;
import org.apache.pinot.common.metadata.controllerjob.ControllerJobType;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.api.access.AccessType;
import org.apache.pinot.controller.api.access.Authenticate;
import org.apache.pinot.controller.api.exception.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.StateType;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.api.resources.TenantRebalanceJobStatusResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.PinotResourceManagerResponse;
import org.apache.pinot.controller.helix.core.rebalance.tenant.TenantRebalanceConfig;
import org.apache.pinot.controller.helix.core.rebalance.tenant.TenantRebalanceProgressStats;
import org.apache.pinot.controller.helix.core.rebalance.tenant.TenantRebalanceResult;
import org.apache.pinot.controller.helix.core.rebalance.tenant.TenantRebalancer;
import org.apache.pinot.core.auth.Authorize;
import org.apache.pinot.core.auth.TargetType;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;
import org.apache.pinot.spi.config.tenant.Tenant;
import org.apache.pinot.spi.config.tenant.TenantRole;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Tenant"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class PinotTenantRestletResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotTenantRestletResource.class);
    private static final String TENANT_NAME = "tenantName";
    private static final String TABLES = "tables";
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;
    @Inject
    ControllerMetrics _controllerMetrics;
    @Inject
    TenantRebalancer _tenantRebalancer;

    @POST
    @Path(value="/tenants")
    @Authorize(targetType=TargetType.CLUSTER, action="CreateTenant")
    @Authenticate(value=AccessType.CREATE)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value=" Create a tenant")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Error creating tenant")})
    public SuccessResponse createTenant(Tenant tenant) {
        PinotResourceManagerResponse response;
        switch (tenant.getTenantRole()) {
            case BROKER: {
                response = this._pinotHelixResourceManager.createBrokerTenant(tenant);
                break;
            }
            case SERVER: {
                response = this._pinotHelixResourceManager.createServerTenant(tenant);
                break;
            }
            default: {
                throw new RuntimeException("Not a valid tenant creation call");
            }
        }
        if (response.isSuccessful()) {
            return new SuccessResponse("Successfully created tenant");
        }
        this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_TENANT_CREATE_ERROR, 1L);
        throw new ControllerApplicationException(LOGGER, "Failed to create tenant", Response.Status.INTERNAL_SERVER_ERROR);
    }

    @PUT
    @Path(value="/tenants")
    @Authorize(targetType=TargetType.CLUSTER, action="UpdateTenant")
    @Authenticate(value=AccessType.UPDATE)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a tenant")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Failed to update the tenant")})
    public SuccessResponse updateTenant(Tenant tenant) {
        PinotResourceManagerResponse response;
        switch (tenant.getTenantRole()) {
            case BROKER: {
                response = this._pinotHelixResourceManager.updateBrokerTenant(tenant);
                break;
            }
            case SERVER: {
                response = this._pinotHelixResourceManager.updateServerTenant(tenant);
                break;
            }
            default: {
                throw new RuntimeException("Not a valid tenant update call");
            }
        }
        if (response.isSuccessful()) {
            return new SuccessResponse("Updated tenant");
        }
        this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_TENANT_UPDATE_ERROR, 1L);
        throw new ControllerApplicationException(LOGGER, "Failed to update tenant", Response.Status.INTERNAL_SERVER_ERROR);
    }

    @GET
    @Path(value="/tenants")
    @Authorize(targetType=TargetType.CLUSTER, action="GetTenant")
    @Produces(value={"application/json"})
    @ApiOperation(value="List all tenants")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Error reading tenants list")})
    public TenantsList getAllTenants(@ApiParam(value="Tenant type", required=false, allowableValues="BROKER, SERVER", defaultValue="") @QueryParam(value="type") @DefaultValue(value="") String type) {
        TenantsList tenants = new TenantsList();
        if (type == null || type.isEmpty() || type.equalsIgnoreCase("server")) {
            tenants._serverTenants = this._pinotHelixResourceManager.getAllServerTenantNames();
        }
        if (type == null || type.isEmpty() || type.equalsIgnoreCase("broker")) {
            tenants._brokerTenants = this._pinotHelixResourceManager.getAllBrokerTenantNames();
        }
        return tenants;
    }

    @GET
    @Path(value="/tenants/{tenantName}")
    @Authorize(targetType=TargetType.CLUSTER, action="GetTenant")
    @Produces(value={"application/json"})
    @ApiOperation(value="List instance for a tenant")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Error reading tenants list")})
    public String listInstance(@ApiParam(value="Tenant name", required=true) @PathParam(value="tenantName") String tenantName, @ApiParam(value="Tenant type (server|broker)") @QueryParam(value="type") String tenantType, @ApiParam(value="Table type (offline|realtime)") @QueryParam(value="tableType") String tableType) {
        return this.listInstancesForTenant(tenantName, tenantType, tableType);
    }

    @POST
    @Path(value="/tenants/{tenantName}")
    @Authorize(targetType=TargetType.CLUSTER, action="UpdateTenant")
    @Produces(value={"application/json"})
    @ApiOperation(value="enable/disable a tenant")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Error applying state to tenant")})
    public SuccessResponse enableOrDisableTenant(@ApiParam(value="Tenant name", required=true) @PathParam(value="tenantName") String tenantName, @ApiParam(value="Tenant type (server|broker)") @QueryParam(value="type") String tenantType, @ApiParam(value="state (enable|disable)") @QueryParam(value="state") String stateStr) {
        if (stateStr.equalsIgnoreCase(String.valueOf((Object)StateType.ENABLE)) || stateStr.equalsIgnoreCase(String.valueOf((Object)StateType.DISABLE))) {
            return this.toggleTenantState(tenantName, stateStr, tenantType);
        }
        throw new ControllerApplicationException(LOGGER, "Error: State mentioned " + stateStr + " is wrong. Valid States: Enable, Disable", Response.Status.BAD_REQUEST);
    }

    @GET
    @Path(value="/tenants/{tenantName}/tables")
    @Authorize(targetType=TargetType.CLUSTER, action="GetTenant")
    @Produces(value={"application/json"})
    @ApiOperation(value="List tables on a server or broker tenant")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Error reading list")})
    public String getTablesOnTenant(@ApiParam(value="Tenant name", required=true) @PathParam(value="tenantName") String tenantName, @ApiParam(value="Tenant type (server|broker)", required=false, allowableValues="BROKER, SERVER", defaultValue="SERVER") @QueryParam(value="type") String tenantType) {
        if (tenantType == null || tenantType.isEmpty() || tenantType.equalsIgnoreCase("server")) {
            return this.getTablesServedFromServerTenant(tenantName);
        }
        if (tenantType.equalsIgnoreCase("broker")) {
            return this.getTablesServedFromBrokerTenant(tenantName);
        }
        throw new ControllerApplicationException(LOGGER, "Invalid tenant type: " + tenantType, Response.Status.BAD_REQUEST);
    }

    @GET
    @Path(value="/tenants/{tenantName}/instancePartitions")
    @Authorize(targetType=TargetType.CLUSTER, action="GetInstancePartitions")
    @Authenticate(value=AccessType.READ)
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the instance partitions of a tenant")
    @ApiResponses(value={@ApiResponse(code=200, message="Success", response=InstancePartitions.class), @ApiResponse(code=404, message="Instance partitions not found")})
    public InstancePartitions getInstancePartitions(@ApiParam(value="Tenant name ", required=true) @PathParam(value="tenantName") String tenantName, @ApiParam(value="instancePartitionType (OFFLINE|CONSUMING|COMPLETED)", required=true, allowableValues="OFFLINE, CONSUMING, COMPLETED") @QueryParam(value="instancePartitionType") String instancePartitionType) {
        String tenantNameWithType = InstancePartitionsType.valueOf((String)instancePartitionType).getInstancePartitionsName(tenantName);
        InstancePartitions instancePartitions = InstancePartitionsUtils.fetchInstancePartitions(this._pinotHelixResourceManager.getPropertyStore(), (String)tenantNameWithType);
        if (instancePartitions == null) {
            throw new ControllerApplicationException(LOGGER, String.format("Failed to find the instance partitions for %s", tenantNameWithType), Response.Status.NOT_FOUND);
        }
        return instancePartitions;
    }

    @PUT
    @Path(value="/tenants/{tenantName}/instancePartitions")
    @Authorize(targetType=TargetType.CLUSTER, action="UpdateInstancePartitions")
    @Authenticate(value=AccessType.UPDATE)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update an instance partition for a server type in a tenant")
    @ApiResponses(value={@ApiResponse(code=200, message="Success", response=InstancePartitions.class), @ApiResponse(code=400, message="Failed to deserialize/validate the instance partitions"), @ApiResponse(code=500, message="Error updating the tenant")})
    public InstancePartitions assignInstancesPartitionMap(@ApiParam(value="Tenant name ", required=true) @PathParam(value="tenantName") String tenantName, @ApiParam(value="instancePartitionType (OFFLINE|CONSUMING|COMPLETED)", required=true, allowableValues="OFFLINE, CONSUMING, COMPLETED") @QueryParam(value="instancePartitionType") String instancePartitionType, String instancePartitionsStr) {
        InstancePartitions instancePartitions;
        try {
            instancePartitions = (InstancePartitions)JsonUtils.stringToObject((String)instancePartitionsStr, InstancePartitions.class);
        }
        catch (IOException e) {
            throw new ControllerApplicationException(LOGGER, "Failed to deserialize the instance partitions", Response.Status.BAD_REQUEST);
        }
        String inputTenantName = InstancePartitionsType.valueOf((String)instancePartitionType).getInstancePartitionsName(tenantName);
        if (!instancePartitions.getInstancePartitionsName().equals(inputTenantName)) {
            throw new ControllerApplicationException(LOGGER, "Instance partitions name mismatch, expected: " + inputTenantName + ", got: " + instancePartitions.getInstancePartitionsName(), Response.Status.BAD_REQUEST);
        }
        this.persistInstancePartitionsHelper(instancePartitions);
        return instancePartitions;
    }

    private void persistInstancePartitionsHelper(InstancePartitions instancePartitions) {
        try {
            LOGGER.info("Persisting instance partitions: {}", (Object)instancePartitions);
            InstancePartitionsUtils.persistInstancePartitions(this._pinotHelixResourceManager.getPropertyStore(), (InstancePartitions)instancePartitions);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Caught Exception while persisting the instance partitions", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private String getTablesServedFromServerTenant(String tenantName) {
        HashSet<String> tables = new HashSet<String>();
        ObjectNode resourceGetRet = JsonUtils.newObjectNode();
        for (String table : this._pinotHelixResourceManager.getAllTables()) {
            TableConfig tableConfig = this._pinotHelixResourceManager.getTableConfig(table);
            if (tableConfig == null) {
                LOGGER.error("Unable to retrieve table config for table: {}", (Object)table);
                continue;
            }
            String tableConfigTenant = tableConfig.getTenantConfig().getServer();
            if (!tenantName.equals(tableConfigTenant)) continue;
            tables.add(table);
        }
        resourceGetRet.set(TABLES, JsonUtils.objectToJsonNode(tables));
        return resourceGetRet.toString();
    }

    private String getTablesServedFromBrokerTenant(String tenantName) {
        HashSet<String> tables = new HashSet<String>();
        ObjectNode resourceGetRet = JsonUtils.newObjectNode();
        for (String table : this._pinotHelixResourceManager.getAllTables()) {
            TableConfig tableConfig = this._pinotHelixResourceManager.getTableConfig(table);
            if (tableConfig == null) {
                LOGGER.error("Unable to retrieve table config for table: {}", (Object)table);
                continue;
            }
            String tableConfigTenant = tableConfig.getTenantConfig().getBroker();
            if (!tenantName.equals(tableConfigTenant)) continue;
            tables.add(table);
        }
        resourceGetRet.set(TABLES, JsonUtils.objectToJsonNode(tables));
        return resourceGetRet.toString();
    }

    private SuccessResponse toggleTenantState(String tenantName, String stateStr, @Nullable String tenantType) {
        Set<Object> serverInstances = new HashSet();
        Set<Object> brokerInstances = new HashSet();
        ObjectNode instanceResult = JsonUtils.newObjectNode();
        if (tenantType == null || tenantType.equalsIgnoreCase("server")) {
            serverInstances = this._pinotHelixResourceManager.getAllInstancesForServerTenant(tenantName);
        }
        if (tenantType == null || tenantType.equalsIgnoreCase("broker")) {
            brokerInstances = this._pinotHelixResourceManager.getAllInstancesForBrokerTenant(tenantName);
        }
        HashSet allInstances = new HashSet(serverInstances);
        allInstances.addAll(brokerInstances);
        if (StateType.DISABLE.name().equalsIgnoreCase(stateStr)) {
            for (String instance : allInstances) {
                instanceResult.put(instance, JsonUtils.objectToJsonNode((Object)this._pinotHelixResourceManager.disableInstance(instance)));
            }
        }
        if (StateType.ENABLE.name().equalsIgnoreCase(stateStr)) {
            for (String instance : allInstances) {
                instanceResult.put(instance, JsonUtils.objectToJsonNode((Object)this._pinotHelixResourceManager.enableInstance(instance)));
            }
        }
        return new SuccessResponse("Changed state of tenant " + tenantName + " to " + stateStr + " successfully.");
    }

    private String listInstancesForTenant(String tenantName, String tenantType, String tableTypeString) {
        ObjectNode resourceGetRet = JsonUtils.newObjectNode();
        List<InstanceConfig> instanceConfigList = this._pinotHelixResourceManager.getAllHelixInstanceConfigs();
        if (tenantType == null) {
            Set<String> allServerInstances = this._pinotHelixResourceManager.getAllInstancesForServerTenant(instanceConfigList, tenantName);
            Set<String> allBrokerInstances = this._pinotHelixResourceManager.getAllInstancesForBrokerTenant(instanceConfigList, tenantName);
            if (allServerInstances.isEmpty() && allBrokerInstances.isEmpty()) {
                throw new ControllerApplicationException(LOGGER, "Failed to find any instances for broker and server tenants: " + tenantName, Response.Status.NOT_FOUND);
            }
            resourceGetRet.set("ServerInstances", JsonUtils.objectToJsonNode(allServerInstances));
            resourceGetRet.set("BrokerInstances", JsonUtils.objectToJsonNode(allBrokerInstances));
        } else {
            if (tenantType.equalsIgnoreCase("server")) {
                HashSet<String> allServerInstances = new HashSet<String>();
                TableType tableType = null;
                if (tableTypeString != null) {
                    tableType = TableType.valueOf((String)tableTypeString.toUpperCase());
                }
                if (tableType == null || tableType == TableType.OFFLINE) {
                    Set<String> offlineServerInstances = this._pinotHelixResourceManager.getAllInstancesForServerTenantWithType(instanceConfigList, tenantName, TableType.OFFLINE);
                    resourceGetRet.set("OfflineServerInstances", JsonUtils.objectToJsonNode(offlineServerInstances));
                    allServerInstances.addAll(offlineServerInstances);
                }
                if (tableType == null || tableType == TableType.REALTIME) {
                    Set<String> realtimeServerInstances = this._pinotHelixResourceManager.getAllInstancesForServerTenantWithType(instanceConfigList, tenantName, TableType.REALTIME);
                    resourceGetRet.set("RealtimeServerInstances", JsonUtils.objectToJsonNode(realtimeServerInstances));
                    allServerInstances.addAll(realtimeServerInstances);
                }
                if (allServerInstances.isEmpty()) {
                    throw new ControllerApplicationException(LOGGER, "Failed to find any instances for server tenant: " + tenantName + (String)(tableType != null ? "_" + tableType.name() : ""), Response.Status.NOT_FOUND);
                }
                resourceGetRet.set("ServerInstances", JsonUtils.objectToJsonNode(allServerInstances));
            }
            if (tenantType.equalsIgnoreCase("broker")) {
                Set<String> allBrokerInstances = this._pinotHelixResourceManager.getAllInstancesForBrokerTenant(instanceConfigList, tenantName);
                if (allBrokerInstances.isEmpty()) {
                    throw new ControllerApplicationException(LOGGER, "Failed to find any instances for broker tenant: " + tenantName, Response.Status.NOT_FOUND);
                }
                resourceGetRet.set("BrokerInstances", JsonUtils.objectToJsonNode(allBrokerInstances));
            }
        }
        resourceGetRet.put(TENANT_NAME, tenantName);
        return resourceGetRet.toString();
    }

    @GET
    @Path(value="/tenants/{tenantName}/metadata")
    @Authorize(targetType=TargetType.CLUSTER, action="GetTenant")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get tenant information")
    @ApiResponses(value={@ApiResponse(code=200, message="Success", response=TenantMetadata.class), @ApiResponse(code=404, message="Tenant not found"), @ApiResponse(code=500, message="Server error reading tenant information")})
    public TenantMetadata getTenantMetadata(@ApiParam(value="Tenant name", required=true) @PathParam(value="tenantName") String tenantName, @ApiParam(value="tenant type", required=false, defaultValue="", allowableValues="SERVER, BROKER") @QueryParam(value="type") @DefaultValue(value="") String type) {
        TenantMetadata tenantMeta = new TenantMetadata();
        if (type == null || type.isEmpty()) {
            tenantMeta._serverInstances = this._pinotHelixResourceManager.getAllInstancesForServerTenant(tenantName);
            tenantMeta._brokerInstances = this._pinotHelixResourceManager.getAllInstancesForBrokerTenant(tenantName);
        } else {
            if (type.equalsIgnoreCase("server")) {
                tenantMeta._serverInstances = this._pinotHelixResourceManager.getAllInstancesForServerTenant(tenantName);
            }
            if (type.equalsIgnoreCase("broker")) {
                tenantMeta._brokerInstances = this._pinotHelixResourceManager.getAllInstancesForBrokerTenant(tenantName);
            }
        }
        tenantMeta._tenantName = tenantName;
        return tenantMeta;
    }

    @Deprecated
    @POST
    @Path(value="/tenants/{tenantName}/metadata")
    @Authorize(targetType=TargetType.CLUSTER, action="UpdateTenantMetadata")
    @Authenticate(value=AccessType.UPDATE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Change tenant state")
    @ApiResponses(value={@ApiResponse(code=200, message="Success", response=String.class), @ApiResponse(code=404, message="Tenant not found"), @ApiResponse(code=500, message="Server error reading tenant information")})
    public String changeTenantState(@ApiParam(value="Tenant name", required=true) @PathParam(value="tenantName") String tenantName, @ApiParam(value="tenant type", required=false, defaultValue="", allowableValues="SERVER, BROKER") @QueryParam(value="type") String type, @ApiParam(value="state", required=true, defaultValue="", allowableValues="enable, disable, drop") @QueryParam(value="state") @DefaultValue(value="") String state) {
        TenantMetadata tenantMetadata = this.getTenantMetadata(tenantName, type);
        HashSet<String> allInstances = new HashSet<String>();
        if (tenantMetadata._brokerInstances != null) {
            allInstances.addAll(tenantMetadata._brokerInstances);
        }
        if (tenantMetadata._serverInstances != null) {
            allInstances.addAll(tenantMetadata._serverInstances);
        }
        if (StateType.DROP.name().equalsIgnoreCase(state)) {
            if (!allInstances.isEmpty()) {
                throw new ControllerApplicationException(LOGGER, "Tenant " + tenantName + " has live instance", Response.Status.BAD_REQUEST);
            }
            this._pinotHelixResourceManager.deleteBrokerTenantFor(tenantName);
            this._pinotHelixResourceManager.deleteOfflineServerTenantFor(tenantName);
            this._pinotHelixResourceManager.deleteRealtimeServerTenantFor(tenantName);
            try {
                return JsonUtils.objectToString((Object)new SuccessResponse("Deleted tenant " + tenantName));
            }
            catch (JsonProcessingException e) {
                LOGGER.error("Error serializing response to json");
                return "{\"message\" : \"Deleted tenant\" " + tenantName + "}";
            }
        }
        boolean enable = StateType.ENABLE.name().equalsIgnoreCase(state);
        ObjectNode instanceResult = JsonUtils.newObjectNode();
        String instance = null;
        try {
            Iterator iterator = allInstances.iterator();
            while (iterator.hasNext()) {
                String i;
                instance = i = (String)iterator.next();
                if (enable) {
                    instanceResult.set(instance, JsonUtils.objectToJsonNode((Object)this._pinotHelixResourceManager.enableInstance(instance)));
                    continue;
                }
                instanceResult.set(instance, JsonUtils.objectToJsonNode((Object)this._pinotHelixResourceManager.disableInstance(instance)));
            }
        }
        catch (Exception e) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_INSTANCE_POST_ERROR, 1L);
            throw new ControllerApplicationException(LOGGER, String.format("Error during %s operation for instance: %s", type, instance), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        return instanceResult.toString();
    }

    @DELETE
    @Path(value="/tenants/{tenantName}")
    @Authorize(targetType=TargetType.CLUSTER, action="DeleteTenant")
    @Authenticate(value=AccessType.DELETE)
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a tenant")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Tenant can not be deleted"), @ApiResponse(code=404, message="Tenant not found"), @ApiResponse(code=500, message="Error deleting tenant")})
    public SuccessResponse deleteTenant(@ApiParam(value="Tenant name", required=true) @PathParam(value="tenantName") String tenantName, @ApiParam(value="Tenant type", required=true, allowableValues="SERVER, BROKER") @QueryParam(value="type") @DefaultValue(value="") String type) {
        if (type == null || type.isEmpty()) {
            throw new ControllerApplicationException(LOGGER, "Tenant type (BROKER | SERVER) is required as query parameter", Response.Status.INTERNAL_SERVER_ERROR);
        }
        TenantRole tenantRole = TenantRole.valueOf((String)type.toUpperCase());
        PinotResourceManagerResponse res = null;
        switch (tenantRole) {
            case BROKER: {
                if (this._pinotHelixResourceManager.isBrokerTenantDeletable(tenantName)) {
                    res = this._pinotHelixResourceManager.deleteBrokerTenantFor(tenantName);
                    break;
                }
                throw new ControllerApplicationException(LOGGER, "Broker tenant is not null, can not delete it", Response.Status.BAD_REQUEST);
            }
            case SERVER: {
                if (this._pinotHelixResourceManager.isServerTenantDeletable(tenantName)) {
                    res = this._pinotHelixResourceManager.deleteOfflineServerTenantFor(tenantName);
                    if (!res.isSuccessful()) break;
                    res = this._pinotHelixResourceManager.deleteRealtimeServerTenantFor(tenantName);
                    break;
                }
                throw new ControllerApplicationException(LOGGER, "Server tenant is not null, can not delete it", Response.Status.BAD_REQUEST);
            }
        }
        if (res.isSuccessful()) {
            return new SuccessResponse("Successfully deleted tenant " + tenantName);
        }
        this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_TENANT_DELETE_ERROR, 1L);
        throw new ControllerApplicationException(LOGGER, "Error deleting tenant", Response.Status.INTERNAL_SERVER_ERROR);
    }

    @POST
    @Produces(value={"application/json"})
    @Authenticate(value=AccessType.UPDATE)
    @Authorize(targetType=TargetType.CLUSTER, action="RebalanceTenantTables")
    @Path(value="/tenants/{tenantName}/rebalance")
    @ApiOperation(value="Rebalances all the tables that are part of the tenant")
    public TenantRebalanceResult rebalance(@ApiParam(value="Name of the tenant whose table are to be rebalanced", required=true) @PathParam(value="tenantName") String tenantName, @ApiParam(required=true) TenantRebalanceConfig config) {
        config.setTenantName(tenantName);
        return this._tenantRebalancer.rebalance(config);
    }

    @GET
    @Produces(value={"application/json"})
    @Authenticate(value=AccessType.READ)
    @Authorize(targetType=TargetType.CLUSTER, action="GetRebalanceStatus")
    @Path(value="/tenants/rebalanceStatus/{jobId}")
    @ApiOperation(value="Gets detailed stats of a tenant rebalance operation", notes="Gets detailed stats of a tenant rebalance operation")
    public TenantRebalanceJobStatusResponse rebalanceStatus(@ApiParam(value="Tenant rebalance job id", required=true) @PathParam(value="jobId") String jobId) throws JsonProcessingException {
        Map<String, String> controllerJobZKMetadata = this._pinotHelixResourceManager.getControllerJobZKMetadata(jobId, ControllerJobType.TENANT_REBALANCE);
        if (controllerJobZKMetadata == null) {
            throw new ControllerApplicationException(LOGGER, "Failed to find controller job id: " + jobId, Response.Status.NOT_FOUND);
        }
        TenantRebalanceProgressStats tenantRebalanceProgressStats = (TenantRebalanceProgressStats)JsonUtils.stringToObject((String)controllerJobZKMetadata.get("REBALANCE_PROGRESS_STATS"), TenantRebalanceProgressStats.class);
        long timeSinceStartInSecs = tenantRebalanceProgressStats.getTimeToFinishInSeconds();
        if (tenantRebalanceProgressStats.getCompletionStatusMsg() == null) {
            timeSinceStartInSecs = (System.currentTimeMillis() - tenantRebalanceProgressStats.getStartTimeMs()) / 1000L;
        }
        TenantRebalanceJobStatusResponse tenantRebalanceJobStatusResponse = new TenantRebalanceJobStatusResponse();
        tenantRebalanceJobStatusResponse.setTenantRebalanceProgressStats(tenantRebalanceProgressStats);
        tenantRebalanceJobStatusResponse.setTimeElapsedSinceStartInSeconds(timeSinceStartInSecs);
        return tenantRebalanceJobStatusResponse;
    }

    public static class TenantsList {
        @JsonProperty(value="SERVER_TENANTS")
        Set<String> _serverTenants;
        @JsonProperty(value="BROKER_TENANTS")
        Set<String> _brokerTenants;
    }

    public static class TenantMetadata {
        @JsonProperty(value="ServerInstances")
        Set<String> _serverInstances;
        @JsonProperty(value="OfflineServerInstances")
        Set<String> _offlineServerInstances;
        @JsonProperty(value="RealtimeServerInstances")
        Set<String> _realtimeServerInstances;
        @JsonProperty(value="BrokerInstances")
        Set<String> _brokerInstances;
        @JsonProperty(value="tenantName")
        String _tenantName;
    }
}

