/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.exception.HttpErrorStatusException;
import org.apache.pinot.common.utils.SimpleHttpResponse;
import org.apache.pinot.common.utils.http.HttpClient;
import org.apache.pinot.controller.api.resources.PauseStatus;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.tenant.Tenant;
import org.apache.pinot.spi.config.tenant.TenantRole;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.builder.ControllerRequestURLBuilder;

public class ControllerRequestClient {
    private final HttpClient _httpClient;
    private final ControllerRequestURLBuilder _controllerRequestURLBuilder;

    public ControllerRequestClient(ControllerRequestURLBuilder controllerRequestUrlBuilder, HttpClient httpClient) {
        this._controllerRequestURLBuilder = controllerRequestUrlBuilder;
        this._httpClient = httpClient;
    }

    public ControllerRequestURLBuilder getControllerRequestURLBuilder() {
        return this._controllerRequestURLBuilder;
    }

    public void addSchema(Schema schema) throws IOException {
        String url = this._controllerRequestURLBuilder.forSchemaCreate();
        try {
            HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendMultipartPostRequest(url, schema.toSingleLineJsonString()));
        }
        catch (HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public Schema getSchema(String schemaName) throws IOException {
        String url = this._controllerRequestURLBuilder.forSchemaGet(schemaName);
        try {
            SimpleHttpResponse resp = HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendGetRequest(new URL(url).toURI()));
            return Schema.fromString((String)resp.getResponse());
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public void updateSchema(Schema schema) throws IOException {
        String url = this._controllerRequestURLBuilder.forSchemaUpdate(schema.getSchemaName());
        try {
            HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendMultipartPutRequest(url, schema.toSingleLineJsonString()));
        }
        catch (HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public void deleteSchema(String schemaName) throws IOException {
        String url = this._controllerRequestURLBuilder.forSchemaDelete(schemaName);
        try {
            HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendDeleteRequest(new URL(url).toURI()));
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public void addTableConfig(TableConfig tableConfig) throws IOException {
        try {
            HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendJsonPostRequest(new URL(this._controllerRequestURLBuilder.forTableCreate()).toURI(), tableConfig.toJsonString()));
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public void updateTableConfig(TableConfig tableConfig) throws IOException {
        try {
            HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendJsonPutRequest(new URL(this._controllerRequestURLBuilder.forUpdateTableConfig(tableConfig.getTableName())).toURI(), tableConfig.toJsonString()));
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public void deleteTable(String tableNameWithType) throws IOException {
        try {
            HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendDeleteRequest(new URL(this._controllerRequestURLBuilder.forTableDelete(tableNameWithType)).toURI()));
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public TableConfig getTableConfig(String tableName, TableType tableType) throws IOException {
        try {
            SimpleHttpResponse response = HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendGetRequest(new URL(this._controllerRequestURLBuilder.forTableGet(tableName)).toURI()));
            return (TableConfig)JsonUtils.jsonNodeToObject((JsonNode)JsonUtils.stringToJsonNode((String)response.getResponse()).get(tableType.toString()), TableConfig.class);
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public long getTableSize(String tableName) throws IOException {
        try {
            SimpleHttpResponse response = HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendGetRequest(new URL(this._controllerRequestURLBuilder.forTableSize(tableName)).toURI()));
            return Long.parseLong(JsonUtils.stringToJsonNode((String)response.getResponse()).get("reportedSizeInBytes").asText());
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public void resetTable(String tableNameWithType, String targetInstance) throws IOException {
        try {
            HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendJsonPostRequest(new URL(this._controllerRequestURLBuilder.forTableReset(tableNameWithType, targetInstance)).toURI(), null));
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public void resetSegment(String tableNameWithType, String segmentName, String targetInstance) throws IOException {
        try {
            HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendJsonPostRequest(new URL(this._controllerRequestURLBuilder.forSegmentReset(tableNameWithType, segmentName, targetInstance)).toURI(), null));
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public String reloadTable(String tableName, TableType tableType, boolean forceDownload) throws IOException {
        try {
            SimpleHttpResponse simpleHttpResponse = HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendJsonPostRequest(new URL(this._controllerRequestURLBuilder.forTableReload(tableName, tableType, forceDownload)).toURI(), null));
            return simpleHttpResponse.getResponse();
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public void reloadSegment(String tableName, String segmentName, boolean forceReload) throws IOException {
        try {
            HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendJsonPostRequest(new URL(this._controllerRequestURLBuilder.forSegmentReload(tableName, segmentName, forceReload)).toURI(), null));
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public List<String> listSegments(String tableName, @Nullable String tableType, boolean excludeReplacedSegments) throws IOException {
        String url = this._controllerRequestURLBuilder.forSegmentListAPI(tableName, tableType, excludeReplacedSegments);
        try {
            SimpleHttpResponse resp = HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendGetRequest(new URL(url).toURI()));
            JsonNode jsonNode = JsonUtils.stringToJsonNode((String)resp.getResponse());
            ArrayList<String> segments = new ArrayList<String>();
            for (JsonNode tableNode : jsonNode) {
                ArrayNode segmentsNode = (ArrayNode)tableNode.elements().next();
                for (JsonNode segmentNode : segmentsNode) {
                    segments.add(segmentNode.asText());
                }
            }
            return segments;
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public void deleteSegment(String tableName, String segmentName) throws IOException {
        try {
            HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendDeleteRequest(new URL(this._controllerRequestURLBuilder.forSegmentDelete(tableName, segmentName)).toURI()));
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public void deleteSegments(String tableName, TableType tableType) throws IOException {
        try {
            HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendDeleteRequest(new URL(this._controllerRequestURLBuilder.forSegmentDeleteAll(tableName, tableType.toString())).toURI()));
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public PauseStatus pauseConsumption(String tableName) throws IOException {
        try {
            SimpleHttpResponse response = HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendJsonPostRequest(new URL(this._controllerRequestURLBuilder.forPauseConsumption(tableName)).toURI(), null));
            return (PauseStatus)JsonUtils.stringToObject((String)response.getResponse(), PauseStatus.class);
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public PauseStatus resumeConsumption(String tableName) throws IOException {
        try {
            SimpleHttpResponse response = HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendJsonPostRequest(new URL(this._controllerRequestURLBuilder.forResumeConsumption(tableName)).toURI(), null));
            return (PauseStatus)JsonUtils.stringToObject((String)response.getResponse(), PauseStatus.class);
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public PauseStatus getPauseStatus(String tableName) throws IOException {
        try {
            SimpleHttpResponse response = HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendGetRequest(new URL(this._controllerRequestURLBuilder.forPauseStatus(tableName)).toURI()));
            return (PauseStatus)JsonUtils.stringToObject((String)response.getResponse(), PauseStatus.class);
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public void createBrokerTenant(String tenantName, int numBrokers) throws IOException {
        try {
            HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendJsonPostRequest(new URL(this._controllerRequestURLBuilder.forTenantCreate()).toURI(), this.getBrokerTenantRequestPayload(tenantName, numBrokers)));
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public void updateBrokerTenant(String tenantName, int numBrokers) throws IOException {
        try {
            HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendJsonPutRequest(new URL(this._controllerRequestURLBuilder.forTenantCreate()).toURI(), this.getBrokerTenantRequestPayload(tenantName, numBrokers)));
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public void deleteBrokerTenant(String tenantName) throws IOException {
        try {
            HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendDeleteRequest(new URL(this._controllerRequestURLBuilder.forBrokerTenantDelete(tenantName)).toURI()));
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public void createServerTenant(String tenantName, int numOfflineServers, int numRealtimeServers) throws IOException {
        try {
            HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendJsonPostRequest(new URL(this._controllerRequestURLBuilder.forTenantCreate()).toURI(), ControllerRequestClient.getServerTenantRequestPayload(tenantName, numOfflineServers, numRealtimeServers)));
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public void updateServerTenant(String tenantName, int numOfflineServers, int numRealtimeServers) throws IOException {
        try {
            HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendJsonPutRequest(new URL(this._controllerRequestURLBuilder.forTenantCreate()).toURI(), ControllerRequestClient.getServerTenantRequestPayload(tenantName, numOfflineServers, numRealtimeServers)));
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    public void runPeriodicTask(String taskName) throws IOException {
        try {
            HttpClient.wrapAndThrowHttpException((SimpleHttpResponse)this._httpClient.sendGetRequest(new URL(this._controllerRequestURLBuilder.forPeriodTaskRun(taskName)).toURI()));
        }
        catch (URISyntaxException | HttpErrorStatusException e) {
            throw new IOException(e);
        }
    }

    protected String getBrokerTenantRequestPayload(String tenantName, int numBrokers) {
        return new Tenant(TenantRole.BROKER, tenantName, numBrokers, 0, 0).toJsonString();
    }

    protected static String getServerTenantRequestPayload(String tenantName, int numOfflineServers, int numRealtimeServers) {
        return new Tenant(TenantRole.SERVER, tenantName, numOfflineServers + numRealtimeServers, numOfflineServers, numRealtimeServers).toJsonString();
    }
}

