/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.builder.CustomModeISBuilder;
import org.apache.pinot.spi.stream.PartitionGroupConsumptionStatus;
import org.apache.pinot.spi.stream.PartitionGroupMetadata;
import org.apache.pinot.spi.stream.PartitionGroupMetadataFetcher;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.utils.retry.RetryPolicies;
import org.apache.pinot.spi.utils.retry.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotTableIdealStateBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotTableIdealStateBuilder.class);
    private static final RetryPolicy DEFAULT_IDEALSTATE_UPDATE_RETRY_POLICY = RetryPolicies.randomDelayRetryPolicy((int)3, (long)100L, (long)200L);

    private PinotTableIdealStateBuilder() {
    }

    public static IdealState buildEmptyIdealStateFor(String tableNameWithType, int numReplicas, boolean enableBatchMessageMode) {
        CustomModeISBuilder customModeIdealStateBuilder = new CustomModeISBuilder(tableNameWithType);
        customModeIdealStateBuilder.setStateModel("SegmentOnlineOfflineStateModel").setNumPartitions(0).setNumReplica(numReplicas).setMaxPartitionsPerNode(1);
        IdealState idealState = customModeIdealStateBuilder.build();
        idealState.setInstanceGroupTag(tableNameWithType);
        idealState.setBatchMessageMode(enableBatchMessageMode);
        return idealState;
    }

    public static List<PartitionGroupMetadata> getPartitionGroupMetadataList(StreamConfig streamConfig, List<PartitionGroupConsumptionStatus> partitionGroupConsumptionStatusList) {
        PartitionGroupMetadataFetcher partitionGroupMetadataFetcher = new PartitionGroupMetadataFetcher(streamConfig, partitionGroupConsumptionStatusList);
        try {
            DEFAULT_IDEALSTATE_UPDATE_RETRY_POLICY.attempt((Callable)partitionGroupMetadataFetcher);
            return partitionGroupMetadataFetcher.getPartitionGroupMetadataList();
        }
        catch (Exception e) {
            Exception fetcherException = partitionGroupMetadataFetcher.getException();
            LOGGER.error("Could not get PartitionGroupMetadata for topic: {} of table: {}", new Object[]{streamConfig.getTopicName(), streamConfig.getTableNameWithType(), fetcherException});
            throw new RuntimeException(fetcherException);
        }
    }
}

